<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckLandedCostList StructType
 * @subpackage Structs
 */
class CheckLandedCostList extends AbstractStructBase
{
    /**
     * The landedCost
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LandedCostSummary[]
     */
    public $landedCost;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CheckLandedCostList
     * @uses CheckLandedCostList::setLandedCost()
     * @uses CheckLandedCostList::setReplaceAll()
     * @param \StructType\LandedCostSummary[] $landedCost
     * @param bool $replaceAll
     */
    public function __construct(array $landedCost = array(), $replaceAll = true)
    {
        $this
            ->setLandedCost($landedCost)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get landedCost value
     * @return \StructType\LandedCostSummary[]|null
     */
    public function getLandedCost()
    {
        return $this->landedCost;
    }
    /**
     * This method is responsible for validating the values passed to the setLandedCost method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLandedCost method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLandedCostForArrayConstraintsFromSetLandedCost(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $checkLandedCostListLandedCostItem) {
            // validation for constraint: itemType
            if (!$checkLandedCostListLandedCostItem instanceof \StructType\LandedCostSummary) {
                $invalidValues[] = is_object($checkLandedCostListLandedCostItem) ? get_class($checkLandedCostListLandedCostItem) : sprintf('%s(%s)', gettype($checkLandedCostListLandedCostItem), var_export($checkLandedCostListLandedCostItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The landedCost property can only contain items of type \StructType\LandedCostSummary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set landedCost value
     * @throws \InvalidArgumentException
     * @param \StructType\LandedCostSummary[] $landedCost
     * @return \StructType\CheckLandedCostList
     */
    public function setLandedCost(array $landedCost = array())
    {
        // validation for constraint: array
        if ('' !== ($landedCostArrayErrorMessage = self::validateLandedCostForArrayConstraintsFromSetLandedCost($landedCost))) {
            throw new \InvalidArgumentException($landedCostArrayErrorMessage, __LINE__);
        }
        $this->landedCost = $landedCost;
        return $this;
    }
    /**
     * Add item to landedCost value
     * @throws \InvalidArgumentException
     * @param \StructType\LandedCostSummary $item
     * @return \StructType\CheckLandedCostList
     */
    public function addToLandedCost(\StructType\LandedCostSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LandedCostSummary) {
            throw new \InvalidArgumentException(sprintf('The landedCost property can only contain items of type \StructType\LandedCostSummary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->landedCost[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CheckLandedCostList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
