<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckItem StructType
 * @subpackage Structs
 */
class CheckItem extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The vendorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vendorName;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The binNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $binNumbers;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The taxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate2;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The isBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBillable;
    /**
     * The landedCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LandedCost
     */
    public $landedCost;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for CheckItem
     * @uses CheckItem::setItem()
     * @uses CheckItem::setVendorName()
     * @uses CheckItem::setLine()
     * @uses CheckItem::setQuantity()
     * @uses CheckItem::setUnits()
     * @uses CheckItem::setInventoryDetail()
     * @uses CheckItem::setDescription()
     * @uses CheckItem::setBinNumbers()
     * @uses CheckItem::setSerialNumbers()
     * @uses CheckItem::setExpirationDate()
     * @uses CheckItem::setRate()
     * @uses CheckItem::setTaxCode()
     * @uses CheckItem::setAmount()
     * @uses CheckItem::setOptions()
     * @uses CheckItem::setTaxRate1()
     * @uses CheckItem::setTaxRate2()
     * @uses CheckItem::setDepartment()
     * @uses CheckItem::setGrossAmt()
     * @uses CheckItem::setClass()
     * @uses CheckItem::setTax1Amt()
     * @uses CheckItem::setLocation()
     * @uses CheckItem::setCustomer()
     * @uses CheckItem::setIsBillable()
     * @uses CheckItem::setLandedCost()
     * @uses CheckItem::setCustomFieldList()
     * @param \StructType\RecordRef $item
     * @param string $vendorName
     * @param int $line
     * @param float $quantity
     * @param \StructType\RecordRef $units
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $description
     * @param string $binNumbers
     * @param string $serialNumbers
     * @param string $expirationDate
     * @param string $rate
     * @param \StructType\RecordRef $taxCode
     * @param float $amount
     * @param \StructType\CustomFieldList $options
     * @param float $taxRate1
     * @param float $taxRate2
     * @param \StructType\RecordRef $department
     * @param float $grossAmt
     * @param \StructType\RecordRef $class
     * @param float $tax1Amt
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $customer
     * @param bool $isBillable
     * @param \StructType\LandedCost $landedCost
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $item = null, $vendorName = null, $line = null, $quantity = null, \StructType\RecordRef $units = null, \StructType\InventoryDetail $inventoryDetail = null, $description = null, $binNumbers = null, $serialNumbers = null, $expirationDate = null, $rate = null, \StructType\RecordRef $taxCode = null, $amount = null, \StructType\CustomFieldList $options = null, $taxRate1 = null, $taxRate2 = null, \StructType\RecordRef $department = null, $grossAmt = null, \StructType\RecordRef $class = null, $tax1Amt = null, \StructType\RecordRef $location = null, \StructType\RecordRef $customer = null, $isBillable = null, \StructType\LandedCost $landedCost = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setItem($item)
            ->setVendorName($vendorName)
            ->setLine($line)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setInventoryDetail($inventoryDetail)
            ->setDescription($description)
            ->setBinNumbers($binNumbers)
            ->setSerialNumbers($serialNumbers)
            ->setExpirationDate($expirationDate)
            ->setRate($rate)
            ->setTaxCode($taxCode)
            ->setAmount($amount)
            ->setOptions($options)
            ->setTaxRate1($taxRate1)
            ->setTaxRate2($taxRate2)
            ->setDepartment($department)
            ->setGrossAmt($grossAmt)
            ->setClass($class)
            ->setTax1Amt($tax1Amt)
            ->setLocation($location)
            ->setCustomer($customer)
            ->setIsBillable($isBillable)
            ->setLandedCost($landedCost)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\CheckItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get vendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->vendorName;
    }
    /**
     * Set vendorName value
     * @param string $vendorName
     * @return \StructType\CheckItem
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->vendorName = $vendorName;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\CheckItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\CheckItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\CheckItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\CheckItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CheckItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get binNumbers value
     * @return string|null
     */
    public function getBinNumbers()
    {
        return $this->binNumbers;
    }
    /**
     * Set binNumbers value
     * @param string $binNumbers
     * @return \StructType\CheckItem
     */
    public function setBinNumbers($binNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($binNumbers) && !is_string($binNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binNumbers, true), gettype($binNumbers)), __LINE__);
        }
        $this->binNumbers = $binNumbers;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\CheckItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\CheckItem
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\CheckItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\CheckItem
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\CheckItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\CheckItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\CheckItem
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get taxRate2 value
     * @return float|null
     */
    public function getTaxRate2()
    {
        return $this->taxRate2;
    }
    /**
     * Set taxRate2 value
     * @param float $taxRate2
     * @return \StructType\CheckItem
     */
    public function setTaxRate2($taxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate2) && !(is_float($taxRate2) || is_numeric($taxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate2, true), gettype($taxRate2)), __LINE__);
        }
        $this->taxRate2 = $taxRate2;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\CheckItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\CheckItem
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\CheckItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\CheckItem
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\CheckItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\CheckItem
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get isBillable value
     * @return bool|null
     */
    public function getIsBillable()
    {
        return $this->isBillable;
    }
    /**
     * Set isBillable value
     * @param bool $isBillable
     * @return \StructType\CheckItem
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        $this->isBillable = $isBillable;
        return $this;
    }
    /**
     * Get landedCost value
     * @return \StructType\LandedCost|null
     */
    public function getLandedCost()
    {
        return $this->landedCost;
    }
    /**
     * Set landedCost value
     * @param \StructType\LandedCost $landedCost
     * @return \StructType\CheckItem
     */
    public function setLandedCost(\StructType\LandedCost $landedCost = null)
    {
        $this->landedCost = $landedCost;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CheckItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
