<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeSearchBasic StructType
 * @subpackage Structs
 */
class ChargeSearchBasic extends SearchRecordBasic
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $amount;
    /**
     * The billingAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $billingAccount;
    /**
     * The billingItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $billingItem;
    /**
     * The billTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $billTo;
    /**
     * The chargeDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $chargeDate;
    /**
     * The chargeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $chargeType;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $class;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $createdDate;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $currency;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $department;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $externalId;
    /**
     * The externalIdString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $externalIdString;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $internalId;
    /**
     * The internalIdNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $internalIdNumber;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $location;
    /**
     * The modifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $modifiedDate;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The postingPeriodRelative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postingPeriodRelative;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $quantity;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $rate;
    /**
     * The rule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $rule;
    /**
     * The runId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $runId;
    /**
     * The salesOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $salesOrder;
    /**
     * The stage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchEnumMultiSelectField
     */
    public $stage;
    /**
     * The subscriptionLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $subscriptionLine;
    /**
     * The use
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchEnumMultiSelectField
     */
    public $use;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for ChargeSearchBasic
     * @uses ChargeSearchBasic::setAmount()
     * @uses ChargeSearchBasic::setBillingAccount()
     * @uses ChargeSearchBasic::setBillingItem()
     * @uses ChargeSearchBasic::setBillTo()
     * @uses ChargeSearchBasic::setChargeDate()
     * @uses ChargeSearchBasic::setChargeType()
     * @uses ChargeSearchBasic::setClass()
     * @uses ChargeSearchBasic::setCreatedDate()
     * @uses ChargeSearchBasic::setCurrency()
     * @uses ChargeSearchBasic::setDepartment()
     * @uses ChargeSearchBasic::setExternalId()
     * @uses ChargeSearchBasic::setExternalIdString()
     * @uses ChargeSearchBasic::setInternalId()
     * @uses ChargeSearchBasic::setInternalIdNumber()
     * @uses ChargeSearchBasic::setLocation()
     * @uses ChargeSearchBasic::setModifiedDate()
     * @uses ChargeSearchBasic::setPostingPeriod()
     * @uses ChargeSearchBasic::setPostingPeriodRelative()
     * @uses ChargeSearchBasic::setQuantity()
     * @uses ChargeSearchBasic::setRate()
     * @uses ChargeSearchBasic::setRule()
     * @uses ChargeSearchBasic::setRunId()
     * @uses ChargeSearchBasic::setSalesOrder()
     * @uses ChargeSearchBasic::setStage()
     * @uses ChargeSearchBasic::setSubscriptionLine()
     * @uses ChargeSearchBasic::setUse()
     * @uses ChargeSearchBasic::setCustomFieldList()
     * @param \StructType\SearchDoubleField $amount
     * @param \StructType\SearchMultiSelectField $billingAccount
     * @param \StructType\SearchMultiSelectField $billingItem
     * @param \StructType\SearchMultiSelectField $billTo
     * @param \StructType\SearchDateField $chargeDate
     * @param \StructType\SearchMultiSelectField $chargeType
     * @param \StructType\SearchMultiSelectField $class
     * @param \StructType\SearchDateField $createdDate
     * @param \StructType\SearchMultiSelectField $currency
     * @param \StructType\SearchMultiSelectField $department
     * @param \StructType\SearchMultiSelectField $externalId
     * @param \StructType\SearchStringField $externalIdString
     * @param \StructType\SearchMultiSelectField $internalId
     * @param \StructType\SearchLongField $internalIdNumber
     * @param \StructType\SearchMultiSelectField $location
     * @param \StructType\SearchDateField $modifiedDate
     * @param \StructType\RecordRef $postingPeriod
     * @param string $postingPeriodRelative
     * @param \StructType\SearchDoubleField $quantity
     * @param \StructType\SearchDoubleField $rate
     * @param \StructType\SearchMultiSelectField $rule
     * @param \StructType\SearchStringField $runId
     * @param \StructType\SearchLongField $salesOrder
     * @param \StructType\SearchEnumMultiSelectField $stage
     * @param \StructType\SearchMultiSelectField $subscriptionLine
     * @param \StructType\SearchEnumMultiSelectField $use
     * @param \StructType\SearchCustomFieldList $customFieldList
     */
    public function __construct(\StructType\SearchDoubleField $amount = null, \StructType\SearchMultiSelectField $billingAccount = null, \StructType\SearchMultiSelectField $billingItem = null, \StructType\SearchMultiSelectField $billTo = null, \StructType\SearchDateField $chargeDate = null, \StructType\SearchMultiSelectField $chargeType = null, \StructType\SearchMultiSelectField $class = null, \StructType\SearchDateField $createdDate = null, \StructType\SearchMultiSelectField $currency = null, \StructType\SearchMultiSelectField $department = null, \StructType\SearchMultiSelectField $externalId = null, \StructType\SearchStringField $externalIdString = null, \StructType\SearchMultiSelectField $internalId = null, \StructType\SearchLongField $internalIdNumber = null, \StructType\SearchMultiSelectField $location = null, \StructType\SearchDateField $modifiedDate = null, \StructType\RecordRef $postingPeriod = null, $postingPeriodRelative = null, \StructType\SearchDoubleField $quantity = null, \StructType\SearchDoubleField $rate = null, \StructType\SearchMultiSelectField $rule = null, \StructType\SearchStringField $runId = null, \StructType\SearchLongField $salesOrder = null, \StructType\SearchEnumMultiSelectField $stage = null, \StructType\SearchMultiSelectField $subscriptionLine = null, \StructType\SearchEnumMultiSelectField $use = null, \StructType\SearchCustomFieldList $customFieldList = null)
    {
        $this
            ->setAmount($amount)
            ->setBillingAccount($billingAccount)
            ->setBillingItem($billingItem)
            ->setBillTo($billTo)
            ->setChargeDate($chargeDate)
            ->setChargeType($chargeType)
            ->setClass($class)
            ->setCreatedDate($createdDate)
            ->setCurrency($currency)
            ->setDepartment($department)
            ->setExternalId($externalId)
            ->setExternalIdString($externalIdString)
            ->setInternalId($internalId)
            ->setInternalIdNumber($internalIdNumber)
            ->setLocation($location)
            ->setModifiedDate($modifiedDate)
            ->setPostingPeriod($postingPeriod)
            ->setPostingPeriodRelative($postingPeriodRelative)
            ->setQuantity($quantity)
            ->setRate($rate)
            ->setRule($rule)
            ->setRunId($runId)
            ->setSalesOrder($salesOrder)
            ->setStage($stage)
            ->setSubscriptionLine($subscriptionLine)
            ->setUse($use)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get amount value
     * @return \StructType\SearchDoubleField|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param \StructType\SearchDoubleField $amount
     * @return \StructType\ChargeSearchBasic
     */
    public function setAmount(\StructType\SearchDoubleField $amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get billingAccount value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getBillingAccount()
    {
        return $this->billingAccount;
    }
    /**
     * Set billingAccount value
     * @param \StructType\SearchMultiSelectField $billingAccount
     * @return \StructType\ChargeSearchBasic
     */
    public function setBillingAccount(\StructType\SearchMultiSelectField $billingAccount = null)
    {
        $this->billingAccount = $billingAccount;
        return $this;
    }
    /**
     * Get billingItem value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getBillingItem()
    {
        return $this->billingItem;
    }
    /**
     * Set billingItem value
     * @param \StructType\SearchMultiSelectField $billingItem
     * @return \StructType\ChargeSearchBasic
     */
    public function setBillingItem(\StructType\SearchMultiSelectField $billingItem = null)
    {
        $this->billingItem = $billingItem;
        return $this;
    }
    /**
     * Get billTo value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getBillTo()
    {
        return $this->billTo;
    }
    /**
     * Set billTo value
     * @param \StructType\SearchMultiSelectField $billTo
     * @return \StructType\ChargeSearchBasic
     */
    public function setBillTo(\StructType\SearchMultiSelectField $billTo = null)
    {
        $this->billTo = $billTo;
        return $this;
    }
    /**
     * Get chargeDate value
     * @return \StructType\SearchDateField|null
     */
    public function getChargeDate()
    {
        return $this->chargeDate;
    }
    /**
     * Set chargeDate value
     * @param \StructType\SearchDateField $chargeDate
     * @return \StructType\ChargeSearchBasic
     */
    public function setChargeDate(\StructType\SearchDateField $chargeDate = null)
    {
        $this->chargeDate = $chargeDate;
        return $this;
    }
    /**
     * Get chargeType value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getChargeType()
    {
        return $this->chargeType;
    }
    /**
     * Set chargeType value
     * @param \StructType\SearchMultiSelectField $chargeType
     * @return \StructType\ChargeSearchBasic
     */
    public function setChargeType(\StructType\SearchMultiSelectField $chargeType = null)
    {
        $this->chargeType = $chargeType;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\SearchMultiSelectField $class
     * @return \StructType\ChargeSearchBasic
     */
    public function setClass(\StructType\SearchMultiSelectField $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get createdDate value
     * @return \StructType\SearchDateField|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param \StructType\SearchDateField $createdDate
     * @return \StructType\ChargeSearchBasic
     */
    public function setCreatedDate(\StructType\SearchDateField $createdDate = null)
    {
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\SearchMultiSelectField $currency
     * @return \StructType\ChargeSearchBasic
     */
    public function setCurrency(\StructType\SearchMultiSelectField $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\SearchMultiSelectField $department
     * @return \StructType\ChargeSearchBasic
     */
    public function setDepartment(\StructType\SearchMultiSelectField $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param \StructType\SearchMultiSelectField $externalId
     * @return \StructType\ChargeSearchBasic
     */
    public function setExternalId(\StructType\SearchMultiSelectField $externalId = null)
    {
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Get externalIdString value
     * @return \StructType\SearchStringField|null
     */
    public function getExternalIdString()
    {
        return $this->externalIdString;
    }
    /**
     * Set externalIdString value
     * @param \StructType\SearchStringField $externalIdString
     * @return \StructType\ChargeSearchBasic
     */
    public function setExternalIdString(\StructType\SearchStringField $externalIdString = null)
    {
        $this->externalIdString = $externalIdString;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param \StructType\SearchMultiSelectField $internalId
     * @return \StructType\ChargeSearchBasic
     */
    public function setInternalId(\StructType\SearchMultiSelectField $internalId = null)
    {
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get internalIdNumber value
     * @return \StructType\SearchLongField|null
     */
    public function getInternalIdNumber()
    {
        return $this->internalIdNumber;
    }
    /**
     * Set internalIdNumber value
     * @param \StructType\SearchLongField $internalIdNumber
     * @return \StructType\ChargeSearchBasic
     */
    public function setInternalIdNumber(\StructType\SearchLongField $internalIdNumber = null)
    {
        $this->internalIdNumber = $internalIdNumber;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\SearchMultiSelectField $location
     * @return \StructType\ChargeSearchBasic
     */
    public function setLocation(\StructType\SearchMultiSelectField $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get modifiedDate value
     * @return \StructType\SearchDateField|null
     */
    public function getModifiedDate()
    {
        return $this->modifiedDate;
    }
    /**
     * Set modifiedDate value
     * @param \StructType\SearchDateField $modifiedDate
     * @return \StructType\ChargeSearchBasic
     */
    public function setModifiedDate(\StructType\SearchDateField $modifiedDate = null)
    {
        $this->modifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\ChargeSearchBasic
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get postingPeriodRelative value
     * @return string|null
     */
    public function getPostingPeriodRelative()
    {
        return $this->postingPeriodRelative;
    }
    /**
     * Set postingPeriodRelative value
     * @uses \EnumType\PostingPeriodDate::valueIsValid()
     * @uses \EnumType\PostingPeriodDate::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $postingPeriodRelative
     * @return \StructType\ChargeSearchBasic
     */
    public function setPostingPeriodRelative($postingPeriodRelative = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PostingPeriodDate::valueIsValid($postingPeriodRelative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PostingPeriodDate', is_array($postingPeriodRelative) ? implode(', ', $postingPeriodRelative) : var_export($postingPeriodRelative, true), implode(', ', \EnumType\PostingPeriodDate::getValidValues())), __LINE__);
        }
        $this->postingPeriodRelative = $postingPeriodRelative;
        return $this;
    }
    /**
     * Get quantity value
     * @return \StructType\SearchDoubleField|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param \StructType\SearchDoubleField $quantity
     * @return \StructType\ChargeSearchBasic
     */
    public function setQuantity(\StructType\SearchDoubleField $quantity = null)
    {
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get rate value
     * @return \StructType\SearchDoubleField|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param \StructType\SearchDoubleField $rate
     * @return \StructType\ChargeSearchBasic
     */
    public function setRate(\StructType\SearchDoubleField $rate = null)
    {
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get rule value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getRule()
    {
        return $this->rule;
    }
    /**
     * Set rule value
     * @param \StructType\SearchMultiSelectField $rule
     * @return \StructType\ChargeSearchBasic
     */
    public function setRule(\StructType\SearchMultiSelectField $rule = null)
    {
        $this->rule = $rule;
        return $this;
    }
    /**
     * Get runId value
     * @return \StructType\SearchStringField|null
     */
    public function getRunId()
    {
        return $this->runId;
    }
    /**
     * Set runId value
     * @param \StructType\SearchStringField $runId
     * @return \StructType\ChargeSearchBasic
     */
    public function setRunId(\StructType\SearchStringField $runId = null)
    {
        $this->runId = $runId;
        return $this;
    }
    /**
     * Get salesOrder value
     * @return \StructType\SearchLongField|null
     */
    public function getSalesOrder()
    {
        return $this->salesOrder;
    }
    /**
     * Set salesOrder value
     * @param \StructType\SearchLongField $salesOrder
     * @return \StructType\ChargeSearchBasic
     */
    public function setSalesOrder(\StructType\SearchLongField $salesOrder = null)
    {
        $this->salesOrder = $salesOrder;
        return $this;
    }
    /**
     * Get stage value
     * @return \StructType\SearchEnumMultiSelectField|null
     */
    public function getStage()
    {
        return $this->stage;
    }
    /**
     * Set stage value
     * @param \StructType\SearchEnumMultiSelectField $stage
     * @return \StructType\ChargeSearchBasic
     */
    public function setStage(\StructType\SearchEnumMultiSelectField $stage = null)
    {
        $this->stage = $stage;
        return $this;
    }
    /**
     * Get subscriptionLine value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getSubscriptionLine()
    {
        return $this->subscriptionLine;
    }
    /**
     * Set subscriptionLine value
     * @param \StructType\SearchMultiSelectField $subscriptionLine
     * @return \StructType\ChargeSearchBasic
     */
    public function setSubscriptionLine(\StructType\SearchMultiSelectField $subscriptionLine = null)
    {
        $this->subscriptionLine = $subscriptionLine;
        return $this;
    }
    /**
     * Get use value
     * @return \StructType\SearchEnumMultiSelectField|null
     */
    public function getUse()
    {
        return $this->use;
    }
    /**
     * Set use value
     * @param \StructType\SearchEnumMultiSelectField $use
     * @return \StructType\ChargeSearchBasic
     */
    public function setUse(\StructType\SearchEnumMultiSelectField $use = null)
    {
        $this->use = $use;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchCustomFieldList $customFieldList
     * @return \StructType\ChargeSearchBasic
     */
    public function setCustomFieldList(\StructType\SearchCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
