<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeSearch StructType
 * @subpackage Structs
 */
class ChargeSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ChargeSearchBasic
     */
    public $basic;
    /**
     * The billingAccountJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillingAccountSearchBasic
     */
    public $billingAccountJoin;
    /**
     * The billingScheduleJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillingScheduleSearchBasic
     */
    public $billingScheduleJoin;
    /**
     * The chargeEmployeeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $chargeEmployeeJoin;
    /**
     * The customerJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerSearchBasic
     */
    public $customerJoin;
    /**
     * The invoiceJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $invoiceJoin;
    /**
     * The itemJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemSearchBasic
     */
    public $itemJoin;
    /**
     * The jobJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JobSearchBasic
     */
    public $jobJoin;
    /**
     * The salesOrderJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $salesOrderJoin;
    /**
     * The timeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeBillSearchBasic
     */
    public $timeJoin;
    /**
     * The transactionJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $transactionJoin;
    /**
     * The usageJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UsageSearchBasic
     */
    public $usageJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $userJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for ChargeSearch
     * @uses ChargeSearch::setBasic()
     * @uses ChargeSearch::setBillingAccountJoin()
     * @uses ChargeSearch::setBillingScheduleJoin()
     * @uses ChargeSearch::setChargeEmployeeJoin()
     * @uses ChargeSearch::setCustomerJoin()
     * @uses ChargeSearch::setInvoiceJoin()
     * @uses ChargeSearch::setItemJoin()
     * @uses ChargeSearch::setJobJoin()
     * @uses ChargeSearch::setSalesOrderJoin()
     * @uses ChargeSearch::setTimeJoin()
     * @uses ChargeSearch::setTransactionJoin()
     * @uses ChargeSearch::setUsageJoin()
     * @uses ChargeSearch::setUserJoin()
     * @uses ChargeSearch::setCustomSearchJoin()
     * @param \StructType\ChargeSearchBasic $basic
     * @param \StructType\BillingAccountSearchBasic $billingAccountJoin
     * @param \StructType\BillingScheduleSearchBasic $billingScheduleJoin
     * @param \StructType\EmployeeSearchBasic $chargeEmployeeJoin
     * @param \StructType\CustomerSearchBasic $customerJoin
     * @param \StructType\TransactionSearchBasic $invoiceJoin
     * @param \StructType\ItemSearchBasic $itemJoin
     * @param \StructType\JobSearchBasic $jobJoin
     * @param \StructType\TransactionSearchBasic $salesOrderJoin
     * @param \StructType\TimeBillSearchBasic $timeJoin
     * @param \StructType\TransactionSearchBasic $transactionJoin
     * @param \StructType\UsageSearchBasic $usageJoin
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\ChargeSearchBasic $basic = null, \StructType\BillingAccountSearchBasic $billingAccountJoin = null, \StructType\BillingScheduleSearchBasic $billingScheduleJoin = null, \StructType\EmployeeSearchBasic $chargeEmployeeJoin = null, \StructType\CustomerSearchBasic $customerJoin = null, \StructType\TransactionSearchBasic $invoiceJoin = null, \StructType\ItemSearchBasic $itemJoin = null, \StructType\JobSearchBasic $jobJoin = null, \StructType\TransactionSearchBasic $salesOrderJoin = null, \StructType\TimeBillSearchBasic $timeJoin = null, \StructType\TransactionSearchBasic $transactionJoin = null, \StructType\UsageSearchBasic $usageJoin = null, \StructType\EmployeeSearchBasic $userJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setBillingAccountJoin($billingAccountJoin)
            ->setBillingScheduleJoin($billingScheduleJoin)
            ->setChargeEmployeeJoin($chargeEmployeeJoin)
            ->setCustomerJoin($customerJoin)
            ->setInvoiceJoin($invoiceJoin)
            ->setItemJoin($itemJoin)
            ->setJobJoin($jobJoin)
            ->setSalesOrderJoin($salesOrderJoin)
            ->setTimeJoin($timeJoin)
            ->setTransactionJoin($transactionJoin)
            ->setUsageJoin($usageJoin)
            ->setUserJoin($userJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\ChargeSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\ChargeSearchBasic $basic
     * @return \StructType\ChargeSearch
     */
    public function setBasic(\StructType\ChargeSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get billingAccountJoin value
     * @return \StructType\BillingAccountSearchBasic|null
     */
    public function getBillingAccountJoin()
    {
        return $this->billingAccountJoin;
    }
    /**
     * Set billingAccountJoin value
     * @param \StructType\BillingAccountSearchBasic $billingAccountJoin
     * @return \StructType\ChargeSearch
     */
    public function setBillingAccountJoin(\StructType\BillingAccountSearchBasic $billingAccountJoin = null)
    {
        $this->billingAccountJoin = $billingAccountJoin;
        return $this;
    }
    /**
     * Get billingScheduleJoin value
     * @return \StructType\BillingScheduleSearchBasic|null
     */
    public function getBillingScheduleJoin()
    {
        return $this->billingScheduleJoin;
    }
    /**
     * Set billingScheduleJoin value
     * @param \StructType\BillingScheduleSearchBasic $billingScheduleJoin
     * @return \StructType\ChargeSearch
     */
    public function setBillingScheduleJoin(\StructType\BillingScheduleSearchBasic $billingScheduleJoin = null)
    {
        $this->billingScheduleJoin = $billingScheduleJoin;
        return $this;
    }
    /**
     * Get chargeEmployeeJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getChargeEmployeeJoin()
    {
        return $this->chargeEmployeeJoin;
    }
    /**
     * Set chargeEmployeeJoin value
     * @param \StructType\EmployeeSearchBasic $chargeEmployeeJoin
     * @return \StructType\ChargeSearch
     */
    public function setChargeEmployeeJoin(\StructType\EmployeeSearchBasic $chargeEmployeeJoin = null)
    {
        $this->chargeEmployeeJoin = $chargeEmployeeJoin;
        return $this;
    }
    /**
     * Get customerJoin value
     * @return \StructType\CustomerSearchBasic|null
     */
    public function getCustomerJoin()
    {
        return $this->customerJoin;
    }
    /**
     * Set customerJoin value
     * @param \StructType\CustomerSearchBasic $customerJoin
     * @return \StructType\ChargeSearch
     */
    public function setCustomerJoin(\StructType\CustomerSearchBasic $customerJoin = null)
    {
        $this->customerJoin = $customerJoin;
        return $this;
    }
    /**
     * Get invoiceJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getInvoiceJoin()
    {
        return $this->invoiceJoin;
    }
    /**
     * Set invoiceJoin value
     * @param \StructType\TransactionSearchBasic $invoiceJoin
     * @return \StructType\ChargeSearch
     */
    public function setInvoiceJoin(\StructType\TransactionSearchBasic $invoiceJoin = null)
    {
        $this->invoiceJoin = $invoiceJoin;
        return $this;
    }
    /**
     * Get itemJoin value
     * @return \StructType\ItemSearchBasic|null
     */
    public function getItemJoin()
    {
        return $this->itemJoin;
    }
    /**
     * Set itemJoin value
     * @param \StructType\ItemSearchBasic $itemJoin
     * @return \StructType\ChargeSearch
     */
    public function setItemJoin(\StructType\ItemSearchBasic $itemJoin = null)
    {
        $this->itemJoin = $itemJoin;
        return $this;
    }
    /**
     * Get jobJoin value
     * @return \StructType\JobSearchBasic|null
     */
    public function getJobJoin()
    {
        return $this->jobJoin;
    }
    /**
     * Set jobJoin value
     * @param \StructType\JobSearchBasic $jobJoin
     * @return \StructType\ChargeSearch
     */
    public function setJobJoin(\StructType\JobSearchBasic $jobJoin = null)
    {
        $this->jobJoin = $jobJoin;
        return $this;
    }
    /**
     * Get salesOrderJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getSalesOrderJoin()
    {
        return $this->salesOrderJoin;
    }
    /**
     * Set salesOrderJoin value
     * @param \StructType\TransactionSearchBasic $salesOrderJoin
     * @return \StructType\ChargeSearch
     */
    public function setSalesOrderJoin(\StructType\TransactionSearchBasic $salesOrderJoin = null)
    {
        $this->salesOrderJoin = $salesOrderJoin;
        return $this;
    }
    /**
     * Get timeJoin value
     * @return \StructType\TimeBillSearchBasic|null
     */
    public function getTimeJoin()
    {
        return $this->timeJoin;
    }
    /**
     * Set timeJoin value
     * @param \StructType\TimeBillSearchBasic $timeJoin
     * @return \StructType\ChargeSearch
     */
    public function setTimeJoin(\StructType\TimeBillSearchBasic $timeJoin = null)
    {
        $this->timeJoin = $timeJoin;
        return $this;
    }
    /**
     * Get transactionJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getTransactionJoin()
    {
        return $this->transactionJoin;
    }
    /**
     * Set transactionJoin value
     * @param \StructType\TransactionSearchBasic $transactionJoin
     * @return \StructType\ChargeSearch
     */
    public function setTransactionJoin(\StructType\TransactionSearchBasic $transactionJoin = null)
    {
        $this->transactionJoin = $transactionJoin;
        return $this;
    }
    /**
     * Get usageJoin value
     * @return \StructType\UsageSearchBasic|null
     */
    public function getUsageJoin()
    {
        return $this->usageJoin;
    }
    /**
     * Set usageJoin value
     * @param \StructType\UsageSearchBasic $usageJoin
     * @return \StructType\ChargeSearch
     */
    public function setUsageJoin(\StructType\UsageSearchBasic $usageJoin = null)
    {
        $this->usageJoin = $usageJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @return \StructType\ChargeSearch
     */
    public function setUserJoin(\StructType\EmployeeSearchBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$chargeSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($chargeSearchCustomSearchJoinItem) ? get_class($chargeSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($chargeSearchCustomSearchJoinItem), var_export($chargeSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\ChargeSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\ChargeSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
