<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangePassword StructType
 * @subpackage Structs
 */
class ChangePassword extends AbstractStructBase
{
    /**
     * The currentPassword
     * @var string
     */
    public $currentPassword;
    /**
     * The newPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $newPassword;
    /**
     * The newPassword2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $newPassword2;
    /**
     * Constructor method for ChangePassword
     * @uses ChangePassword::setCurrentPassword()
     * @uses ChangePassword::setNewPassword()
     * @uses ChangePassword::setNewPassword2()
     * @param string $currentPassword
     * @param string $newPassword
     * @param string $newPassword2
     */
    public function __construct($currentPassword = null, $newPassword = null, $newPassword2 = null)
    {
        $this
            ->setCurrentPassword($currentPassword)
            ->setNewPassword($newPassword)
            ->setNewPassword2($newPassword2);
    }
    /**
     * Get currentPassword value
     * @return string|null
     */
    public function getCurrentPassword()
    {
        return $this->currentPassword;
    }
    /**
     * Set currentPassword value
     * @param string $currentPassword
     * @return \StructType\ChangePassword
     */
    public function setCurrentPassword($currentPassword = null)
    {
        // validation for constraint: string
        if (!is_null($currentPassword) && !is_string($currentPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentPassword, true), gettype($currentPassword)), __LINE__);
        }
        $this->currentPassword = $currentPassword;
        return $this;
    }
    /**
     * Get newPassword value
     * @return string|null
     */
    public function getNewPassword()
    {
        return $this->newPassword;
    }
    /**
     * Set newPassword value
     * @param string $newPassword
     * @return \StructType\ChangePassword
     */
    public function setNewPassword($newPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newPassword) && !is_string($newPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPassword, true), gettype($newPassword)), __LINE__);
        }
        $this->newPassword = $newPassword;
        return $this;
    }
    /**
     * Get newPassword2 value
     * @return string|null
     */
    public function getNewPassword2()
    {
        return $this->newPassword2;
    }
    /**
     * Set newPassword2 value
     * @param string $newPassword2
     * @return \StructType\ChangePassword
     */
    public function setNewPassword2($newPassword2 = null)
    {
        // validation for constraint: string
        if (!is_null($newPassword2) && !is_string($newPassword2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPassword2, true), gettype($newPassword2)), __LINE__);
        }
        $this->newPassword2 = $newPassword2;
        return $this;
    }
}
