<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryList StructType
 * @subpackage Structs
 */
class CategoryList extends AbstractStructBase
{
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\RecordRef[]
     */
    public $category;
    /**
     * Constructor method for CategoryList
     * @uses CategoryList::setCategory()
     * @param \StructType\RecordRef[] $category
     */
    public function __construct(array $category = array())
    {
        $this
            ->setCategory($category);
    }
    /**
     * Get category value
     * @return \StructType\RecordRef[]|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * This method is responsible for validating the values passed to the setCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryForArrayConstraintsFromSetCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryListCategoryItem) {
            // validation for constraint: itemType
            if (!$categoryListCategoryItem instanceof \StructType\RecordRef) {
                $invalidValues[] = is_object($categoryListCategoryItem) ? get_class($categoryListCategoryItem) : sprintf('%s(%s)', gettype($categoryListCategoryItem), var_export($categoryListCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The category property can only contain items of type \StructType\RecordRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set category value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordRef[] $category
     * @return \StructType\CategoryList
     */
    public function setCategory(array $category = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryArrayErrorMessage = self::validateCategoryForArrayConstraintsFromSetCategory($category))) {
            throw new \InvalidArgumentException($categoryArrayErrorMessage, __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Add item to category value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordRef $item
     * @return \StructType\CategoryList
     */
    public function addToCategory(\StructType\RecordRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecordRef) {
            throw new \InvalidArgumentException(sprintf('The category property can only contain items of type \StructType\RecordRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->category[] = $item;
        return $this;
    }
}
