<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashRefund StructType
 * Meta information extracted from the WSDL
 * - type: tranCust:CashRefund
 * @subpackage Structs
 */
class CashRefund extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The subsidiaryTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiaryTaxRegNum;
    /**
     * The taxRegOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxRegOverride;
    /**
     * The taxDetailsOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxDetailsOverride;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The vatRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vatRegNum;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The entityTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityTaxRegNum;
    /**
     * The taxPointDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxPointDate;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The leadSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $leadSource;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The salesRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesRep;
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $partner;
    /**
     * The contribPct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contribPct;
    /**
     * The otherRefNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $otherRefNum;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The salesEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesEffectiveDate;
    /**
     * The refundCheck
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $refundCheck;
    /**
     * The toPrint2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toPrint2;
    /**
     * The excludeCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeCommission;
    /**
     * The totalCostEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalCostEstimate;
    /**
     * The estGrossProfit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estGrossProfit;
    /**
     * The estGrossProfitPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estGrossProfitPercent;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The promoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $promoCode;
    /**
     * The discountItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $discountItem;
    /**
     * The discountRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discountRate;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The taxItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxItem;
    /**
     * The taxRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate;
    /**
     * The toBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBePrinted;
    /**
     * The toBeEmailed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBeEmailed;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The toBeFaxed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBeFaxed;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The messageSel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $messageSel;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The paymentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentOption;
    /**
     * The inputAuthCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inputAuthCode;
    /**
     * The inputReferenceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inputReferenceCode;
    /**
     * The checkNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $checkNumber;
    /**
     * The paymentCardCsc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentCardCsc;
    /**
     * The paymentProcessingProfile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentProcessingProfile;
    /**
     * The handlingMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $handlingMode;
    /**
     * The outputAuthCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputAuthCode;
    /**
     * The outputReferenceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputReferenceCode;
    /**
     * The paymentOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentOperation;
    /**
     * The dynamicDescriptor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dynamicDescriptor;
    /**
     * The billingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $billingAddress;
    /**
     * The billAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billAddressList;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The shippingTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shippingTaxCode;
    /**
     * The shippingTax1Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingTax1Rate;
    /**
     * The shippingTax2Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingTax2Rate;
    /**
     * The shippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingCost;
    /**
     * The handlingTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $handlingTaxCode;
    /**
     * The handlingTax1Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingTax1Rate;
    /**
     * The handlingTax2Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $handlingTax2Rate;
    /**
     * The handlingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingCost;
    /**
     * The salesGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesGroup;
    /**
     * The syncSalesTeams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $syncSalesTeams;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentMethod;
    /**
     * The revenueStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revenueStatus;
    /**
     * The recognizedRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $recognizedRevenue;
    /**
     * The deferredRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $deferredRevenue;
    /**
     * The revRecOnRevCommitment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $revRecOnRevCommitment;
    /**
     * The creditCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $creditCard;
    /**
     * The chargeIt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $chargeIt;
    /**
     * The ccNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccNumber;
    /**
     * The ccExpireDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccExpireDate;
    /**
     * The ccName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccName;
    /**
     * The ccStreet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccStreet;
    /**
     * The ccZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccZipCode;
    /**
     * The ccApproved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ccApproved;
    /**
     * The creditCardProcessor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $creditCardProcessor;
    /**
     * The debitCardIssueNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $debitCardIssueNo;
    /**
     * The pnRefNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pnRefNum;
    /**
     * The validFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $validFrom;
    /**
     * The payPalTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payPalTranId;
    /**
     * The subTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $subTotal;
    /**
     * The ccIsPurchaseCardBin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ccIsPurchaseCardBin;
    /**
     * The discountTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountTotal;
    /**
     * The ccProcessAsPurchaseCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ccProcessAsPurchaseCard;
    /**
     * The taxTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxTotal;
    /**
     * The tax2Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax2Total;
    /**
     * The altShippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altShippingCost;
    /**
     * The payPalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payPalStatus;
    /**
     * The altHandlingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altHandlingCost;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The payPalAuthId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payPalAuthId;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The giftCert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $giftCert;
    /**
     * The giftCertTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $giftCertTotal;
    /**
     * The giftCertApplied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $giftCertApplied;
    /**
     * The giftCertAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $giftCertAvailable;
    /**
     * The tranIsVsoeBundle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $tranIsVsoeBundle;
    /**
     * The payPalProcess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $payPalProcess;
    /**
     * The vsoeAutoCalc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeAutoCalc;
    /**
     * The syncPartnerTeams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $syncPartnerTeams;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CashRefundItemList
     */
    public $itemList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The salesTeamList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CashRefundSalesTeamList
     */
    public $salesTeamList;
    /**
     * The partnersList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CashRefundPartnersList
     */
    public $partnersList;
    /**
     * The taxDetailsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxDetailsList
     */
    public $taxDetailsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for CashRefund
     * @uses CashRefund::setCreatedDate()
     * @uses CashRefund::setLastModifiedDate()
     * @uses CashRefund::setNexus()
     * @uses CashRefund::setSubsidiaryTaxRegNum()
     * @uses CashRefund::setTaxRegOverride()
     * @uses CashRefund::setTaxDetailsOverride()
     * @uses CashRefund::setCustomForm()
     * @uses CashRefund::setEntity()
     * @uses CashRefund::setVatRegNum()
     * @uses CashRefund::setTranDate()
     * @uses CashRefund::setTranId()
     * @uses CashRefund::setEntityTaxRegNum()
     * @uses CashRefund::setTaxPointDate()
     * @uses CashRefund::setSource()
     * @uses CashRefund::setCreatedFrom()
     * @uses CashRefund::setPostingPeriod()
     * @uses CashRefund::setDepartment()
     * @uses CashRefund::setClass()
     * @uses CashRefund::setLocation()
     * @uses CashRefund::setLeadSource()
     * @uses CashRefund::setSubsidiary()
     * @uses CashRefund::setSalesRep()
     * @uses CashRefund::setPartner()
     * @uses CashRefund::setContribPct()
     * @uses CashRefund::setOtherRefNum()
     * @uses CashRefund::setMemo()
     * @uses CashRefund::setSalesEffectiveDate()
     * @uses CashRefund::setRefundCheck()
     * @uses CashRefund::setToPrint2()
     * @uses CashRefund::setExcludeCommission()
     * @uses CashRefund::setTotalCostEstimate()
     * @uses CashRefund::setEstGrossProfit()
     * @uses CashRefund::setEstGrossProfitPercent()
     * @uses CashRefund::setAccount()
     * @uses CashRefund::setCurrency()
     * @uses CashRefund::setExchangeRate()
     * @uses CashRefund::setCurrencyName()
     * @uses CashRefund::setPromoCode()
     * @uses CashRefund::setDiscountItem()
     * @uses CashRefund::setDiscountRate()
     * @uses CashRefund::setIsTaxable()
     * @uses CashRefund::setTaxItem()
     * @uses CashRefund::setTaxRate()
     * @uses CashRefund::setToBePrinted()
     * @uses CashRefund::setToBeEmailed()
     * @uses CashRefund::setEmail()
     * @uses CashRefund::setToBeFaxed()
     * @uses CashRefund::setFax()
     * @uses CashRefund::setMessageSel()
     * @uses CashRefund::setMessage()
     * @uses CashRefund::setPaymentOption()
     * @uses CashRefund::setInputAuthCode()
     * @uses CashRefund::setInputReferenceCode()
     * @uses CashRefund::setCheckNumber()
     * @uses CashRefund::setPaymentCardCsc()
     * @uses CashRefund::setPaymentProcessingProfile()
     * @uses CashRefund::setHandlingMode()
     * @uses CashRefund::setOutputAuthCode()
     * @uses CashRefund::setOutputReferenceCode()
     * @uses CashRefund::setPaymentOperation()
     * @uses CashRefund::setDynamicDescriptor()
     * @uses CashRefund::setBillingAddress()
     * @uses CashRefund::setBillAddressList()
     * @uses CashRefund::setShipMethod()
     * @uses CashRefund::setShippingTaxCode()
     * @uses CashRefund::setShippingTax1Rate()
     * @uses CashRefund::setShippingTax2Rate()
     * @uses CashRefund::setShippingCost()
     * @uses CashRefund::setHandlingTaxCode()
     * @uses CashRefund::setHandlingTax1Rate()
     * @uses CashRefund::setHandlingTax2Rate()
     * @uses CashRefund::setHandlingCost()
     * @uses CashRefund::setSalesGroup()
     * @uses CashRefund::setSyncSalesTeams()
     * @uses CashRefund::setPaymentMethod()
     * @uses CashRefund::setRevenueStatus()
     * @uses CashRefund::setRecognizedRevenue()
     * @uses CashRefund::setDeferredRevenue()
     * @uses CashRefund::setRevRecOnRevCommitment()
     * @uses CashRefund::setCreditCard()
     * @uses CashRefund::setChargeIt()
     * @uses CashRefund::setCcNumber()
     * @uses CashRefund::setCcExpireDate()
     * @uses CashRefund::setCcName()
     * @uses CashRefund::setCcStreet()
     * @uses CashRefund::setCcZipCode()
     * @uses CashRefund::setCcApproved()
     * @uses CashRefund::setCreditCardProcessor()
     * @uses CashRefund::setDebitCardIssueNo()
     * @uses CashRefund::setPnRefNum()
     * @uses CashRefund::setValidFrom()
     * @uses CashRefund::setPayPalTranId()
     * @uses CashRefund::setSubTotal()
     * @uses CashRefund::setCcIsPurchaseCardBin()
     * @uses CashRefund::setDiscountTotal()
     * @uses CashRefund::setCcProcessAsPurchaseCard()
     * @uses CashRefund::setTaxTotal()
     * @uses CashRefund::setTax2Total()
     * @uses CashRefund::setAltShippingCost()
     * @uses CashRefund::setPayPalStatus()
     * @uses CashRefund::setAltHandlingCost()
     * @uses CashRefund::setTotal()
     * @uses CashRefund::setPayPalAuthId()
     * @uses CashRefund::setStatus()
     * @uses CashRefund::setJob()
     * @uses CashRefund::setGiftCert()
     * @uses CashRefund::setGiftCertTotal()
     * @uses CashRefund::setGiftCertApplied()
     * @uses CashRefund::setGiftCertAvailable()
     * @uses CashRefund::setTranIsVsoeBundle()
     * @uses CashRefund::setPayPalProcess()
     * @uses CashRefund::setVsoeAutoCalc()
     * @uses CashRefund::setSyncPartnerTeams()
     * @uses CashRefund::setItemList()
     * @uses CashRefund::setAccountingBookDetailList()
     * @uses CashRefund::setSalesTeamList()
     * @uses CashRefund::setPartnersList()
     * @uses CashRefund::setTaxDetailsList()
     * @uses CashRefund::setCustomFieldList()
     * @uses CashRefund::setInternalId()
     * @uses CashRefund::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @param bool $taxRegOverride
     * @param bool $taxDetailsOverride
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $entity
     * @param string $vatRegNum
     * @param string $tranDate
     * @param string $tranId
     * @param \StructType\RecordRef $entityTaxRegNum
     * @param string $taxPointDate
     * @param string $source
     * @param \StructType\RecordRef $createdFrom
     * @param \StructType\RecordRef $postingPeriod
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $leadSource
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $salesRep
     * @param \StructType\RecordRef $partner
     * @param string $contribPct
     * @param string $otherRefNum
     * @param string $memo
     * @param string $salesEffectiveDate
     * @param bool $refundCheck
     * @param bool $toPrint2
     * @param bool $excludeCommission
     * @param float $totalCostEstimate
     * @param float $estGrossProfit
     * @param float $estGrossProfitPercent
     * @param \StructType\RecordRef $account
     * @param \StructType\RecordRef $currency
     * @param float $exchangeRate
     * @param string $currencyName
     * @param \StructType\RecordRef $promoCode
     * @param \StructType\RecordRef $discountItem
     * @param string $discountRate
     * @param bool $isTaxable
     * @param \StructType\RecordRef $taxItem
     * @param float $taxRate
     * @param bool $toBePrinted
     * @param bool $toBeEmailed
     * @param string $email
     * @param bool $toBeFaxed
     * @param string $fax
     * @param \StructType\RecordRef $messageSel
     * @param string $message
     * @param \StructType\RecordRef $paymentOption
     * @param string $inputAuthCode
     * @param string $inputReferenceCode
     * @param string $checkNumber
     * @param string $paymentCardCsc
     * @param \StructType\RecordRef $paymentProcessingProfile
     * @param string $handlingMode
     * @param string $outputAuthCode
     * @param string $outputReferenceCode
     * @param string $paymentOperation
     * @param string $dynamicDescriptor
     * @param \StructType\Address $billingAddress
     * @param \StructType\RecordRef $billAddressList
     * @param \StructType\RecordRef $shipMethod
     * @param \StructType\RecordRef $shippingTaxCode
     * @param float $shippingTax1Rate
     * @param string $shippingTax2Rate
     * @param float $shippingCost
     * @param \StructType\RecordRef $handlingTaxCode
     * @param float $handlingTax1Rate
     * @param string $handlingTax2Rate
     * @param float $handlingCost
     * @param \StructType\RecordRef $salesGroup
     * @param bool $syncSalesTeams
     * @param \StructType\RecordRef $paymentMethod
     * @param string $revenueStatus
     * @param float $recognizedRevenue
     * @param float $deferredRevenue
     * @param bool $revRecOnRevCommitment
     * @param \StructType\RecordRef $creditCard
     * @param bool $chargeIt
     * @param string $ccNumber
     * @param string $ccExpireDate
     * @param string $ccName
     * @param string $ccStreet
     * @param string $ccZipCode
     * @param bool $ccApproved
     * @param \StructType\RecordRef $creditCardProcessor
     * @param string $debitCardIssueNo
     * @param string $pnRefNum
     * @param string $validFrom
     * @param string $payPalTranId
     * @param float $subTotal
     * @param bool $ccIsPurchaseCardBin
     * @param float $discountTotal
     * @param bool $ccProcessAsPurchaseCard
     * @param float $taxTotal
     * @param float $tax2Total
     * @param float $altShippingCost
     * @param string $payPalStatus
     * @param float $altHandlingCost
     * @param float $total
     * @param string $payPalAuthId
     * @param string $status
     * @param \StructType\RecordRef $job
     * @param \StructType\RecordRef $giftCert
     * @param float $giftCertTotal
     * @param float $giftCertApplied
     * @param float $giftCertAvailable
     * @param bool $tranIsVsoeBundle
     * @param bool $payPalProcess
     * @param bool $vsoeAutoCalc
     * @param bool $syncPartnerTeams
     * @param \StructType\CashRefundItemList $itemList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\CashRefundSalesTeamList $salesTeamList
     * @param \StructType\CashRefundPartnersList $partnersList
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $subsidiaryTaxRegNum = null, $taxRegOverride = null, $taxDetailsOverride = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $entity = null, $vatRegNum = null, $tranDate = null, $tranId = null, \StructType\RecordRef $entityTaxRegNum = null, $taxPointDate = null, $source = null, \StructType\RecordRef $createdFrom = null, \StructType\RecordRef $postingPeriod = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $leadSource = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $salesRep = null, \StructType\RecordRef $partner = null, $contribPct = null, $otherRefNum = null, $memo = null, $salesEffectiveDate = null, $refundCheck = null, $toPrint2 = null, $excludeCommission = null, $totalCostEstimate = null, $estGrossProfit = null, $estGrossProfitPercent = null, \StructType\RecordRef $account = null, \StructType\RecordRef $currency = null, $exchangeRate = null, $currencyName = null, \StructType\RecordRef $promoCode = null, \StructType\RecordRef $discountItem = null, $discountRate = null, $isTaxable = null, \StructType\RecordRef $taxItem = null, $taxRate = null, $toBePrinted = null, $toBeEmailed = null, $email = null, $toBeFaxed = null, $fax = null, \StructType\RecordRef $messageSel = null, $message = null, \StructType\RecordRef $paymentOption = null, $inputAuthCode = null, $inputReferenceCode = null, $checkNumber = null, $paymentCardCsc = null, \StructType\RecordRef $paymentProcessingProfile = null, $handlingMode = null, $outputAuthCode = null, $outputReferenceCode = null, $paymentOperation = null, $dynamicDescriptor = null, \StructType\Address $billingAddress = null, \StructType\RecordRef $billAddressList = null, \StructType\RecordRef $shipMethod = null, \StructType\RecordRef $shippingTaxCode = null, $shippingTax1Rate = null, $shippingTax2Rate = null, $shippingCost = null, \StructType\RecordRef $handlingTaxCode = null, $handlingTax1Rate = null, $handlingTax2Rate = null, $handlingCost = null, \StructType\RecordRef $salesGroup = null, $syncSalesTeams = null, \StructType\RecordRef $paymentMethod = null, $revenueStatus = null, $recognizedRevenue = null, $deferredRevenue = null, $revRecOnRevCommitment = null, \StructType\RecordRef $creditCard = null, $chargeIt = null, $ccNumber = null, $ccExpireDate = null, $ccName = null, $ccStreet = null, $ccZipCode = null, $ccApproved = null, \StructType\RecordRef $creditCardProcessor = null, $debitCardIssueNo = null, $pnRefNum = null, $validFrom = null, $payPalTranId = null, $subTotal = null, $ccIsPurchaseCardBin = null, $discountTotal = null, $ccProcessAsPurchaseCard = null, $taxTotal = null, $tax2Total = null, $altShippingCost = null, $payPalStatus = null, $altHandlingCost = null, $total = null, $payPalAuthId = null, $status = null, \StructType\RecordRef $job = null, \StructType\RecordRef $giftCert = null, $giftCertTotal = null, $giftCertApplied = null, $giftCertAvailable = null, $tranIsVsoeBundle = null, $payPalProcess = null, $vsoeAutoCalc = null, $syncPartnerTeams = null, \StructType\CashRefundItemList $itemList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\CashRefundSalesTeamList $salesTeamList = null, \StructType\CashRefundPartnersList $partnersList = null, \StructType\TaxDetailsList $taxDetailsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setNexus($nexus)
            ->setSubsidiaryTaxRegNum($subsidiaryTaxRegNum)
            ->setTaxRegOverride($taxRegOverride)
            ->setTaxDetailsOverride($taxDetailsOverride)
            ->setCustomForm($customForm)
            ->setEntity($entity)
            ->setVatRegNum($vatRegNum)
            ->setTranDate($tranDate)
            ->setTranId($tranId)
            ->setEntityTaxRegNum($entityTaxRegNum)
            ->setTaxPointDate($taxPointDate)
            ->setSource($source)
            ->setCreatedFrom($createdFrom)
            ->setPostingPeriod($postingPeriod)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setLeadSource($leadSource)
            ->setSubsidiary($subsidiary)
            ->setSalesRep($salesRep)
            ->setPartner($partner)
            ->setContribPct($contribPct)
            ->setOtherRefNum($otherRefNum)
            ->setMemo($memo)
            ->setSalesEffectiveDate($salesEffectiveDate)
            ->setRefundCheck($refundCheck)
            ->setToPrint2($toPrint2)
            ->setExcludeCommission($excludeCommission)
            ->setTotalCostEstimate($totalCostEstimate)
            ->setEstGrossProfit($estGrossProfit)
            ->setEstGrossProfitPercent($estGrossProfitPercent)
            ->setAccount($account)
            ->setCurrency($currency)
            ->setExchangeRate($exchangeRate)
            ->setCurrencyName($currencyName)
            ->setPromoCode($promoCode)
            ->setDiscountItem($discountItem)
            ->setDiscountRate($discountRate)
            ->setIsTaxable($isTaxable)
            ->setTaxItem($taxItem)
            ->setTaxRate($taxRate)
            ->setToBePrinted($toBePrinted)
            ->setToBeEmailed($toBeEmailed)
            ->setEmail($email)
            ->setToBeFaxed($toBeFaxed)
            ->setFax($fax)
            ->setMessageSel($messageSel)
            ->setMessage($message)
            ->setPaymentOption($paymentOption)
            ->setInputAuthCode($inputAuthCode)
            ->setInputReferenceCode($inputReferenceCode)
            ->setCheckNumber($checkNumber)
            ->setPaymentCardCsc($paymentCardCsc)
            ->setPaymentProcessingProfile($paymentProcessingProfile)
            ->setHandlingMode($handlingMode)
            ->setOutputAuthCode($outputAuthCode)
            ->setOutputReferenceCode($outputReferenceCode)
            ->setPaymentOperation($paymentOperation)
            ->setDynamicDescriptor($dynamicDescriptor)
            ->setBillingAddress($billingAddress)
            ->setBillAddressList($billAddressList)
            ->setShipMethod($shipMethod)
            ->setShippingTaxCode($shippingTaxCode)
            ->setShippingTax1Rate($shippingTax1Rate)
            ->setShippingTax2Rate($shippingTax2Rate)
            ->setShippingCost($shippingCost)
            ->setHandlingTaxCode($handlingTaxCode)
            ->setHandlingTax1Rate($handlingTax1Rate)
            ->setHandlingTax2Rate($handlingTax2Rate)
            ->setHandlingCost($handlingCost)
            ->setSalesGroup($salesGroup)
            ->setSyncSalesTeams($syncSalesTeams)
            ->setPaymentMethod($paymentMethod)
            ->setRevenueStatus($revenueStatus)
            ->setRecognizedRevenue($recognizedRevenue)
            ->setDeferredRevenue($deferredRevenue)
            ->setRevRecOnRevCommitment($revRecOnRevCommitment)
            ->setCreditCard($creditCard)
            ->setChargeIt($chargeIt)
            ->setCcNumber($ccNumber)
            ->setCcExpireDate($ccExpireDate)
            ->setCcName($ccName)
            ->setCcStreet($ccStreet)
            ->setCcZipCode($ccZipCode)
            ->setCcApproved($ccApproved)
            ->setCreditCardProcessor($creditCardProcessor)
            ->setDebitCardIssueNo($debitCardIssueNo)
            ->setPnRefNum($pnRefNum)
            ->setValidFrom($validFrom)
            ->setPayPalTranId($payPalTranId)
            ->setSubTotal($subTotal)
            ->setCcIsPurchaseCardBin($ccIsPurchaseCardBin)
            ->setDiscountTotal($discountTotal)
            ->setCcProcessAsPurchaseCard($ccProcessAsPurchaseCard)
            ->setTaxTotal($taxTotal)
            ->setTax2Total($tax2Total)
            ->setAltShippingCost($altShippingCost)
            ->setPayPalStatus($payPalStatus)
            ->setAltHandlingCost($altHandlingCost)
            ->setTotal($total)
            ->setPayPalAuthId($payPalAuthId)
            ->setStatus($status)
            ->setJob($job)
            ->setGiftCert($giftCert)
            ->setGiftCertTotal($giftCertTotal)
            ->setGiftCertApplied($giftCertApplied)
            ->setGiftCertAvailable($giftCertAvailable)
            ->setTranIsVsoeBundle($tranIsVsoeBundle)
            ->setPayPalProcess($payPalProcess)
            ->setVsoeAutoCalc($vsoeAutoCalc)
            ->setSyncPartnerTeams($syncPartnerTeams)
            ->setItemList($itemList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setSalesTeamList($salesTeamList)
            ->setPartnersList($partnersList)
            ->setTaxDetailsList($taxDetailsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\CashRefund
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\CashRefund
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\CashRefund
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get subsidiaryTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiaryTaxRegNum()
    {
        return $this->subsidiaryTaxRegNum;
    }
    /**
     * Set subsidiaryTaxRegNum value
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @return \StructType\CashRefund
     */
    public function setSubsidiaryTaxRegNum(\StructType\RecordRef $subsidiaryTaxRegNum = null)
    {
        $this->subsidiaryTaxRegNum = $subsidiaryTaxRegNum;
        return $this;
    }
    /**
     * Get taxRegOverride value
     * @return bool|null
     */
    public function getTaxRegOverride()
    {
        return $this->taxRegOverride;
    }
    /**
     * Set taxRegOverride value
     * @param bool $taxRegOverride
     * @return \StructType\CashRefund
     */
    public function setTaxRegOverride($taxRegOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxRegOverride) && !is_bool($taxRegOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxRegOverride, true), gettype($taxRegOverride)), __LINE__);
        }
        $this->taxRegOverride = $taxRegOverride;
        return $this;
    }
    /**
     * Get taxDetailsOverride value
     * @return bool|null
     */
    public function getTaxDetailsOverride()
    {
        return $this->taxDetailsOverride;
    }
    /**
     * Set taxDetailsOverride value
     * @param bool $taxDetailsOverride
     * @return \StructType\CashRefund
     */
    public function setTaxDetailsOverride($taxDetailsOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxDetailsOverride) && !is_bool($taxDetailsOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxDetailsOverride, true), gettype($taxDetailsOverride)), __LINE__);
        }
        $this->taxDetailsOverride = $taxDetailsOverride;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\CashRefund
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\CashRefund
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get vatRegNum value
     * @return string|null
     */
    public function getVatRegNum()
    {
        return $this->vatRegNum;
    }
    /**
     * Set vatRegNum value
     * @param string $vatRegNum
     * @return \StructType\CashRefund
     */
    public function setVatRegNum($vatRegNum = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegNum) && !is_string($vatRegNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegNum, true), gettype($vatRegNum)), __LINE__);
        }
        $this->vatRegNum = $vatRegNum;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\CashRefund
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\CashRefund
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get entityTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getEntityTaxRegNum()
    {
        return $this->entityTaxRegNum;
    }
    /**
     * Set entityTaxRegNum value
     * @param \StructType\RecordRef $entityTaxRegNum
     * @return \StructType\CashRefund
     */
    public function setEntityTaxRegNum(\StructType\RecordRef $entityTaxRegNum = null)
    {
        $this->entityTaxRegNum = $entityTaxRegNum;
        return $this;
    }
    /**
     * Get taxPointDate value
     * @return string|null
     */
    public function getTaxPointDate()
    {
        return $this->taxPointDate;
    }
    /**
     * Set taxPointDate value
     * @param string $taxPointDate
     * @return \StructType\CashRefund
     */
    public function setTaxPointDate($taxPointDate = null)
    {
        // validation for constraint: string
        if (!is_null($taxPointDate) && !is_string($taxPointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPointDate, true), gettype($taxPointDate)), __LINE__);
        }
        $this->taxPointDate = $taxPointDate;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\CashRefund
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\CashRefund
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\CashRefund
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\CashRefund
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\CashRefund
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\CashRefund
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get leadSource value
     * @return \StructType\RecordRef|null
     */
    public function getLeadSource()
    {
        return $this->leadSource;
    }
    /**
     * Set leadSource value
     * @param \StructType\RecordRef $leadSource
     * @return \StructType\CashRefund
     */
    public function setLeadSource(\StructType\RecordRef $leadSource = null)
    {
        $this->leadSource = $leadSource;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\CashRefund
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get salesRep value
     * @return \StructType\RecordRef|null
     */
    public function getSalesRep()
    {
        return $this->salesRep;
    }
    /**
     * Set salesRep value
     * @param \StructType\RecordRef $salesRep
     * @return \StructType\CashRefund
     */
    public function setSalesRep(\StructType\RecordRef $salesRep = null)
    {
        $this->salesRep = $salesRep;
        return $this;
    }
    /**
     * Get partner value
     * @return \StructType\RecordRef|null
     */
    public function getPartner()
    {
        return $this->partner;
    }
    /**
     * Set partner value
     * @param \StructType\RecordRef $partner
     * @return \StructType\CashRefund
     */
    public function setPartner(\StructType\RecordRef $partner = null)
    {
        $this->partner = $partner;
        return $this;
    }
    /**
     * Get contribPct value
     * @return string|null
     */
    public function getContribPct()
    {
        return $this->contribPct;
    }
    /**
     * Set contribPct value
     * @param string $contribPct
     * @return \StructType\CashRefund
     */
    public function setContribPct($contribPct = null)
    {
        // validation for constraint: string
        if (!is_null($contribPct) && !is_string($contribPct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contribPct, true), gettype($contribPct)), __LINE__);
        }
        $this->contribPct = $contribPct;
        return $this;
    }
    /**
     * Get otherRefNum value
     * @return string|null
     */
    public function getOtherRefNum()
    {
        return $this->otherRefNum;
    }
    /**
     * Set otherRefNum value
     * @param string $otherRefNum
     * @return \StructType\CashRefund
     */
    public function setOtherRefNum($otherRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($otherRefNum) && !is_string($otherRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherRefNum, true), gettype($otherRefNum)), __LINE__);
        }
        $this->otherRefNum = $otherRefNum;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\CashRefund
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get salesEffectiveDate value
     * @return string|null
     */
    public function getSalesEffectiveDate()
    {
        return $this->salesEffectiveDate;
    }
    /**
     * Set salesEffectiveDate value
     * @param string $salesEffectiveDate
     * @return \StructType\CashRefund
     */
    public function setSalesEffectiveDate($salesEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($salesEffectiveDate) && !is_string($salesEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesEffectiveDate, true), gettype($salesEffectiveDate)), __LINE__);
        }
        $this->salesEffectiveDate = $salesEffectiveDate;
        return $this;
    }
    /**
     * Get refundCheck value
     * @return bool|null
     */
    public function getRefundCheck()
    {
        return $this->refundCheck;
    }
    /**
     * Set refundCheck value
     * @param bool $refundCheck
     * @return \StructType\CashRefund
     */
    public function setRefundCheck($refundCheck = null)
    {
        // validation for constraint: boolean
        if (!is_null($refundCheck) && !is_bool($refundCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refundCheck, true), gettype($refundCheck)), __LINE__);
        }
        $this->refundCheck = $refundCheck;
        return $this;
    }
    /**
     * Get toPrint2 value
     * @return bool|null
     */
    public function getToPrint2()
    {
        return $this->toPrint2;
    }
    /**
     * Set toPrint2 value
     * @param bool $toPrint2
     * @return \StructType\CashRefund
     */
    public function setToPrint2($toPrint2 = null)
    {
        // validation for constraint: boolean
        if (!is_null($toPrint2) && !is_bool($toPrint2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toPrint2, true), gettype($toPrint2)), __LINE__);
        }
        $this->toPrint2 = $toPrint2;
        return $this;
    }
    /**
     * Get excludeCommission value
     * @return bool|null
     */
    public function getExcludeCommission()
    {
        return $this->excludeCommission;
    }
    /**
     * Set excludeCommission value
     * @param bool $excludeCommission
     * @return \StructType\CashRefund
     */
    public function setExcludeCommission($excludeCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeCommission) && !is_bool($excludeCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeCommission, true), gettype($excludeCommission)), __LINE__);
        }
        $this->excludeCommission = $excludeCommission;
        return $this;
    }
    /**
     * Get totalCostEstimate value
     * @return float|null
     */
    public function getTotalCostEstimate()
    {
        return $this->totalCostEstimate;
    }
    /**
     * Set totalCostEstimate value
     * @param float $totalCostEstimate
     * @return \StructType\CashRefund
     */
    public function setTotalCostEstimate($totalCostEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($totalCostEstimate) && !(is_float($totalCostEstimate) || is_numeric($totalCostEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCostEstimate, true), gettype($totalCostEstimate)), __LINE__);
        }
        $this->totalCostEstimate = $totalCostEstimate;
        return $this;
    }
    /**
     * Get estGrossProfit value
     * @return float|null
     */
    public function getEstGrossProfit()
    {
        return $this->estGrossProfit;
    }
    /**
     * Set estGrossProfit value
     * @param float $estGrossProfit
     * @return \StructType\CashRefund
     */
    public function setEstGrossProfit($estGrossProfit = null)
    {
        // validation for constraint: float
        if (!is_null($estGrossProfit) && !(is_float($estGrossProfit) || is_numeric($estGrossProfit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estGrossProfit, true), gettype($estGrossProfit)), __LINE__);
        }
        $this->estGrossProfit = $estGrossProfit;
        return $this;
    }
    /**
     * Get estGrossProfitPercent value
     * @return float|null
     */
    public function getEstGrossProfitPercent()
    {
        return $this->estGrossProfitPercent;
    }
    /**
     * Set estGrossProfitPercent value
     * @param float $estGrossProfitPercent
     * @return \StructType\CashRefund
     */
    public function setEstGrossProfitPercent($estGrossProfitPercent = null)
    {
        // validation for constraint: float
        if (!is_null($estGrossProfitPercent) && !(is_float($estGrossProfitPercent) || is_numeric($estGrossProfitPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estGrossProfitPercent, true), gettype($estGrossProfitPercent)), __LINE__);
        }
        $this->estGrossProfitPercent = $estGrossProfitPercent;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\CashRefund
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\CashRefund
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\CashRefund
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\CashRefund
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get promoCode value
     * @return \StructType\RecordRef|null
     */
    public function getPromoCode()
    {
        return $this->promoCode;
    }
    /**
     * Set promoCode value
     * @param \StructType\RecordRef $promoCode
     * @return \StructType\CashRefund
     */
    public function setPromoCode(\StructType\RecordRef $promoCode = null)
    {
        $this->promoCode = $promoCode;
        return $this;
    }
    /**
     * Get discountItem value
     * @return \StructType\RecordRef|null
     */
    public function getDiscountItem()
    {
        return $this->discountItem;
    }
    /**
     * Set discountItem value
     * @param \StructType\RecordRef $discountItem
     * @return \StructType\CashRefund
     */
    public function setDiscountItem(\StructType\RecordRef $discountItem = null)
    {
        $this->discountItem = $discountItem;
        return $this;
    }
    /**
     * Get discountRate value
     * @return string|null
     */
    public function getDiscountRate()
    {
        return $this->discountRate;
    }
    /**
     * Set discountRate value
     * @param string $discountRate
     * @return \StructType\CashRefund
     */
    public function setDiscountRate($discountRate = null)
    {
        // validation for constraint: string
        if (!is_null($discountRate) && !is_string($discountRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountRate, true), gettype($discountRate)), __LINE__);
        }
        $this->discountRate = $discountRate;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\CashRefund
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get taxItem value
     * @return \StructType\RecordRef|null
     */
    public function getTaxItem()
    {
        return $this->taxItem;
    }
    /**
     * Set taxItem value
     * @param \StructType\RecordRef $taxItem
     * @return \StructType\CashRefund
     */
    public function setTaxItem(\StructType\RecordRef $taxItem = null)
    {
        $this->taxItem = $taxItem;
        return $this;
    }
    /**
     * Get taxRate value
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->taxRate;
    }
    /**
     * Set taxRate value
     * @param float $taxRate
     * @return \StructType\CashRefund
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->taxRate = $taxRate;
        return $this;
    }
    /**
     * Get toBePrinted value
     * @return bool|null
     */
    public function getToBePrinted()
    {
        return $this->toBePrinted;
    }
    /**
     * Set toBePrinted value
     * @param bool $toBePrinted
     * @return \StructType\CashRefund
     */
    public function setToBePrinted($toBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBePrinted) && !is_bool($toBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBePrinted, true), gettype($toBePrinted)), __LINE__);
        }
        $this->toBePrinted = $toBePrinted;
        return $this;
    }
    /**
     * Get toBeEmailed value
     * @return bool|null
     */
    public function getToBeEmailed()
    {
        return $this->toBeEmailed;
    }
    /**
     * Set toBeEmailed value
     * @param bool $toBeEmailed
     * @return \StructType\CashRefund
     */
    public function setToBeEmailed($toBeEmailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBeEmailed) && !is_bool($toBeEmailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBeEmailed, true), gettype($toBeEmailed)), __LINE__);
        }
        $this->toBeEmailed = $toBeEmailed;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CashRefund
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get toBeFaxed value
     * @return bool|null
     */
    public function getToBeFaxed()
    {
        return $this->toBeFaxed;
    }
    /**
     * Set toBeFaxed value
     * @param bool $toBeFaxed
     * @return \StructType\CashRefund
     */
    public function setToBeFaxed($toBeFaxed = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBeFaxed) && !is_bool($toBeFaxed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBeFaxed, true), gettype($toBeFaxed)), __LINE__);
        }
        $this->toBeFaxed = $toBeFaxed;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\CashRefund
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get messageSel value
     * @return \StructType\RecordRef|null
     */
    public function getMessageSel()
    {
        return $this->messageSel;
    }
    /**
     * Set messageSel value
     * @param \StructType\RecordRef $messageSel
     * @return \StructType\CashRefund
     */
    public function setMessageSel(\StructType\RecordRef $messageSel = null)
    {
        $this->messageSel = $messageSel;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\CashRefund
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get paymentOption value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentOption()
    {
        return $this->paymentOption;
    }
    /**
     * Set paymentOption value
     * @param \StructType\RecordRef $paymentOption
     * @return \StructType\CashRefund
     */
    public function setPaymentOption(\StructType\RecordRef $paymentOption = null)
    {
        $this->paymentOption = $paymentOption;
        return $this;
    }
    /**
     * Get inputAuthCode value
     * @return string|null
     */
    public function getInputAuthCode()
    {
        return $this->inputAuthCode;
    }
    /**
     * Set inputAuthCode value
     * @param string $inputAuthCode
     * @return \StructType\CashRefund
     */
    public function setInputAuthCode($inputAuthCode = null)
    {
        // validation for constraint: string
        if (!is_null($inputAuthCode) && !is_string($inputAuthCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputAuthCode, true), gettype($inputAuthCode)), __LINE__);
        }
        $this->inputAuthCode = $inputAuthCode;
        return $this;
    }
    /**
     * Get inputReferenceCode value
     * @return string|null
     */
    public function getInputReferenceCode()
    {
        return $this->inputReferenceCode;
    }
    /**
     * Set inputReferenceCode value
     * @param string $inputReferenceCode
     * @return \StructType\CashRefund
     */
    public function setInputReferenceCode($inputReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($inputReferenceCode) && !is_string($inputReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputReferenceCode, true), gettype($inputReferenceCode)), __LINE__);
        }
        $this->inputReferenceCode = $inputReferenceCode;
        return $this;
    }
    /**
     * Get checkNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->checkNumber;
    }
    /**
     * Set checkNumber value
     * @param string $checkNumber
     * @return \StructType\CashRefund
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkNumber, true), gettype($checkNumber)), __LINE__);
        }
        $this->checkNumber = $checkNumber;
        return $this;
    }
    /**
     * Get paymentCardCsc value
     * @return string|null
     */
    public function getPaymentCardCsc()
    {
        return $this->paymentCardCsc;
    }
    /**
     * Set paymentCardCsc value
     * @param string $paymentCardCsc
     * @return \StructType\CashRefund
     */
    public function setPaymentCardCsc($paymentCardCsc = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCardCsc) && !is_string($paymentCardCsc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCardCsc, true), gettype($paymentCardCsc)), __LINE__);
        }
        $this->paymentCardCsc = $paymentCardCsc;
        return $this;
    }
    /**
     * Get paymentProcessingProfile value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentProcessingProfile()
    {
        return $this->paymentProcessingProfile;
    }
    /**
     * Set paymentProcessingProfile value
     * @param \StructType\RecordRef $paymentProcessingProfile
     * @return \StructType\CashRefund
     */
    public function setPaymentProcessingProfile(\StructType\RecordRef $paymentProcessingProfile = null)
    {
        $this->paymentProcessingProfile = $paymentProcessingProfile;
        return $this;
    }
    /**
     * Get handlingMode value
     * @return string|null
     */
    public function getHandlingMode()
    {
        return $this->handlingMode;
    }
    /**
     * Set handlingMode value
     * @uses \EnumType\CashRefundHandlingMode::valueIsValid()
     * @uses \EnumType\CashRefundHandlingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $handlingMode
     * @return \StructType\CashRefund
     */
    public function setHandlingMode($handlingMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CashRefundHandlingMode::valueIsValid($handlingMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CashRefundHandlingMode', is_array($handlingMode) ? implode(', ', $handlingMode) : var_export($handlingMode, true), implode(', ', \EnumType\CashRefundHandlingMode::getValidValues())), __LINE__);
        }
        $this->handlingMode = $handlingMode;
        return $this;
    }
    /**
     * Get outputAuthCode value
     * @return string|null
     */
    public function getOutputAuthCode()
    {
        return $this->outputAuthCode;
    }
    /**
     * Set outputAuthCode value
     * @param string $outputAuthCode
     * @return \StructType\CashRefund
     */
    public function setOutputAuthCode($outputAuthCode = null)
    {
        // validation for constraint: string
        if (!is_null($outputAuthCode) && !is_string($outputAuthCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outputAuthCode, true), gettype($outputAuthCode)), __LINE__);
        }
        $this->outputAuthCode = $outputAuthCode;
        return $this;
    }
    /**
     * Get outputReferenceCode value
     * @return string|null
     */
    public function getOutputReferenceCode()
    {
        return $this->outputReferenceCode;
    }
    /**
     * Set outputReferenceCode value
     * @param string $outputReferenceCode
     * @return \StructType\CashRefund
     */
    public function setOutputReferenceCode($outputReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($outputReferenceCode) && !is_string($outputReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outputReferenceCode, true), gettype($outputReferenceCode)), __LINE__);
        }
        $this->outputReferenceCode = $outputReferenceCode;
        return $this;
    }
    /**
     * Get paymentOperation value
     * @return string|null
     */
    public function getPaymentOperation()
    {
        return $this->paymentOperation;
    }
    /**
     * Set paymentOperation value
     * @uses \EnumType\CashRefundPaymentOperation::valueIsValid()
     * @uses \EnumType\CashRefundPaymentOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentOperation
     * @return \StructType\CashRefund
     */
    public function setPaymentOperation($paymentOperation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CashRefundPaymentOperation::valueIsValid($paymentOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CashRefundPaymentOperation', is_array($paymentOperation) ? implode(', ', $paymentOperation) : var_export($paymentOperation, true), implode(', ', \EnumType\CashRefundPaymentOperation::getValidValues())), __LINE__);
        }
        $this->paymentOperation = $paymentOperation;
        return $this;
    }
    /**
     * Get dynamicDescriptor value
     * @return string|null
     */
    public function getDynamicDescriptor()
    {
        return $this->dynamicDescriptor;
    }
    /**
     * Set dynamicDescriptor value
     * @param string $dynamicDescriptor
     * @return \StructType\CashRefund
     */
    public function setDynamicDescriptor($dynamicDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicDescriptor) && !is_string($dynamicDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicDescriptor, true), gettype($dynamicDescriptor)), __LINE__);
        }
        $this->dynamicDescriptor = $dynamicDescriptor;
        return $this;
    }
    /**
     * Get billingAddress value
     * @return \StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\Address $billingAddress
     * @return \StructType\CashRefund
     */
    public function setBillingAddress(\StructType\Address $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get billAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getBillAddressList()
    {
        return $this->billAddressList;
    }
    /**
     * Set billAddressList value
     * @param \StructType\RecordRef $billAddressList
     * @return \StructType\CashRefund
     */
    public function setBillAddressList(\StructType\RecordRef $billAddressList = null)
    {
        $this->billAddressList = $billAddressList;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\CashRefund
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get shippingTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getShippingTaxCode()
    {
        return $this->shippingTaxCode;
    }
    /**
     * Set shippingTaxCode value
     * @param \StructType\RecordRef $shippingTaxCode
     * @return \StructType\CashRefund
     */
    public function setShippingTaxCode(\StructType\RecordRef $shippingTaxCode = null)
    {
        $this->shippingTaxCode = $shippingTaxCode;
        return $this;
    }
    /**
     * Get shippingTax1Rate value
     * @return float|null
     */
    public function getShippingTax1Rate()
    {
        return $this->shippingTax1Rate;
    }
    /**
     * Set shippingTax1Rate value
     * @param float $shippingTax1Rate
     * @return \StructType\CashRefund
     */
    public function setShippingTax1Rate($shippingTax1Rate = null)
    {
        // validation for constraint: float
        if (!is_null($shippingTax1Rate) && !(is_float($shippingTax1Rate) || is_numeric($shippingTax1Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingTax1Rate, true), gettype($shippingTax1Rate)), __LINE__);
        }
        $this->shippingTax1Rate = $shippingTax1Rate;
        return $this;
    }
    /**
     * Get shippingTax2Rate value
     * @return string|null
     */
    public function getShippingTax2Rate()
    {
        return $this->shippingTax2Rate;
    }
    /**
     * Set shippingTax2Rate value
     * @param string $shippingTax2Rate
     * @return \StructType\CashRefund
     */
    public function setShippingTax2Rate($shippingTax2Rate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingTax2Rate) && !is_string($shippingTax2Rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingTax2Rate, true), gettype($shippingTax2Rate)), __LINE__);
        }
        $this->shippingTax2Rate = $shippingTax2Rate;
        return $this;
    }
    /**
     * Get shippingCost value
     * @return float|null
     */
    public function getShippingCost()
    {
        return $this->shippingCost;
    }
    /**
     * Set shippingCost value
     * @param float $shippingCost
     * @return \StructType\CashRefund
     */
    public function setShippingCost($shippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCost) && !(is_float($shippingCost) || is_numeric($shippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCost, true), gettype($shippingCost)), __LINE__);
        }
        $this->shippingCost = $shippingCost;
        return $this;
    }
    /**
     * Get handlingTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getHandlingTaxCode()
    {
        return $this->handlingTaxCode;
    }
    /**
     * Set handlingTaxCode value
     * @param \StructType\RecordRef $handlingTaxCode
     * @return \StructType\CashRefund
     */
    public function setHandlingTaxCode(\StructType\RecordRef $handlingTaxCode = null)
    {
        $this->handlingTaxCode = $handlingTaxCode;
        return $this;
    }
    /**
     * Get handlingTax1Rate value
     * @return float|null
     */
    public function getHandlingTax1Rate()
    {
        return $this->handlingTax1Rate;
    }
    /**
     * Set handlingTax1Rate value
     * @param float $handlingTax1Rate
     * @return \StructType\CashRefund
     */
    public function setHandlingTax1Rate($handlingTax1Rate = null)
    {
        // validation for constraint: float
        if (!is_null($handlingTax1Rate) && !(is_float($handlingTax1Rate) || is_numeric($handlingTax1Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingTax1Rate, true), gettype($handlingTax1Rate)), __LINE__);
        }
        $this->handlingTax1Rate = $handlingTax1Rate;
        return $this;
    }
    /**
     * Get handlingTax2Rate value
     * @return string|null
     */
    public function getHandlingTax2Rate()
    {
        return $this->handlingTax2Rate;
    }
    /**
     * Set handlingTax2Rate value
     * @param string $handlingTax2Rate
     * @return \StructType\CashRefund
     */
    public function setHandlingTax2Rate($handlingTax2Rate = null)
    {
        // validation for constraint: string
        if (!is_null($handlingTax2Rate) && !is_string($handlingTax2Rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlingTax2Rate, true), gettype($handlingTax2Rate)), __LINE__);
        }
        $this->handlingTax2Rate = $handlingTax2Rate;
        return $this;
    }
    /**
     * Get handlingCost value
     * @return float|null
     */
    public function getHandlingCost()
    {
        return $this->handlingCost;
    }
    /**
     * Set handlingCost value
     * @param float $handlingCost
     * @return \StructType\CashRefund
     */
    public function setHandlingCost($handlingCost = null)
    {
        // validation for constraint: float
        if (!is_null($handlingCost) && !(is_float($handlingCost) || is_numeric($handlingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingCost, true), gettype($handlingCost)), __LINE__);
        }
        $this->handlingCost = $handlingCost;
        return $this;
    }
    /**
     * Get salesGroup value
     * @return \StructType\RecordRef|null
     */
    public function getSalesGroup()
    {
        return $this->salesGroup;
    }
    /**
     * Set salesGroup value
     * @param \StructType\RecordRef $salesGroup
     * @return \StructType\CashRefund
     */
    public function setSalesGroup(\StructType\RecordRef $salesGroup = null)
    {
        $this->salesGroup = $salesGroup;
        return $this;
    }
    /**
     * Get syncSalesTeams value
     * @return bool|null
     */
    public function getSyncSalesTeams()
    {
        return $this->syncSalesTeams;
    }
    /**
     * Set syncSalesTeams value
     * @param bool $syncSalesTeams
     * @return \StructType\CashRefund
     */
    public function setSyncSalesTeams($syncSalesTeams = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncSalesTeams) && !is_bool($syncSalesTeams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncSalesTeams, true), gettype($syncSalesTeams)), __LINE__);
        }
        $this->syncSalesTeams = $syncSalesTeams;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param \StructType\RecordRef $paymentMethod
     * @return \StructType\CashRefund
     */
    public function setPaymentMethod(\StructType\RecordRef $paymentMethod = null)
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get revenueStatus value
     * @return string|null
     */
    public function getRevenueStatus()
    {
        return $this->revenueStatus;
    }
    /**
     * Set revenueStatus value
     * @uses \EnumType\RevenueStatus::valueIsValid()
     * @uses \EnumType\RevenueStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $revenueStatus
     * @return \StructType\CashRefund
     */
    public function setRevenueStatus($revenueStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RevenueStatus::valueIsValid($revenueStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RevenueStatus', is_array($revenueStatus) ? implode(', ', $revenueStatus) : var_export($revenueStatus, true), implode(', ', \EnumType\RevenueStatus::getValidValues())), __LINE__);
        }
        $this->revenueStatus = $revenueStatus;
        return $this;
    }
    /**
     * Get recognizedRevenue value
     * @return float|null
     */
    public function getRecognizedRevenue()
    {
        return $this->recognizedRevenue;
    }
    /**
     * Set recognizedRevenue value
     * @param float $recognizedRevenue
     * @return \StructType\CashRefund
     */
    public function setRecognizedRevenue($recognizedRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($recognizedRevenue) && !(is_float($recognizedRevenue) || is_numeric($recognizedRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recognizedRevenue, true), gettype($recognizedRevenue)), __LINE__);
        }
        $this->recognizedRevenue = $recognizedRevenue;
        return $this;
    }
    /**
     * Get deferredRevenue value
     * @return float|null
     */
    public function getDeferredRevenue()
    {
        return $this->deferredRevenue;
    }
    /**
     * Set deferredRevenue value
     * @param float $deferredRevenue
     * @return \StructType\CashRefund
     */
    public function setDeferredRevenue($deferredRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($deferredRevenue) && !(is_float($deferredRevenue) || is_numeric($deferredRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deferredRevenue, true), gettype($deferredRevenue)), __LINE__);
        }
        $this->deferredRevenue = $deferredRevenue;
        return $this;
    }
    /**
     * Get revRecOnRevCommitment value
     * @return bool|null
     */
    public function getRevRecOnRevCommitment()
    {
        return $this->revRecOnRevCommitment;
    }
    /**
     * Set revRecOnRevCommitment value
     * @param bool $revRecOnRevCommitment
     * @return \StructType\CashRefund
     */
    public function setRevRecOnRevCommitment($revRecOnRevCommitment = null)
    {
        // validation for constraint: boolean
        if (!is_null($revRecOnRevCommitment) && !is_bool($revRecOnRevCommitment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($revRecOnRevCommitment, true), gettype($revRecOnRevCommitment)), __LINE__);
        }
        $this->revRecOnRevCommitment = $revRecOnRevCommitment;
        return $this;
    }
    /**
     * Get creditCard value
     * @return \StructType\RecordRef|null
     */
    public function getCreditCard()
    {
        return $this->creditCard;
    }
    /**
     * Set creditCard value
     * @param \StructType\RecordRef $creditCard
     * @return \StructType\CashRefund
     */
    public function setCreditCard(\StructType\RecordRef $creditCard = null)
    {
        $this->creditCard = $creditCard;
        return $this;
    }
    /**
     * Get chargeIt value
     * @return bool|null
     */
    public function getChargeIt()
    {
        return $this->chargeIt;
    }
    /**
     * Set chargeIt value
     * @param bool $chargeIt
     * @return \StructType\CashRefund
     */
    public function setChargeIt($chargeIt = null)
    {
        // validation for constraint: boolean
        if (!is_null($chargeIt) && !is_bool($chargeIt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($chargeIt, true), gettype($chargeIt)), __LINE__);
        }
        $this->chargeIt = $chargeIt;
        return $this;
    }
    /**
     * Get ccNumber value
     * @return string|null
     */
    public function getCcNumber()
    {
        return $this->ccNumber;
    }
    /**
     * Set ccNumber value
     * @param string $ccNumber
     * @return \StructType\CashRefund
     */
    public function setCcNumber($ccNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ccNumber) && !is_string($ccNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccNumber, true), gettype($ccNumber)), __LINE__);
        }
        $this->ccNumber = $ccNumber;
        return $this;
    }
    /**
     * Get ccExpireDate value
     * @return string|null
     */
    public function getCcExpireDate()
    {
        return $this->ccExpireDate;
    }
    /**
     * Set ccExpireDate value
     * @param string $ccExpireDate
     * @return \StructType\CashRefund
     */
    public function setCcExpireDate($ccExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($ccExpireDate) && !is_string($ccExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccExpireDate, true), gettype($ccExpireDate)), __LINE__);
        }
        $this->ccExpireDate = $ccExpireDate;
        return $this;
    }
    /**
     * Get ccName value
     * @return string|null
     */
    public function getCcName()
    {
        return $this->ccName;
    }
    /**
     * Set ccName value
     * @param string $ccName
     * @return \StructType\CashRefund
     */
    public function setCcName($ccName = null)
    {
        // validation for constraint: string
        if (!is_null($ccName) && !is_string($ccName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccName, true), gettype($ccName)), __LINE__);
        }
        $this->ccName = $ccName;
        return $this;
    }
    /**
     * Get ccStreet value
     * @return string|null
     */
    public function getCcStreet()
    {
        return $this->ccStreet;
    }
    /**
     * Set ccStreet value
     * @param string $ccStreet
     * @return \StructType\CashRefund
     */
    public function setCcStreet($ccStreet = null)
    {
        // validation for constraint: string
        if (!is_null($ccStreet) && !is_string($ccStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccStreet, true), gettype($ccStreet)), __LINE__);
        }
        $this->ccStreet = $ccStreet;
        return $this;
    }
    /**
     * Get ccZipCode value
     * @return string|null
     */
    public function getCcZipCode()
    {
        return $this->ccZipCode;
    }
    /**
     * Set ccZipCode value
     * @param string $ccZipCode
     * @return \StructType\CashRefund
     */
    public function setCcZipCode($ccZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($ccZipCode) && !is_string($ccZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccZipCode, true), gettype($ccZipCode)), __LINE__);
        }
        $this->ccZipCode = $ccZipCode;
        return $this;
    }
    /**
     * Get ccApproved value
     * @return bool|null
     */
    public function getCcApproved()
    {
        return $this->ccApproved;
    }
    /**
     * Set ccApproved value
     * @param bool $ccApproved
     * @return \StructType\CashRefund
     */
    public function setCcApproved($ccApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($ccApproved) && !is_bool($ccApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ccApproved, true), gettype($ccApproved)), __LINE__);
        }
        $this->ccApproved = $ccApproved;
        return $this;
    }
    /**
     * Get creditCardProcessor value
     * @return \StructType\RecordRef|null
     */
    public function getCreditCardProcessor()
    {
        return $this->creditCardProcessor;
    }
    /**
     * Set creditCardProcessor value
     * @param \StructType\RecordRef $creditCardProcessor
     * @return \StructType\CashRefund
     */
    public function setCreditCardProcessor(\StructType\RecordRef $creditCardProcessor = null)
    {
        $this->creditCardProcessor = $creditCardProcessor;
        return $this;
    }
    /**
     * Get debitCardIssueNo value
     * @return string|null
     */
    public function getDebitCardIssueNo()
    {
        return $this->debitCardIssueNo;
    }
    /**
     * Set debitCardIssueNo value
     * @param string $debitCardIssueNo
     * @return \StructType\CashRefund
     */
    public function setDebitCardIssueNo($debitCardIssueNo = null)
    {
        // validation for constraint: string
        if (!is_null($debitCardIssueNo) && !is_string($debitCardIssueNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debitCardIssueNo, true), gettype($debitCardIssueNo)), __LINE__);
        }
        $this->debitCardIssueNo = $debitCardIssueNo;
        return $this;
    }
    /**
     * Get pnRefNum value
     * @return string|null
     */
    public function getPnRefNum()
    {
        return $this->pnRefNum;
    }
    /**
     * Set pnRefNum value
     * @param string $pnRefNum
     * @return \StructType\CashRefund
     */
    public function setPnRefNum($pnRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($pnRefNum) && !is_string($pnRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pnRefNum, true), gettype($pnRefNum)), __LINE__);
        }
        $this->pnRefNum = $pnRefNum;
        return $this;
    }
    /**
     * Get validFrom value
     * @return string|null
     */
    public function getValidFrom()
    {
        return $this->validFrom;
    }
    /**
     * Set validFrom value
     * @param string $validFrom
     * @return \StructType\CashRefund
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->validFrom = $validFrom;
        return $this;
    }
    /**
     * Get payPalTranId value
     * @return string|null
     */
    public function getPayPalTranId()
    {
        return $this->payPalTranId;
    }
    /**
     * Set payPalTranId value
     * @param string $payPalTranId
     * @return \StructType\CashRefund
     */
    public function setPayPalTranId($payPalTranId = null)
    {
        // validation for constraint: string
        if (!is_null($payPalTranId) && !is_string($payPalTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPalTranId, true), gettype($payPalTranId)), __LINE__);
        }
        $this->payPalTranId = $payPalTranId;
        return $this;
    }
    /**
     * Get subTotal value
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->subTotal;
    }
    /**
     * Set subTotal value
     * @param float $subTotal
     * @return \StructType\CashRefund
     */
    public function setSubTotal($subTotal = null)
    {
        // validation for constraint: float
        if (!is_null($subTotal) && !(is_float($subTotal) || is_numeric($subTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subTotal, true), gettype($subTotal)), __LINE__);
        }
        $this->subTotal = $subTotal;
        return $this;
    }
    /**
     * Get ccIsPurchaseCardBin value
     * @return bool|null
     */
    public function getCcIsPurchaseCardBin()
    {
        return $this->ccIsPurchaseCardBin;
    }
    /**
     * Set ccIsPurchaseCardBin value
     * @param bool $ccIsPurchaseCardBin
     * @return \StructType\CashRefund
     */
    public function setCcIsPurchaseCardBin($ccIsPurchaseCardBin = null)
    {
        // validation for constraint: boolean
        if (!is_null($ccIsPurchaseCardBin) && !is_bool($ccIsPurchaseCardBin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ccIsPurchaseCardBin, true), gettype($ccIsPurchaseCardBin)), __LINE__);
        }
        $this->ccIsPurchaseCardBin = $ccIsPurchaseCardBin;
        return $this;
    }
    /**
     * Get discountTotal value
     * @return float|null
     */
    public function getDiscountTotal()
    {
        return $this->discountTotal;
    }
    /**
     * Set discountTotal value
     * @param float $discountTotal
     * @return \StructType\CashRefund
     */
    public function setDiscountTotal($discountTotal = null)
    {
        // validation for constraint: float
        if (!is_null($discountTotal) && !(is_float($discountTotal) || is_numeric($discountTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountTotal, true), gettype($discountTotal)), __LINE__);
        }
        $this->discountTotal = $discountTotal;
        return $this;
    }
    /**
     * Get ccProcessAsPurchaseCard value
     * @return bool|null
     */
    public function getCcProcessAsPurchaseCard()
    {
        return $this->ccProcessAsPurchaseCard;
    }
    /**
     * Set ccProcessAsPurchaseCard value
     * @param bool $ccProcessAsPurchaseCard
     * @return \StructType\CashRefund
     */
    public function setCcProcessAsPurchaseCard($ccProcessAsPurchaseCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($ccProcessAsPurchaseCard) && !is_bool($ccProcessAsPurchaseCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ccProcessAsPurchaseCard, true), gettype($ccProcessAsPurchaseCard)), __LINE__);
        }
        $this->ccProcessAsPurchaseCard = $ccProcessAsPurchaseCard;
        return $this;
    }
    /**
     * Get taxTotal value
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->taxTotal;
    }
    /**
     * Set taxTotal value
     * @param float $taxTotal
     * @return \StructType\CashRefund
     */
    public function setTaxTotal($taxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotal) && !(is_float($taxTotal) || is_numeric($taxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotal, true), gettype($taxTotal)), __LINE__);
        }
        $this->taxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get tax2Total value
     * @return float|null
     */
    public function getTax2Total()
    {
        return $this->tax2Total;
    }
    /**
     * Set tax2Total value
     * @param float $tax2Total
     * @return \StructType\CashRefund
     */
    public function setTax2Total($tax2Total = null)
    {
        // validation for constraint: float
        if (!is_null($tax2Total) && !(is_float($tax2Total) || is_numeric($tax2Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax2Total, true), gettype($tax2Total)), __LINE__);
        }
        $this->tax2Total = $tax2Total;
        return $this;
    }
    /**
     * Get altShippingCost value
     * @return float|null
     */
    public function getAltShippingCost()
    {
        return $this->altShippingCost;
    }
    /**
     * Set altShippingCost value
     * @param float $altShippingCost
     * @return \StructType\CashRefund
     */
    public function setAltShippingCost($altShippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($altShippingCost) && !(is_float($altShippingCost) || is_numeric($altShippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altShippingCost, true), gettype($altShippingCost)), __LINE__);
        }
        $this->altShippingCost = $altShippingCost;
        return $this;
    }
    /**
     * Get payPalStatus value
     * @return string|null
     */
    public function getPayPalStatus()
    {
        return $this->payPalStatus;
    }
    /**
     * Set payPalStatus value
     * @param string $payPalStatus
     * @return \StructType\CashRefund
     */
    public function setPayPalStatus($payPalStatus = null)
    {
        // validation for constraint: string
        if (!is_null($payPalStatus) && !is_string($payPalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPalStatus, true), gettype($payPalStatus)), __LINE__);
        }
        $this->payPalStatus = $payPalStatus;
        return $this;
    }
    /**
     * Get altHandlingCost value
     * @return float|null
     */
    public function getAltHandlingCost()
    {
        return $this->altHandlingCost;
    }
    /**
     * Set altHandlingCost value
     * @param float $altHandlingCost
     * @return \StructType\CashRefund
     */
    public function setAltHandlingCost($altHandlingCost = null)
    {
        // validation for constraint: float
        if (!is_null($altHandlingCost) && !(is_float($altHandlingCost) || is_numeric($altHandlingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altHandlingCost, true), gettype($altHandlingCost)), __LINE__);
        }
        $this->altHandlingCost = $altHandlingCost;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\CashRefund
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get payPalAuthId value
     * @return string|null
     */
    public function getPayPalAuthId()
    {
        return $this->payPalAuthId;
    }
    /**
     * Set payPalAuthId value
     * @param string $payPalAuthId
     * @return \StructType\CashRefund
     */
    public function setPayPalAuthId($payPalAuthId = null)
    {
        // validation for constraint: string
        if (!is_null($payPalAuthId) && !is_string($payPalAuthId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPalAuthId, true), gettype($payPalAuthId)), __LINE__);
        }
        $this->payPalAuthId = $payPalAuthId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\CashRefund
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\CashRefund
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get giftCert value
     * @return \StructType\RecordRef|null
     */
    public function getGiftCert()
    {
        return $this->giftCert;
    }
    /**
     * Set giftCert value
     * @param \StructType\RecordRef $giftCert
     * @return \StructType\CashRefund
     */
    public function setGiftCert(\StructType\RecordRef $giftCert = null)
    {
        $this->giftCert = $giftCert;
        return $this;
    }
    /**
     * Get giftCertTotal value
     * @return float|null
     */
    public function getGiftCertTotal()
    {
        return $this->giftCertTotal;
    }
    /**
     * Set giftCertTotal value
     * @param float $giftCertTotal
     * @return \StructType\CashRefund
     */
    public function setGiftCertTotal($giftCertTotal = null)
    {
        // validation for constraint: float
        if (!is_null($giftCertTotal) && !(is_float($giftCertTotal) || is_numeric($giftCertTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($giftCertTotal, true), gettype($giftCertTotal)), __LINE__);
        }
        $this->giftCertTotal = $giftCertTotal;
        return $this;
    }
    /**
     * Get giftCertApplied value
     * @return float|null
     */
    public function getGiftCertApplied()
    {
        return $this->giftCertApplied;
    }
    /**
     * Set giftCertApplied value
     * @param float $giftCertApplied
     * @return \StructType\CashRefund
     */
    public function setGiftCertApplied($giftCertApplied = null)
    {
        // validation for constraint: float
        if (!is_null($giftCertApplied) && !(is_float($giftCertApplied) || is_numeric($giftCertApplied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($giftCertApplied, true), gettype($giftCertApplied)), __LINE__);
        }
        $this->giftCertApplied = $giftCertApplied;
        return $this;
    }
    /**
     * Get giftCertAvailable value
     * @return float|null
     */
    public function getGiftCertAvailable()
    {
        return $this->giftCertAvailable;
    }
    /**
     * Set giftCertAvailable value
     * @param float $giftCertAvailable
     * @return \StructType\CashRefund
     */
    public function setGiftCertAvailable($giftCertAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($giftCertAvailable) && !(is_float($giftCertAvailable) || is_numeric($giftCertAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($giftCertAvailable, true), gettype($giftCertAvailable)), __LINE__);
        }
        $this->giftCertAvailable = $giftCertAvailable;
        return $this;
    }
    /**
     * Get tranIsVsoeBundle value
     * @return bool|null
     */
    public function getTranIsVsoeBundle()
    {
        return $this->tranIsVsoeBundle;
    }
    /**
     * Set tranIsVsoeBundle value
     * @param bool $tranIsVsoeBundle
     * @return \StructType\CashRefund
     */
    public function setTranIsVsoeBundle($tranIsVsoeBundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($tranIsVsoeBundle) && !is_bool($tranIsVsoeBundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tranIsVsoeBundle, true), gettype($tranIsVsoeBundle)), __LINE__);
        }
        $this->tranIsVsoeBundle = $tranIsVsoeBundle;
        return $this;
    }
    /**
     * Get payPalProcess value
     * @return bool|null
     */
    public function getPayPalProcess()
    {
        return $this->payPalProcess;
    }
    /**
     * Set payPalProcess value
     * @param bool $payPalProcess
     * @return \StructType\CashRefund
     */
    public function setPayPalProcess($payPalProcess = null)
    {
        // validation for constraint: boolean
        if (!is_null($payPalProcess) && !is_bool($payPalProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payPalProcess, true), gettype($payPalProcess)), __LINE__);
        }
        $this->payPalProcess = $payPalProcess;
        return $this;
    }
    /**
     * Get vsoeAutoCalc value
     * @return bool|null
     */
    public function getVsoeAutoCalc()
    {
        return $this->vsoeAutoCalc;
    }
    /**
     * Set vsoeAutoCalc value
     * @param bool $vsoeAutoCalc
     * @return \StructType\CashRefund
     */
    public function setVsoeAutoCalc($vsoeAutoCalc = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeAutoCalc) && !is_bool($vsoeAutoCalc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeAutoCalc, true), gettype($vsoeAutoCalc)), __LINE__);
        }
        $this->vsoeAutoCalc = $vsoeAutoCalc;
        return $this;
    }
    /**
     * Get syncPartnerTeams value
     * @return bool|null
     */
    public function getSyncPartnerTeams()
    {
        return $this->syncPartnerTeams;
    }
    /**
     * Set syncPartnerTeams value
     * @param bool $syncPartnerTeams
     * @return \StructType\CashRefund
     */
    public function setSyncPartnerTeams($syncPartnerTeams = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncPartnerTeams) && !is_bool($syncPartnerTeams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncPartnerTeams, true), gettype($syncPartnerTeams)), __LINE__);
        }
        $this->syncPartnerTeams = $syncPartnerTeams;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\CashRefundItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\CashRefundItemList $itemList
     * @return \StructType\CashRefund
     */
    public function setItemList(\StructType\CashRefundItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\CashRefund
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get salesTeamList value
     * @return \StructType\CashRefundSalesTeamList|null
     */
    public function getSalesTeamList()
    {
        return $this->salesTeamList;
    }
    /**
     * Set salesTeamList value
     * @param \StructType\CashRefundSalesTeamList $salesTeamList
     * @return \StructType\CashRefund
     */
    public function setSalesTeamList(\StructType\CashRefundSalesTeamList $salesTeamList = null)
    {
        $this->salesTeamList = $salesTeamList;
        return $this;
    }
    /**
     * Get partnersList value
     * @return \StructType\CashRefundPartnersList|null
     */
    public function getPartnersList()
    {
        return $this->partnersList;
    }
    /**
     * Set partnersList value
     * @param \StructType\CashRefundPartnersList $partnersList
     * @return \StructType\CashRefund
     */
    public function setPartnersList(\StructType\CashRefundPartnersList $partnersList = null)
    {
        $this->partnersList = $partnersList;
        return $this;
    }
    /**
     * Get taxDetailsList value
     * @return \StructType\TaxDetailsList|null
     */
    public function getTaxDetailsList()
    {
        return $this->taxDetailsList;
    }
    /**
     * Set taxDetailsList value
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @return \StructType\CashRefund
     */
    public function setTaxDetailsList(\StructType\TaxDetailsList $taxDetailsList = null)
    {
        $this->taxDetailsList = $taxDetailsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CashRefund
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CashRefund
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\CashRefund
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
