<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignResponse StructType
 * Meta information extracted from the WSDL
 * - type: listMkt:CampaignResponse
 * @subpackage Structs
 */
class CampaignResponse extends Record
{
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The leadSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $leadSource;
    /**
     * The campaignEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $campaignEvent;
    /**
     * The campaignResponseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $campaignResponseDate;
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $channel;
    /**
     * The response
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $response;
    /**
     * The note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $note;
    /**
     * The responsesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CampaignResponseResponsesList
     */
    public $responsesList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for CampaignResponse
     * @uses CampaignResponse::setEntity()
     * @uses CampaignResponse::setLeadSource()
     * @uses CampaignResponse::setCampaignEvent()
     * @uses CampaignResponse::setCampaignResponseDate()
     * @uses CampaignResponse::setChannel()
     * @uses CampaignResponse::setResponse()
     * @uses CampaignResponse::setNote()
     * @uses CampaignResponse::setResponsesList()
     * @uses CampaignResponse::setInternalId()
     * @uses CampaignResponse::setExternalId()
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $leadSource
     * @param \StructType\RecordRef $campaignEvent
     * @param string $campaignResponseDate
     * @param string $channel
     * @param string $response
     * @param string $note
     * @param \StructType\CampaignResponseResponsesList $responsesList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $entity = null, \StructType\RecordRef $leadSource = null, \StructType\RecordRef $campaignEvent = null, $campaignResponseDate = null, $channel = null, $response = null, $note = null, \StructType\CampaignResponseResponsesList $responsesList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setEntity($entity)
            ->setLeadSource($leadSource)
            ->setCampaignEvent($campaignEvent)
            ->setCampaignResponseDate($campaignResponseDate)
            ->setChannel($channel)
            ->setResponse($response)
            ->setNote($note)
            ->setResponsesList($responsesList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\CampaignResponse
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get leadSource value
     * @return \StructType\RecordRef|null
     */
    public function getLeadSource()
    {
        return $this->leadSource;
    }
    /**
     * Set leadSource value
     * @param \StructType\RecordRef $leadSource
     * @return \StructType\CampaignResponse
     */
    public function setLeadSource(\StructType\RecordRef $leadSource = null)
    {
        $this->leadSource = $leadSource;
        return $this;
    }
    /**
     * Get campaignEvent value
     * @return \StructType\RecordRef|null
     */
    public function getCampaignEvent()
    {
        return $this->campaignEvent;
    }
    /**
     * Set campaignEvent value
     * @param \StructType\RecordRef $campaignEvent
     * @return \StructType\CampaignResponse
     */
    public function setCampaignEvent(\StructType\RecordRef $campaignEvent = null)
    {
        $this->campaignEvent = $campaignEvent;
        return $this;
    }
    /**
     * Get campaignResponseDate value
     * @return string|null
     */
    public function getCampaignResponseDate()
    {
        return $this->campaignResponseDate;
    }
    /**
     * Set campaignResponseDate value
     * @param string $campaignResponseDate
     * @return \StructType\CampaignResponse
     */
    public function setCampaignResponseDate($campaignResponseDate = null)
    {
        // validation for constraint: string
        if (!is_null($campaignResponseDate) && !is_string($campaignResponseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignResponseDate, true), gettype($campaignResponseDate)), __LINE__);
        }
        $this->campaignResponseDate = $campaignResponseDate;
        return $this;
    }
    /**
     * Get channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param string $channel
     * @return \StructType\CampaignResponse
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get response value
     * @return string|null
     */
    public function getResponse()
    {
        return $this->response;
    }
    /**
     * Set response value
     * @uses \EnumType\CampaignResponseResponse::valueIsValid()
     * @uses \EnumType\CampaignResponseResponse::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $response
     * @return \StructType\CampaignResponse
     */
    public function setResponse($response = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignResponseResponse::valueIsValid($response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignResponseResponse', is_array($response) ? implode(', ', $response) : var_export($response, true), implode(', ', \EnumType\CampaignResponseResponse::getValidValues())), __LINE__);
        }
        $this->response = $response;
        return $this;
    }
    /**
     * Get note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \StructType\CampaignResponse
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Get responsesList value
     * @return \StructType\CampaignResponseResponsesList|null
     */
    public function getResponsesList()
    {
        return $this->responsesList;
    }
    /**
     * Set responsesList value
     * @param \StructType\CampaignResponseResponsesList $responsesList
     * @return \StructType\CampaignResponse
     */
    public function setResponsesList(\StructType\CampaignResponseResponsesList $responsesList = null)
    {
        $this->responsesList = $responsesList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CampaignResponse
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\CampaignResponse
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
