<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignEventResponseList StructType
 * @subpackage Structs
 */
class CampaignEventResponseList extends AbstractStructBase
{
    /**
     * The eventResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CampaignEventResponse[]
     */
    public $eventResponse;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CampaignEventResponseList
     * @uses CampaignEventResponseList::setEventResponse()
     * @uses CampaignEventResponseList::setReplaceAll()
     * @param \StructType\CampaignEventResponse[] $eventResponse
     * @param bool $replaceAll
     */
    public function __construct(array $eventResponse = array(), $replaceAll = true)
    {
        $this
            ->setEventResponse($eventResponse)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get eventResponse value
     * @return \StructType\CampaignEventResponse[]|null
     */
    public function getEventResponse()
    {
        return $this->eventResponse;
    }
    /**
     * This method is responsible for validating the values passed to the setEventResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventResponseForArrayConstraintsFromSetEventResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $campaignEventResponseListEventResponseItem) {
            // validation for constraint: itemType
            if (!$campaignEventResponseListEventResponseItem instanceof \StructType\CampaignEventResponse) {
                $invalidValues[] = is_object($campaignEventResponseListEventResponseItem) ? get_class($campaignEventResponseListEventResponseItem) : sprintf('%s(%s)', gettype($campaignEventResponseListEventResponseItem), var_export($campaignEventResponseListEventResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The eventResponse property can only contain items of type \StructType\CampaignEventResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set eventResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignEventResponse[] $eventResponse
     * @return \StructType\CampaignEventResponseList
     */
    public function setEventResponse(array $eventResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($eventResponseArrayErrorMessage = self::validateEventResponseForArrayConstraintsFromSetEventResponse($eventResponse))) {
            throw new \InvalidArgumentException($eventResponseArrayErrorMessage, __LINE__);
        }
        $this->eventResponse = $eventResponse;
        return $this;
    }
    /**
     * Add item to eventResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignEventResponse $item
     * @return \StructType\CampaignEventResponseList
     */
    public function addToEventResponse(\StructType\CampaignEventResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CampaignEventResponse) {
            throw new \InvalidArgumentException(sprintf('The eventResponse property can only contain items of type \StructType\CampaignEventResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->eventResponse[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CampaignEventResponseList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
