<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignEventList StructType
 * @subpackage Structs
 */
class CampaignEventList extends AbstractStructBase
{
    /**
     * The campaignEvent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CampaignEvent[]
     */
    public $campaignEvent;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CampaignEventList
     * @uses CampaignEventList::setCampaignEvent()
     * @uses CampaignEventList::setReplaceAll()
     * @param \StructType\CampaignEvent[] $campaignEvent
     * @param bool $replaceAll
     */
    public function __construct(array $campaignEvent = array(), $replaceAll = true)
    {
        $this
            ->setCampaignEvent($campaignEvent)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get campaignEvent value
     * @return \StructType\CampaignEvent[]|null
     */
    public function getCampaignEvent()
    {
        return $this->campaignEvent;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignEvent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignEvent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignEventForArrayConstraintsFromSetCampaignEvent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $campaignEventListCampaignEventItem) {
            // validation for constraint: itemType
            if (!$campaignEventListCampaignEventItem instanceof \StructType\CampaignEvent) {
                $invalidValues[] = is_object($campaignEventListCampaignEventItem) ? get_class($campaignEventListCampaignEventItem) : sprintf('%s(%s)', gettype($campaignEventListCampaignEventItem), var_export($campaignEventListCampaignEventItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The campaignEvent property can only contain items of type \StructType\CampaignEvent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set campaignEvent value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignEvent[] $campaignEvent
     * @return \StructType\CampaignEventList
     */
    public function setCampaignEvent(array $campaignEvent = array())
    {
        // validation for constraint: array
        if ('' !== ($campaignEventArrayErrorMessage = self::validateCampaignEventForArrayConstraintsFromSetCampaignEvent($campaignEvent))) {
            throw new \InvalidArgumentException($campaignEventArrayErrorMessage, __LINE__);
        }
        $this->campaignEvent = $campaignEvent;
        return $this;
    }
    /**
     * Add item to campaignEvent value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignEvent $item
     * @return \StructType\CampaignEventList
     */
    public function addToCampaignEvent(\StructType\CampaignEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CampaignEvent) {
            throw new \InvalidArgumentException(sprintf('The campaignEvent property can only contain items of type \StructType\CampaignEvent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->campaignEvent[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CampaignEventList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
