<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignEmailList StructType
 * @subpackage Structs
 */
class CampaignEmailList extends AbstractStructBase
{
    /**
     * The campaignEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CampaignEmail[]
     */
    public $campaignEmail;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CampaignEmailList
     * @uses CampaignEmailList::setCampaignEmail()
     * @uses CampaignEmailList::setReplaceAll()
     * @param \StructType\CampaignEmail[] $campaignEmail
     * @param bool $replaceAll
     */
    public function __construct(array $campaignEmail = array(), $replaceAll = true)
    {
        $this
            ->setCampaignEmail($campaignEmail)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get campaignEmail value
     * @return \StructType\CampaignEmail[]|null
     */
    public function getCampaignEmail()
    {
        return $this->campaignEmail;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignEmailForArrayConstraintsFromSetCampaignEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $campaignEmailListCampaignEmailItem) {
            // validation for constraint: itemType
            if (!$campaignEmailListCampaignEmailItem instanceof \StructType\CampaignEmail) {
                $invalidValues[] = is_object($campaignEmailListCampaignEmailItem) ? get_class($campaignEmailListCampaignEmailItem) : sprintf('%s(%s)', gettype($campaignEmailListCampaignEmailItem), var_export($campaignEmailListCampaignEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The campaignEmail property can only contain items of type \StructType\CampaignEmail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set campaignEmail value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignEmail[] $campaignEmail
     * @return \StructType\CampaignEmailList
     */
    public function setCampaignEmail(array $campaignEmail = array())
    {
        // validation for constraint: array
        if ('' !== ($campaignEmailArrayErrorMessage = self::validateCampaignEmailForArrayConstraintsFromSetCampaignEmail($campaignEmail))) {
            throw new \InvalidArgumentException($campaignEmailArrayErrorMessage, __LINE__);
        }
        $this->campaignEmail = $campaignEmail;
        return $this;
    }
    /**
     * Add item to campaignEmail value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignEmail $item
     * @return \StructType\CampaignEmailList
     */
    public function addToCampaignEmail(\StructType\CampaignEmail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CampaignEmail) {
            throw new \InvalidArgumentException(sprintf('The campaignEmail property can only contain items of type \StructType\CampaignEmail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->campaignEmail[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CampaignEmailList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
