<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Campaign StructType
 * Meta information extracted from the WSDL
 * - type: listMkt:Campaign
 * @subpackage Structs
 */
class Campaign extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The campaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $campaignId;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $category;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $owner;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The baseCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $baseCost;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cost;
    /**
     * The expectedRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $expectedRevenue;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The local
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $local;
    /**
     * The totalRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalRevenue;
    /**
     * The roi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $roi;
    /**
     * The profit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $profit;
    /**
     * The costPerCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costPerCustomer;
    /**
     * The convCostPerCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $convCostPerCustomer;
    /**
     * The conversions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $conversions;
    /**
     * The leadsGenerated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $leadsGenerated;
    /**
     * The uniqueVisitors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $uniqueVisitors;
    /**
     * The vertical
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $vertical;
    /**
     * The audience
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $audience;
    /**
     * The offer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $offer;
    /**
     * The promotionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $promotionCode;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $itemList;
    /**
     * The family
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $family;
    /**
     * The searchEngine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $searchEngine;
    /**
     * The keyword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $keyword;
    /**
     * The campaignEmailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CampaignEmailList
     */
    public $campaignEmailList;
    /**
     * The campaignDirectMailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CampaignDirectMailList
     */
    public $campaignDirectMailList;
    /**
     * The campaignEventList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CampaignEventList
     */
    public $campaignEventList;
    /**
     * The eventResponseList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CampaignEventResponseList
     */
    public $eventResponseList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Campaign
     * @uses Campaign::setCustomForm()
     * @uses Campaign::setCampaignId()
     * @uses Campaign::setTitle()
     * @uses Campaign::setCategory()
     * @uses Campaign::setOwner()
     * @uses Campaign::setStartDate()
     * @uses Campaign::setEndDate()
     * @uses Campaign::setUrl()
     * @uses Campaign::setBaseCost()
     * @uses Campaign::setCost()
     * @uses Campaign::setExpectedRevenue()
     * @uses Campaign::setMessage()
     * @uses Campaign::setIsInactive()
     * @uses Campaign::setLocal()
     * @uses Campaign::setTotalRevenue()
     * @uses Campaign::setRoi()
     * @uses Campaign::setProfit()
     * @uses Campaign::setCostPerCustomer()
     * @uses Campaign::setConvCostPerCustomer()
     * @uses Campaign::setConversions()
     * @uses Campaign::setLeadsGenerated()
     * @uses Campaign::setUniqueVisitors()
     * @uses Campaign::setVertical()
     * @uses Campaign::setAudience()
     * @uses Campaign::setOffer()
     * @uses Campaign::setPromotionCode()
     * @uses Campaign::setItemList()
     * @uses Campaign::setFamily()
     * @uses Campaign::setSearchEngine()
     * @uses Campaign::setKeyword()
     * @uses Campaign::setCampaignEmailList()
     * @uses Campaign::setCampaignDirectMailList()
     * @uses Campaign::setCampaignEventList()
     * @uses Campaign::setEventResponseList()
     * @uses Campaign::setCustomFieldList()
     * @uses Campaign::setInternalId()
     * @uses Campaign::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param string $campaignId
     * @param string $title
     * @param \StructType\RecordRef $category
     * @param \StructType\RecordRef $owner
     * @param string $startDate
     * @param string $endDate
     * @param string $url
     * @param float $baseCost
     * @param float $cost
     * @param float $expectedRevenue
     * @param string $message
     * @param bool $isInactive
     * @param bool $local
     * @param float $totalRevenue
     * @param float $roi
     * @param float $profit
     * @param float $costPerCustomer
     * @param float $convCostPerCustomer
     * @param int $conversions
     * @param int $leadsGenerated
     * @param int $uniqueVisitors
     * @param \StructType\RecordRef $vertical
     * @param \StructType\RecordRef $audience
     * @param \StructType\RecordRef $offer
     * @param \StructType\RecordRef $promotionCode
     * @param \StructType\RecordRefList $itemList
     * @param \StructType\RecordRef $family
     * @param \StructType\RecordRef $searchEngine
     * @param string $keyword
     * @param \StructType\CampaignEmailList $campaignEmailList
     * @param \StructType\CampaignDirectMailList $campaignDirectMailList
     * @param \StructType\CampaignEventList $campaignEventList
     * @param \StructType\CampaignEventResponseList $eventResponseList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, $campaignId = null, $title = null, \StructType\RecordRef $category = null, \StructType\RecordRef $owner = null, $startDate = null, $endDate = null, $url = null, $baseCost = null, $cost = null, $expectedRevenue = null, $message = null, $isInactive = null, $local = null, $totalRevenue = null, $roi = null, $profit = null, $costPerCustomer = null, $convCostPerCustomer = null, $conversions = null, $leadsGenerated = null, $uniqueVisitors = null, \StructType\RecordRef $vertical = null, \StructType\RecordRef $audience = null, \StructType\RecordRef $offer = null, \StructType\RecordRef $promotionCode = null, \StructType\RecordRefList $itemList = null, \StructType\RecordRef $family = null, \StructType\RecordRef $searchEngine = null, $keyword = null, \StructType\CampaignEmailList $campaignEmailList = null, \StructType\CampaignDirectMailList $campaignDirectMailList = null, \StructType\CampaignEventList $campaignEventList = null, \StructType\CampaignEventResponseList $eventResponseList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setCampaignId($campaignId)
            ->setTitle($title)
            ->setCategory($category)
            ->setOwner($owner)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setUrl($url)
            ->setBaseCost($baseCost)
            ->setCost($cost)
            ->setExpectedRevenue($expectedRevenue)
            ->setMessage($message)
            ->setIsInactive($isInactive)
            ->setLocal($local)
            ->setTotalRevenue($totalRevenue)
            ->setRoi($roi)
            ->setProfit($profit)
            ->setCostPerCustomer($costPerCustomer)
            ->setConvCostPerCustomer($convCostPerCustomer)
            ->setConversions($conversions)
            ->setLeadsGenerated($leadsGenerated)
            ->setUniqueVisitors($uniqueVisitors)
            ->setVertical($vertical)
            ->setAudience($audience)
            ->setOffer($offer)
            ->setPromotionCode($promotionCode)
            ->setItemList($itemList)
            ->setFamily($family)
            ->setSearchEngine($searchEngine)
            ->setKeyword($keyword)
            ->setCampaignEmailList($campaignEmailList)
            ->setCampaignDirectMailList($campaignDirectMailList)
            ->setCampaignEventList($campaignEventList)
            ->setEventResponseList($eventResponseList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Campaign
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get campaignId value
     * @return string|null
     */
    public function getCampaignId()
    {
        return $this->campaignId;
    }
    /**
     * Set campaignId value
     * @param string $campaignId
     * @return \StructType\Campaign
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->campaignId = $campaignId;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Campaign
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\RecordRef|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\RecordRef $category
     * @return \StructType\Campaign
     */
    public function setCategory(\StructType\RecordRef $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\RecordRef|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\RecordRef $owner
     * @return \StructType\Campaign
     */
    public function setOwner(\StructType\RecordRef $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\Campaign
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\Campaign
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\Campaign
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get baseCost value
     * @return float|null
     */
    public function getBaseCost()
    {
        return $this->baseCost;
    }
    /**
     * Set baseCost value
     * @param float $baseCost
     * @return \StructType\Campaign
     */
    public function setBaseCost($baseCost = null)
    {
        // validation for constraint: float
        if (!is_null($baseCost) && !(is_float($baseCost) || is_numeric($baseCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseCost, true), gettype($baseCost)), __LINE__);
        }
        $this->baseCost = $baseCost;
        return $this;
    }
    /**
     * Get cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\Campaign
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get expectedRevenue value
     * @return float|null
     */
    public function getExpectedRevenue()
    {
        return $this->expectedRevenue;
    }
    /**
     * Set expectedRevenue value
     * @param float $expectedRevenue
     * @return \StructType\Campaign
     */
    public function setExpectedRevenue($expectedRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($expectedRevenue) && !(is_float($expectedRevenue) || is_numeric($expectedRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expectedRevenue, true), gettype($expectedRevenue)), __LINE__);
        }
        $this->expectedRevenue = $expectedRevenue;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\Campaign
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Campaign
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get local value
     * @return bool|null
     */
    public function getLocal()
    {
        return $this->local;
    }
    /**
     * Set local value
     * @param bool $local
     * @return \StructType\Campaign
     */
    public function setLocal($local = null)
    {
        // validation for constraint: boolean
        if (!is_null($local) && !is_bool($local)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($local, true), gettype($local)), __LINE__);
        }
        $this->local = $local;
        return $this;
    }
    /**
     * Get totalRevenue value
     * @return float|null
     */
    public function getTotalRevenue()
    {
        return $this->totalRevenue;
    }
    /**
     * Set totalRevenue value
     * @param float $totalRevenue
     * @return \StructType\Campaign
     */
    public function setTotalRevenue($totalRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($totalRevenue) && !(is_float($totalRevenue) || is_numeric($totalRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalRevenue, true), gettype($totalRevenue)), __LINE__);
        }
        $this->totalRevenue = $totalRevenue;
        return $this;
    }
    /**
     * Get roi value
     * @return float|null
     */
    public function getRoi()
    {
        return $this->roi;
    }
    /**
     * Set roi value
     * @param float $roi
     * @return \StructType\Campaign
     */
    public function setRoi($roi = null)
    {
        // validation for constraint: float
        if (!is_null($roi) && !(is_float($roi) || is_numeric($roi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($roi, true), gettype($roi)), __LINE__);
        }
        $this->roi = $roi;
        return $this;
    }
    /**
     * Get profit value
     * @return float|null
     */
    public function getProfit()
    {
        return $this->profit;
    }
    /**
     * Set profit value
     * @param float $profit
     * @return \StructType\Campaign
     */
    public function setProfit($profit = null)
    {
        // validation for constraint: float
        if (!is_null($profit) && !(is_float($profit) || is_numeric($profit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($profit, true), gettype($profit)), __LINE__);
        }
        $this->profit = $profit;
        return $this;
    }
    /**
     * Get costPerCustomer value
     * @return float|null
     */
    public function getCostPerCustomer()
    {
        return $this->costPerCustomer;
    }
    /**
     * Set costPerCustomer value
     * @param float $costPerCustomer
     * @return \StructType\Campaign
     */
    public function setCostPerCustomer($costPerCustomer = null)
    {
        // validation for constraint: float
        if (!is_null($costPerCustomer) && !(is_float($costPerCustomer) || is_numeric($costPerCustomer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costPerCustomer, true), gettype($costPerCustomer)), __LINE__);
        }
        $this->costPerCustomer = $costPerCustomer;
        return $this;
    }
    /**
     * Get convCostPerCustomer value
     * @return float|null
     */
    public function getConvCostPerCustomer()
    {
        return $this->convCostPerCustomer;
    }
    /**
     * Set convCostPerCustomer value
     * @param float $convCostPerCustomer
     * @return \StructType\Campaign
     */
    public function setConvCostPerCustomer($convCostPerCustomer = null)
    {
        // validation for constraint: float
        if (!is_null($convCostPerCustomer) && !(is_float($convCostPerCustomer) || is_numeric($convCostPerCustomer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($convCostPerCustomer, true), gettype($convCostPerCustomer)), __LINE__);
        }
        $this->convCostPerCustomer = $convCostPerCustomer;
        return $this;
    }
    /**
     * Get conversions value
     * @return int|null
     */
    public function getConversions()
    {
        return $this->conversions;
    }
    /**
     * Set conversions value
     * @param int $conversions
     * @return \StructType\Campaign
     */
    public function setConversions($conversions = null)
    {
        // validation for constraint: int
        if (!is_null($conversions) && !(is_int($conversions) || ctype_digit($conversions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($conversions, true), gettype($conversions)), __LINE__);
        }
        $this->conversions = $conversions;
        return $this;
    }
    /**
     * Get leadsGenerated value
     * @return int|null
     */
    public function getLeadsGenerated()
    {
        return $this->leadsGenerated;
    }
    /**
     * Set leadsGenerated value
     * @param int $leadsGenerated
     * @return \StructType\Campaign
     */
    public function setLeadsGenerated($leadsGenerated = null)
    {
        // validation for constraint: int
        if (!is_null($leadsGenerated) && !(is_int($leadsGenerated) || ctype_digit($leadsGenerated))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leadsGenerated, true), gettype($leadsGenerated)), __LINE__);
        }
        $this->leadsGenerated = $leadsGenerated;
        return $this;
    }
    /**
     * Get uniqueVisitors value
     * @return int|null
     */
    public function getUniqueVisitors()
    {
        return $this->uniqueVisitors;
    }
    /**
     * Set uniqueVisitors value
     * @param int $uniqueVisitors
     * @return \StructType\Campaign
     */
    public function setUniqueVisitors($uniqueVisitors = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueVisitors) && !(is_int($uniqueVisitors) || ctype_digit($uniqueVisitors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uniqueVisitors, true), gettype($uniqueVisitors)), __LINE__);
        }
        $this->uniqueVisitors = $uniqueVisitors;
        return $this;
    }
    /**
     * Get vertical value
     * @return \StructType\RecordRef|null
     */
    public function getVertical()
    {
        return $this->vertical;
    }
    /**
     * Set vertical value
     * @param \StructType\RecordRef $vertical
     * @return \StructType\Campaign
     */
    public function setVertical(\StructType\RecordRef $vertical = null)
    {
        $this->vertical = $vertical;
        return $this;
    }
    /**
     * Get audience value
     * @return \StructType\RecordRef|null
     */
    public function getAudience()
    {
        return $this->audience;
    }
    /**
     * Set audience value
     * @param \StructType\RecordRef $audience
     * @return \StructType\Campaign
     */
    public function setAudience(\StructType\RecordRef $audience = null)
    {
        $this->audience = $audience;
        return $this;
    }
    /**
     * Get offer value
     * @return \StructType\RecordRef|null
     */
    public function getOffer()
    {
        return $this->offer;
    }
    /**
     * Set offer value
     * @param \StructType\RecordRef $offer
     * @return \StructType\Campaign
     */
    public function setOffer(\StructType\RecordRef $offer = null)
    {
        $this->offer = $offer;
        return $this;
    }
    /**
     * Get promotionCode value
     * @return \StructType\RecordRef|null
     */
    public function getPromotionCode()
    {
        return $this->promotionCode;
    }
    /**
     * Set promotionCode value
     * @param \StructType\RecordRef $promotionCode
     * @return \StructType\Campaign
     */
    public function setPromotionCode(\StructType\RecordRef $promotionCode = null)
    {
        $this->promotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\RecordRefList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\RecordRefList $itemList
     * @return \StructType\Campaign
     */
    public function setItemList(\StructType\RecordRefList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get family value
     * @return \StructType\RecordRef|null
     */
    public function getFamily()
    {
        return $this->family;
    }
    /**
     * Set family value
     * @param \StructType\RecordRef $family
     * @return \StructType\Campaign
     */
    public function setFamily(\StructType\RecordRef $family = null)
    {
        $this->family = $family;
        return $this;
    }
    /**
     * Get searchEngine value
     * @return \StructType\RecordRef|null
     */
    public function getSearchEngine()
    {
        return $this->searchEngine;
    }
    /**
     * Set searchEngine value
     * @param \StructType\RecordRef $searchEngine
     * @return \StructType\Campaign
     */
    public function setSearchEngine(\StructType\RecordRef $searchEngine = null)
    {
        $this->searchEngine = $searchEngine;
        return $this;
    }
    /**
     * Get keyword value
     * @return string|null
     */
    public function getKeyword()
    {
        return $this->keyword;
    }
    /**
     * Set keyword value
     * @param string $keyword
     * @return \StructType\Campaign
     */
    public function setKeyword($keyword = null)
    {
        // validation for constraint: string
        if (!is_null($keyword) && !is_string($keyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyword, true), gettype($keyword)), __LINE__);
        }
        $this->keyword = $keyword;
        return $this;
    }
    /**
     * Get campaignEmailList value
     * @return \StructType\CampaignEmailList|null
     */
    public function getCampaignEmailList()
    {
        return $this->campaignEmailList;
    }
    /**
     * Set campaignEmailList value
     * @param \StructType\CampaignEmailList $campaignEmailList
     * @return \StructType\Campaign
     */
    public function setCampaignEmailList(\StructType\CampaignEmailList $campaignEmailList = null)
    {
        $this->campaignEmailList = $campaignEmailList;
        return $this;
    }
    /**
     * Get campaignDirectMailList value
     * @return \StructType\CampaignDirectMailList|null
     */
    public function getCampaignDirectMailList()
    {
        return $this->campaignDirectMailList;
    }
    /**
     * Set campaignDirectMailList value
     * @param \StructType\CampaignDirectMailList $campaignDirectMailList
     * @return \StructType\Campaign
     */
    public function setCampaignDirectMailList(\StructType\CampaignDirectMailList $campaignDirectMailList = null)
    {
        $this->campaignDirectMailList = $campaignDirectMailList;
        return $this;
    }
    /**
     * Get campaignEventList value
     * @return \StructType\CampaignEventList|null
     */
    public function getCampaignEventList()
    {
        return $this->campaignEventList;
    }
    /**
     * Set campaignEventList value
     * @param \StructType\CampaignEventList $campaignEventList
     * @return \StructType\Campaign
     */
    public function setCampaignEventList(\StructType\CampaignEventList $campaignEventList = null)
    {
        $this->campaignEventList = $campaignEventList;
        return $this;
    }
    /**
     * Get eventResponseList value
     * @return \StructType\CampaignEventResponseList|null
     */
    public function getEventResponseList()
    {
        return $this->eventResponseList;
    }
    /**
     * Set eventResponseList value
     * @param \StructType\CampaignEventResponseList $eventResponseList
     * @return \StructType\Campaign
     */
    public function setEventResponseList(\StructType\CampaignEventResponseList $eventResponseList = null)
    {
        $this->eventResponseList = $eventResponseList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Campaign
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Campaign
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Campaign
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
