<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalendarEventResourceList StructType
 * @subpackage Structs
 */
class CalendarEventResourceList extends AbstractStructBase
{
    /**
     * The resource
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CalendarEventResource[]
     */
    public $resource;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CalendarEventResourceList
     * @uses CalendarEventResourceList::setResource()
     * @uses CalendarEventResourceList::setReplaceAll()
     * @param \StructType\CalendarEventResource[] $resource
     * @param bool $replaceAll
     */
    public function __construct(array $resource = array(), $replaceAll = true)
    {
        $this
            ->setResource($resource)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get resource value
     * @return \StructType\CalendarEventResource[]|null
     */
    public function getResource()
    {
        return $this->resource;
    }
    /**
     * This method is responsible for validating the values passed to the setResource method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResourceForArrayConstraintsFromSetResource(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calendarEventResourceListResourceItem) {
            // validation for constraint: itemType
            if (!$calendarEventResourceListResourceItem instanceof \StructType\CalendarEventResource) {
                $invalidValues[] = is_object($calendarEventResourceListResourceItem) ? get_class($calendarEventResourceListResourceItem) : sprintf('%s(%s)', gettype($calendarEventResourceListResourceItem), var_export($calendarEventResourceListResourceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The resource property can only contain items of type \StructType\CalendarEventResource, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set resource value
     * @throws \InvalidArgumentException
     * @param \StructType\CalendarEventResource[] $resource
     * @return \StructType\CalendarEventResourceList
     */
    public function setResource(array $resource = array())
    {
        // validation for constraint: array
        if ('' !== ($resourceArrayErrorMessage = self::validateResourceForArrayConstraintsFromSetResource($resource))) {
            throw new \InvalidArgumentException($resourceArrayErrorMessage, __LINE__);
        }
        $this->resource = $resource;
        return $this;
    }
    /**
     * Add item to resource value
     * @throws \InvalidArgumentException
     * @param \StructType\CalendarEventResource $item
     * @return \StructType\CalendarEventResourceList
     */
    public function addToResource(\StructType\CalendarEventResource $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CalendarEventResource) {
            throw new \InvalidArgumentException(sprintf('The resource property can only contain items of type \StructType\CalendarEventResource, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->resource[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CalendarEventResourceList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
