<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalendarEventAttendeeList StructType
 * @subpackage Structs
 */
class CalendarEventAttendeeList extends AbstractStructBase
{
    /**
     * The attendee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CalendarEventAttendee[]
     */
    public $attendee;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CalendarEventAttendeeList
     * @uses CalendarEventAttendeeList::setAttendee()
     * @uses CalendarEventAttendeeList::setReplaceAll()
     * @param \StructType\CalendarEventAttendee[] $attendee
     * @param bool $replaceAll
     */
    public function __construct(array $attendee = array(), $replaceAll = true)
    {
        $this
            ->setAttendee($attendee)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get attendee value
     * @return \StructType\CalendarEventAttendee[]|null
     */
    public function getAttendee()
    {
        return $this->attendee;
    }
    /**
     * This method is responsible for validating the values passed to the setAttendee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttendee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttendeeForArrayConstraintsFromSetAttendee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calendarEventAttendeeListAttendeeItem) {
            // validation for constraint: itemType
            if (!$calendarEventAttendeeListAttendeeItem instanceof \StructType\CalendarEventAttendee) {
                $invalidValues[] = is_object($calendarEventAttendeeListAttendeeItem) ? get_class($calendarEventAttendeeListAttendeeItem) : sprintf('%s(%s)', gettype($calendarEventAttendeeListAttendeeItem), var_export($calendarEventAttendeeListAttendeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attendee property can only contain items of type \StructType\CalendarEventAttendee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attendee value
     * @throws \InvalidArgumentException
     * @param \StructType\CalendarEventAttendee[] $attendee
     * @return \StructType\CalendarEventAttendeeList
     */
    public function setAttendee(array $attendee = array())
    {
        // validation for constraint: array
        if ('' !== ($attendeeArrayErrorMessage = self::validateAttendeeForArrayConstraintsFromSetAttendee($attendee))) {
            throw new \InvalidArgumentException($attendeeArrayErrorMessage, __LINE__);
        }
        $this->attendee = $attendee;
        return $this;
    }
    /**
     * Add item to attendee value
     * @throws \InvalidArgumentException
     * @param \StructType\CalendarEventAttendee $item
     * @return \StructType\CalendarEventAttendeeList
     */
    public function addToAttendee(\StructType\CalendarEventAttendee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CalendarEventAttendee) {
            throw new \InvalidArgumentException(sprintf('The attendee property can only contain items of type \StructType\CalendarEventAttendee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attendee[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CalendarEventAttendeeList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
