<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BudgetSearchRowBasic StructType
 * @subpackage Structs
 */
class BudgetSearchRowBasic extends SearchRowBasic
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $account;
    /**
     * The accountingBook
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $accountingBook;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $amount;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $category;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $class;
    /**
     * The classnohierarchy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $classnohierarchy;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $currency;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $customer;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $department;
    /**
     * The departmentnohierarchy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $departmentnohierarchy;
    /**
     * The global
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $global;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $item;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $location;
    /**
     * The locationnohierarchy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $locationnohierarchy;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $subsidiary;
    /**
     * The subsidiarynohierarchy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $subsidiarynohierarchy;
    /**
     * The year
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $year;
    /**
     * The year2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $year2;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for BudgetSearchRowBasic
     * @uses BudgetSearchRowBasic::setAccount()
     * @uses BudgetSearchRowBasic::setAccountingBook()
     * @uses BudgetSearchRowBasic::setAmount()
     * @uses BudgetSearchRowBasic::setCategory()
     * @uses BudgetSearchRowBasic::setClass()
     * @uses BudgetSearchRowBasic::setClassnohierarchy()
     * @uses BudgetSearchRowBasic::setCurrency()
     * @uses BudgetSearchRowBasic::setCustomer()
     * @uses BudgetSearchRowBasic::setDepartment()
     * @uses BudgetSearchRowBasic::setDepartmentnohierarchy()
     * @uses BudgetSearchRowBasic::setGlobal()
     * @uses BudgetSearchRowBasic::setInternalId()
     * @uses BudgetSearchRowBasic::setItem()
     * @uses BudgetSearchRowBasic::setLocation()
     * @uses BudgetSearchRowBasic::setLocationnohierarchy()
     * @uses BudgetSearchRowBasic::setSubsidiary()
     * @uses BudgetSearchRowBasic::setSubsidiarynohierarchy()
     * @uses BudgetSearchRowBasic::setYear()
     * @uses BudgetSearchRowBasic::setYear2()
     * @uses BudgetSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnStringField[] $account
     * @param \StructType\SearchColumnStringField[] $accountingBook
     * @param \StructType\SearchColumnDoubleField[] $amount
     * @param \StructType\SearchColumnStringField[] $category
     * @param \StructType\SearchColumnStringField[] $class
     * @param \StructType\SearchColumnStringField[] $classnohierarchy
     * @param \StructType\SearchColumnStringField[] $currency
     * @param \StructType\SearchColumnStringField[] $customer
     * @param \StructType\SearchColumnStringField[] $department
     * @param \StructType\SearchColumnStringField[] $departmentnohierarchy
     * @param \StructType\SearchColumnBooleanField[] $global
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnStringField[] $item
     * @param \StructType\SearchColumnStringField[] $location
     * @param \StructType\SearchColumnStringField[] $locationnohierarchy
     * @param \StructType\SearchColumnStringField[] $subsidiary
     * @param \StructType\SearchColumnStringField[] $subsidiarynohierarchy
     * @param \StructType\SearchColumnStringField[] $year
     * @param \StructType\SearchColumnStringField[] $year2
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $account = array(), array $accountingBook = array(), array $amount = array(), array $category = array(), array $class = array(), array $classnohierarchy = array(), array $currency = array(), array $customer = array(), array $department = array(), array $departmentnohierarchy = array(), array $global = array(), array $internalId = array(), array $item = array(), array $location = array(), array $locationnohierarchy = array(), array $subsidiary = array(), array $subsidiarynohierarchy = array(), array $year = array(), array $year2 = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setAccount($account)
            ->setAccountingBook($accountingBook)
            ->setAmount($amount)
            ->setCategory($category)
            ->setClass($class)
            ->setClassnohierarchy($classnohierarchy)
            ->setCurrency($currency)
            ->setCustomer($customer)
            ->setDepartment($department)
            ->setDepartmentnohierarchy($departmentnohierarchy)
            ->setGlobal($global)
            ->setInternalId($internalId)
            ->setItem($item)
            ->setLocation($location)
            ->setLocationnohierarchy($locationnohierarchy)
            ->setSubsidiary($subsidiary)
            ->setSubsidiarynohierarchy($subsidiarynohierarchy)
            ->setYear($year)
            ->setYear2($year2)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get account value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * This method is responsible for validating the values passed to the setAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountForArrayConstraintsFromSetAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicAccountItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicAccountItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicAccountItem) ? get_class($budgetSearchRowBasicAccountItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicAccountItem), var_export($budgetSearchRowBasicAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The account property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $account
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setAccount(array $account = array())
    {
        // validation for constraint: array
        if ('' !== ($accountArrayErrorMessage = self::validateAccountForArrayConstraintsFromSetAccount($account))) {
            throw new \InvalidArgumentException($accountArrayErrorMessage, __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Add item to account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToAccount(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The account property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->account[] = $item;
        return $this;
    }
    /**
     * Get accountingBook value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAccountingBook()
    {
        return $this->accountingBook;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountingBook method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountingBook method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountingBookForArrayConstraintsFromSetAccountingBook(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicAccountingBookItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicAccountingBookItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicAccountingBookItem) ? get_class($budgetSearchRowBasicAccountingBookItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicAccountingBookItem), var_export($budgetSearchRowBasicAccountingBookItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The accountingBook property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set accountingBook value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $accountingBook
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setAccountingBook(array $accountingBook = array())
    {
        // validation for constraint: array
        if ('' !== ($accountingBookArrayErrorMessage = self::validateAccountingBookForArrayConstraintsFromSetAccountingBook($accountingBook))) {
            throw new \InvalidArgumentException($accountingBookArrayErrorMessage, __LINE__);
        }
        $this->accountingBook = $accountingBook;
        return $this;
    }
    /**
     * Add item to accountingBook value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToAccountingBook(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The accountingBook property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->accountingBook[] = $item;
        return $this;
    }
    /**
     * Get amount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * This method is responsible for validating the values passed to the setAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmountForArrayConstraintsFromSetAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicAmountItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($budgetSearchRowBasicAmountItem) ? get_class($budgetSearchRowBasicAmountItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicAmountItem), var_export($budgetSearchRowBasicAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The amount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set amount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $amount
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setAmount(array $amount = array())
    {
        // validation for constraint: array
        if ('' !== ($amountArrayErrorMessage = self::validateAmountForArrayConstraintsFromSetAmount($amount))) {
            throw new \InvalidArgumentException($amountArrayErrorMessage, __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Add item to amount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The amount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->amount[] = $item;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * This method is responsible for validating the values passed to the setCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryForArrayConstraintsFromSetCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicCategoryItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicCategoryItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicCategoryItem) ? get_class($budgetSearchRowBasicCategoryItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicCategoryItem), var_export($budgetSearchRowBasicCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The category property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set category value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $category
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setCategory(array $category = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryArrayErrorMessage = self::validateCategoryForArrayConstraintsFromSetCategory($category))) {
            throw new \InvalidArgumentException($categoryArrayErrorMessage, __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Add item to category value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToCategory(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The category property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->category[] = $item;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * This method is responsible for validating the values passed to the setClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClassForArrayConstraintsFromSetClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicClassItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicClassItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicClassItem) ? get_class($budgetSearchRowBasicClassItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicClassItem), var_export($budgetSearchRowBasicClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The class property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set class value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $class
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setClass(array $class = array())
    {
        // validation for constraint: array
        if ('' !== ($classArrayErrorMessage = self::validateClassForArrayConstraintsFromSetClass($class))) {
            throw new \InvalidArgumentException($classArrayErrorMessage, __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Add item to class value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToClass(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The class property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->class[] = $item;
        return $this;
    }
    /**
     * Get classnohierarchy value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getClassnohierarchy()
    {
        return $this->classnohierarchy;
    }
    /**
     * This method is responsible for validating the values passed to the setClassnohierarchy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClassnohierarchy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClassnohierarchyForArrayConstraintsFromSetClassnohierarchy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicClassnohierarchyItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicClassnohierarchyItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicClassnohierarchyItem) ? get_class($budgetSearchRowBasicClassnohierarchyItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicClassnohierarchyItem), var_export($budgetSearchRowBasicClassnohierarchyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The classnohierarchy property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set classnohierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $classnohierarchy
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setClassnohierarchy(array $classnohierarchy = array())
    {
        // validation for constraint: array
        if ('' !== ($classnohierarchyArrayErrorMessage = self::validateClassnohierarchyForArrayConstraintsFromSetClassnohierarchy($classnohierarchy))) {
            throw new \InvalidArgumentException($classnohierarchyArrayErrorMessage, __LINE__);
        }
        $this->classnohierarchy = $classnohierarchy;
        return $this;
    }
    /**
     * Add item to classnohierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToClassnohierarchy(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The classnohierarchy property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->classnohierarchy[] = $item;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyForArrayConstraintsFromSetCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicCurrencyItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicCurrencyItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicCurrencyItem) ? get_class($budgetSearchRowBasicCurrencyItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicCurrencyItem), var_export($budgetSearchRowBasicCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The currency property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $currency
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setCurrency(array $currency = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyArrayErrorMessage = self::validateCurrencyForArrayConstraintsFromSetCurrency($currency))) {
            throw new \InvalidArgumentException($currencyArrayErrorMessage, __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Add item to currency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToCurrency(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The currency property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->currency[] = $item;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerForArrayConstraintsFromSetCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicCustomerItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicCustomerItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicCustomerItem) ? get_class($budgetSearchRowBasicCustomerItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicCustomerItem), var_export($budgetSearchRowBasicCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customer property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customer value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $customer
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setCustomer(array $customer = array())
    {
        // validation for constraint: array
        if ('' !== ($customerArrayErrorMessage = self::validateCustomerForArrayConstraintsFromSetCustomer($customer))) {
            throw new \InvalidArgumentException($customerArrayErrorMessage, __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Add item to customer value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToCustomer(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The customer property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customer[] = $item;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * This method is responsible for validating the values passed to the setDepartment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepartment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepartmentForArrayConstraintsFromSetDepartment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicDepartmentItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicDepartmentItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicDepartmentItem) ? get_class($budgetSearchRowBasicDepartmentItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicDepartmentItem), var_export($budgetSearchRowBasicDepartmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The department property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set department value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $department
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setDepartment(array $department = array())
    {
        // validation for constraint: array
        if ('' !== ($departmentArrayErrorMessage = self::validateDepartmentForArrayConstraintsFromSetDepartment($department))) {
            throw new \InvalidArgumentException($departmentArrayErrorMessage, __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Add item to department value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToDepartment(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The department property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->department[] = $item;
        return $this;
    }
    /**
     * Get departmentnohierarchy value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getDepartmentnohierarchy()
    {
        return $this->departmentnohierarchy;
    }
    /**
     * This method is responsible for validating the values passed to the setDepartmentnohierarchy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepartmentnohierarchy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepartmentnohierarchyForArrayConstraintsFromSetDepartmentnohierarchy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicDepartmentnohierarchyItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicDepartmentnohierarchyItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicDepartmentnohierarchyItem) ? get_class($budgetSearchRowBasicDepartmentnohierarchyItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicDepartmentnohierarchyItem), var_export($budgetSearchRowBasicDepartmentnohierarchyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The departmentnohierarchy property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set departmentnohierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $departmentnohierarchy
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setDepartmentnohierarchy(array $departmentnohierarchy = array())
    {
        // validation for constraint: array
        if ('' !== ($departmentnohierarchyArrayErrorMessage = self::validateDepartmentnohierarchyForArrayConstraintsFromSetDepartmentnohierarchy($departmentnohierarchy))) {
            throw new \InvalidArgumentException($departmentnohierarchyArrayErrorMessage, __LINE__);
        }
        $this->departmentnohierarchy = $departmentnohierarchy;
        return $this;
    }
    /**
     * Add item to departmentnohierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToDepartmentnohierarchy(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The departmentnohierarchy property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->departmentnohierarchy[] = $item;
        return $this;
    }
    /**
     * Get global value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getGlobal()
    {
        return $this->global;
    }
    /**
     * This method is responsible for validating the values passed to the setGlobal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGlobal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGlobalForArrayConstraintsFromSetGlobal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicGlobalItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicGlobalItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($budgetSearchRowBasicGlobalItem) ? get_class($budgetSearchRowBasicGlobalItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicGlobalItem), var_export($budgetSearchRowBasicGlobalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The global property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set global value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $global
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setGlobal(array $global = array())
    {
        // validation for constraint: array
        if ('' !== ($globalArrayErrorMessage = self::validateGlobalForArrayConstraintsFromSetGlobal($global))) {
            throw new \InvalidArgumentException($globalArrayErrorMessage, __LINE__);
        }
        $this->global = $global;
        return $this;
    }
    /**
     * Add item to global value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToGlobal(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The global property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->global[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($budgetSearchRowBasicInternalIdItem) ? get_class($budgetSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicInternalIdItem), var_export($budgetSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicItemItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicItemItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicItemItem) ? get_class($budgetSearchRowBasicItemItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicItemItem), var_export($budgetSearchRowBasicItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The item property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToItem(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicLocationItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicLocationItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicLocationItem) ? get_class($budgetSearchRowBasicLocationItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicLocationItem), var_export($budgetSearchRowBasicLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The location property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $location
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Add item to location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToLocation(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The location property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->location[] = $item;
        return $this;
    }
    /**
     * Get locationnohierarchy value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getLocationnohierarchy()
    {
        return $this->locationnohierarchy;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationnohierarchy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationnohierarchy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationnohierarchyForArrayConstraintsFromSetLocationnohierarchy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicLocationnohierarchyItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicLocationnohierarchyItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicLocationnohierarchyItem) ? get_class($budgetSearchRowBasicLocationnohierarchyItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicLocationnohierarchyItem), var_export($budgetSearchRowBasicLocationnohierarchyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The locationnohierarchy property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set locationnohierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $locationnohierarchy
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setLocationnohierarchy(array $locationnohierarchy = array())
    {
        // validation for constraint: array
        if ('' !== ($locationnohierarchyArrayErrorMessage = self::validateLocationnohierarchyForArrayConstraintsFromSetLocationnohierarchy($locationnohierarchy))) {
            throw new \InvalidArgumentException($locationnohierarchyArrayErrorMessage, __LINE__);
        }
        $this->locationnohierarchy = $locationnohierarchy;
        return $this;
    }
    /**
     * Add item to locationnohierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToLocationnohierarchy(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The locationnohierarchy property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->locationnohierarchy[] = $item;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiaryForArrayConstraintsFromSetSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicSubsidiaryItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicSubsidiaryItem) ? get_class($budgetSearchRowBasicSubsidiaryItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicSubsidiaryItem), var_export($budgetSearchRowBasicSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $subsidiary
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setSubsidiary(array $subsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiaryArrayErrorMessage = self::validateSubsidiaryForArrayConstraintsFromSetSubsidiary($subsidiary))) {
            throw new \InvalidArgumentException($subsidiaryArrayErrorMessage, __LINE__);
        }
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Add item to subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToSubsidiary(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiary[] = $item;
        return $this;
    }
    /**
     * Get subsidiarynohierarchy value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getSubsidiarynohierarchy()
    {
        return $this->subsidiarynohierarchy;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiarynohierarchy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiarynohierarchy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiarynohierarchyForArrayConstraintsFromSetSubsidiarynohierarchy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicSubsidiarynohierarchyItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicSubsidiarynohierarchyItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicSubsidiarynohierarchyItem) ? get_class($budgetSearchRowBasicSubsidiarynohierarchyItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicSubsidiarynohierarchyItem), var_export($budgetSearchRowBasicSubsidiarynohierarchyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiarynohierarchy property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiarynohierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $subsidiarynohierarchy
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setSubsidiarynohierarchy(array $subsidiarynohierarchy = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiarynohierarchyArrayErrorMessage = self::validateSubsidiarynohierarchyForArrayConstraintsFromSetSubsidiarynohierarchy($subsidiarynohierarchy))) {
            throw new \InvalidArgumentException($subsidiarynohierarchyArrayErrorMessage, __LINE__);
        }
        $this->subsidiarynohierarchy = $subsidiarynohierarchy;
        return $this;
    }
    /**
     * Add item to subsidiarynohierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToSubsidiarynohierarchy(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The subsidiarynohierarchy property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiarynohierarchy[] = $item;
        return $this;
    }
    /**
     * Get year value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * This method is responsible for validating the values passed to the setYear method
     * This method is willingly generated in order to preserve the one-line inline validation within the setYear method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateYearForArrayConstraintsFromSetYear(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicYearItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicYearItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicYearItem) ? get_class($budgetSearchRowBasicYearItem) : sprintf('%s(%s)', gettype($budgetSearchRowBasicYearItem), var_export($budgetSearchRowBasicYearItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The year property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set year value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $year
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setYear(array $year = array())
    {
        // validation for constraint: array
        if ('' !== ($yearArrayErrorMessage = self::validateYearForArrayConstraintsFromSetYear($year))) {
            throw new \InvalidArgumentException($yearArrayErrorMessage, __LINE__);
        }
        $this->year = $year;
        return $this;
    }
    /**
     * Add item to year value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToYear(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The year property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->year[] = $item;
        return $this;
    }
    /**
     * Get year2 value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getYear2()
    {
        return $this->year2;
    }
    /**
     * This method is responsible for validating the values passed to the setYear2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setYear2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateYear2ForArrayConstraintsFromSetYear2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowBasicYear2Item) {
            // validation for constraint: itemType
            if (!$budgetSearchRowBasicYear2Item instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($budgetSearchRowBasicYear2Item) ? get_class($budgetSearchRowBasicYear2Item) : sprintf('%s(%s)', gettype($budgetSearchRowBasicYear2Item), var_export($budgetSearchRowBasicYear2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The year2 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set year2 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $year2
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setYear2(array $year2 = array())
    {
        // validation for constraint: array
        if ('' !== ($year2ArrayErrorMessage = self::validateYear2ForArrayConstraintsFromSetYear2($year2))) {
            throw new \InvalidArgumentException($year2ArrayErrorMessage, __LINE__);
        }
        $this->year2 = $year2;
        return $this;
    }
    /**
     * Add item to year2 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BudgetSearchRowBasic
     */
    public function addToYear2(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The year2 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->year2[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\BudgetSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
