<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BomSearch StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:BomSearch
 * @subpackage Structs
 */
class BomSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BomSearchBasic
     */
    public $basic;
    /**
     * The assemblyItemJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AssemblyItemBomSearchBasic
     */
    public $assemblyItemJoin;
    /**
     * The revisionJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BomRevisionSearchBasic
     */
    public $revisionJoin;
    /**
     * The transactionJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $transactionJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for BomSearch
     * @uses BomSearch::setBasic()
     * @uses BomSearch::setAssemblyItemJoin()
     * @uses BomSearch::setRevisionJoin()
     * @uses BomSearch::setTransactionJoin()
     * @uses BomSearch::setCustomSearchJoin()
     * @param \StructType\BomSearchBasic $basic
     * @param \StructType\AssemblyItemBomSearchBasic $assemblyItemJoin
     * @param \StructType\BomRevisionSearchBasic $revisionJoin
     * @param \StructType\TransactionSearchBasic $transactionJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\BomSearchBasic $basic = null, \StructType\AssemblyItemBomSearchBasic $assemblyItemJoin = null, \StructType\BomRevisionSearchBasic $revisionJoin = null, \StructType\TransactionSearchBasic $transactionJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setAssemblyItemJoin($assemblyItemJoin)
            ->setRevisionJoin($revisionJoin)
            ->setTransactionJoin($transactionJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\BomSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\BomSearchBasic $basic
     * @return \StructType\BomSearch
     */
    public function setBasic(\StructType\BomSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get assemblyItemJoin value
     * @return \StructType\AssemblyItemBomSearchBasic|null
     */
    public function getAssemblyItemJoin()
    {
        return $this->assemblyItemJoin;
    }
    /**
     * Set assemblyItemJoin value
     * @param \StructType\AssemblyItemBomSearchBasic $assemblyItemJoin
     * @return \StructType\BomSearch
     */
    public function setAssemblyItemJoin(\StructType\AssemblyItemBomSearchBasic $assemblyItemJoin = null)
    {
        $this->assemblyItemJoin = $assemblyItemJoin;
        return $this;
    }
    /**
     * Get revisionJoin value
     * @return \StructType\BomRevisionSearchBasic|null
     */
    public function getRevisionJoin()
    {
        return $this->revisionJoin;
    }
    /**
     * Set revisionJoin value
     * @param \StructType\BomRevisionSearchBasic $revisionJoin
     * @return \StructType\BomSearch
     */
    public function setRevisionJoin(\StructType\BomRevisionSearchBasic $revisionJoin = null)
    {
        $this->revisionJoin = $revisionJoin;
        return $this;
    }
    /**
     * Get transactionJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getTransactionJoin()
    {
        return $this->transactionJoin;
    }
    /**
     * Set transactionJoin value
     * @param \StructType\TransactionSearchBasic $transactionJoin
     * @return \StructType\BomSearch
     */
    public function setTransactionJoin(\StructType\TransactionSearchBasic $transactionJoin = null)
    {
        $this->transactionJoin = $transactionJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bomSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$bomSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($bomSearchCustomSearchJoinItem) ? get_class($bomSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($bomSearchCustomSearchJoinItem), var_export($bomSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\BomSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\BomSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
