<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BomRevisionComponent StructType
 * @subpackage Structs
 */
class BomRevisionComponent extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The componentYield
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $componentYield;
    /**
     * The bomQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $bomQuantity;
    /**
     * The itemSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemSource;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $internalId;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for BomRevisionComponent
     * @uses BomRevisionComponent::setItem()
     * @uses BomRevisionComponent::setDescription()
     * @uses BomRevisionComponent::setComponentYield()
     * @uses BomRevisionComponent::setBomQuantity()
     * @uses BomRevisionComponent::setItemSource()
     * @uses BomRevisionComponent::setQuantity()
     * @uses BomRevisionComponent::setUnits()
     * @uses BomRevisionComponent::setInternalId()
     * @uses BomRevisionComponent::setCustomFieldList()
     * @param \StructType\RecordRef $item
     * @param string $description
     * @param float $componentYield
     * @param float $bomQuantity
     * @param string $itemSource
     * @param float $quantity
     * @param \StructType\RecordRef $units
     * @param string $internalId
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $item = null, $description = null, $componentYield = null, $bomQuantity = null, $itemSource = null, $quantity = null, \StructType\RecordRef $units = null, $internalId = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setItem($item)
            ->setDescription($description)
            ->setComponentYield($componentYield)
            ->setBomQuantity($bomQuantity)
            ->setItemSource($itemSource)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setInternalId($internalId)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\BomRevisionComponent
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\BomRevisionComponent
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get componentYield value
     * @return float|null
     */
    public function getComponentYield()
    {
        return $this->componentYield;
    }
    /**
     * Set componentYield value
     * @param float $componentYield
     * @return \StructType\BomRevisionComponent
     */
    public function setComponentYield($componentYield = null)
    {
        // validation for constraint: float
        if (!is_null($componentYield) && !(is_float($componentYield) || is_numeric($componentYield))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($componentYield, true), gettype($componentYield)), __LINE__);
        }
        $this->componentYield = $componentYield;
        return $this;
    }
    /**
     * Get bomQuantity value
     * @return float|null
     */
    public function getBomQuantity()
    {
        return $this->bomQuantity;
    }
    /**
     * Set bomQuantity value
     * @param float $bomQuantity
     * @return \StructType\BomRevisionComponent
     */
    public function setBomQuantity($bomQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($bomQuantity) && !(is_float($bomQuantity) || is_numeric($bomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bomQuantity, true), gettype($bomQuantity)), __LINE__);
        }
        $this->bomQuantity = $bomQuantity;
        return $this;
    }
    /**
     * Get itemSource value
     * @return string|null
     */
    public function getItemSource()
    {
        return $this->itemSource;
    }
    /**
     * Set itemSource value
     * @uses \EnumType\ItemSource::valueIsValid()
     * @uses \EnumType\ItemSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemSource
     * @return \StructType\BomRevisionComponent
     */
    public function setItemSource($itemSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemSource::valueIsValid($itemSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemSource', is_array($itemSource) ? implode(', ', $itemSource) : var_export($itemSource, true), implode(', ', \EnumType\ItemSource::getValidValues())), __LINE__);
        }
        $this->itemSource = $itemSource;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\BomRevisionComponent
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\BomRevisionComponent
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\BomRevisionComponent
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\BomRevisionComponent
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
