<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bom StructType
 * @subpackage Structs
 */
class Bom extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The usedOnAssembly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $usedOnAssembly;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The useComponentYield
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $useComponentYield;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The legacyBomForAssembly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $legacyBomForAssembly;
    /**
     * The availableForAllAssemblies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableForAllAssemblies;
    /**
     * The restrictToAssembliesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $restrictToAssembliesList;
    /**
     * The availableForAllLocations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableForAllLocations;
    /**
     * The restrictToLocationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $restrictToLocationsList;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Bom
     * @uses Bom::setCustomForm()
     * @uses Bom::setName()
     * @uses Bom::setUsedOnAssembly()
     * @uses Bom::setCreatedDate()
     * @uses Bom::setIsInactive()
     * @uses Bom::setUseComponentYield()
     * @uses Bom::setMemo()
     * @uses Bom::setLegacyBomForAssembly()
     * @uses Bom::setAvailableForAllAssemblies()
     * @uses Bom::setRestrictToAssembliesList()
     * @uses Bom::setAvailableForAllLocations()
     * @uses Bom::setRestrictToLocationsList()
     * @uses Bom::setSubsidiaryList()
     * @uses Bom::setIncludeChildren()
     * @uses Bom::setCustomFieldList()
     * @uses Bom::setInternalId()
     * @uses Bom::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param string $name
     * @param bool $usedOnAssembly
     * @param string $createdDate
     * @param bool $isInactive
     * @param bool $useComponentYield
     * @param string $memo
     * @param \StructType\RecordRef $legacyBomForAssembly
     * @param bool $availableForAllAssemblies
     * @param \StructType\RecordRefList $restrictToAssembliesList
     * @param bool $availableForAllLocations
     * @param \StructType\RecordRefList $restrictToLocationsList
     * @param \StructType\RecordRefList $subsidiaryList
     * @param bool $includeChildren
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, $name = null, $usedOnAssembly = null, $createdDate = null, $isInactive = null, $useComponentYield = null, $memo = null, \StructType\RecordRef $legacyBomForAssembly = null, $availableForAllAssemblies = null, \StructType\RecordRefList $restrictToAssembliesList = null, $availableForAllLocations = null, \StructType\RecordRefList $restrictToLocationsList = null, \StructType\RecordRefList $subsidiaryList = null, $includeChildren = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setName($name)
            ->setUsedOnAssembly($usedOnAssembly)
            ->setCreatedDate($createdDate)
            ->setIsInactive($isInactive)
            ->setUseComponentYield($useComponentYield)
            ->setMemo($memo)
            ->setLegacyBomForAssembly($legacyBomForAssembly)
            ->setAvailableForAllAssemblies($availableForAllAssemblies)
            ->setRestrictToAssembliesList($restrictToAssembliesList)
            ->setAvailableForAllLocations($availableForAllLocations)
            ->setRestrictToLocationsList($restrictToLocationsList)
            ->setSubsidiaryList($subsidiaryList)
            ->setIncludeChildren($includeChildren)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Bom
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Bom
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get usedOnAssembly value
     * @return bool|null
     */
    public function getUsedOnAssembly()
    {
        return $this->usedOnAssembly;
    }
    /**
     * Set usedOnAssembly value
     * @param bool $usedOnAssembly
     * @return \StructType\Bom
     */
    public function setUsedOnAssembly($usedOnAssembly = null)
    {
        // validation for constraint: boolean
        if (!is_null($usedOnAssembly) && !is_bool($usedOnAssembly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usedOnAssembly, true), gettype($usedOnAssembly)), __LINE__);
        }
        $this->usedOnAssembly = $usedOnAssembly;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\Bom
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Bom
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get useComponentYield value
     * @return bool|null
     */
    public function getUseComponentYield()
    {
        return $this->useComponentYield;
    }
    /**
     * Set useComponentYield value
     * @param bool $useComponentYield
     * @return \StructType\Bom
     */
    public function setUseComponentYield($useComponentYield = null)
    {
        // validation for constraint: boolean
        if (!is_null($useComponentYield) && !is_bool($useComponentYield)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useComponentYield, true), gettype($useComponentYield)), __LINE__);
        }
        $this->useComponentYield = $useComponentYield;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\Bom
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get legacyBomForAssembly value
     * @return \StructType\RecordRef|null
     */
    public function getLegacyBomForAssembly()
    {
        return $this->legacyBomForAssembly;
    }
    /**
     * Set legacyBomForAssembly value
     * @param \StructType\RecordRef $legacyBomForAssembly
     * @return \StructType\Bom
     */
    public function setLegacyBomForAssembly(\StructType\RecordRef $legacyBomForAssembly = null)
    {
        $this->legacyBomForAssembly = $legacyBomForAssembly;
        return $this;
    }
    /**
     * Get availableForAllAssemblies value
     * @return bool|null
     */
    public function getAvailableForAllAssemblies()
    {
        return $this->availableForAllAssemblies;
    }
    /**
     * Set availableForAllAssemblies value
     * @param bool $availableForAllAssemblies
     * @return \StructType\Bom
     */
    public function setAvailableForAllAssemblies($availableForAllAssemblies = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForAllAssemblies) && !is_bool($availableForAllAssemblies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForAllAssemblies, true), gettype($availableForAllAssemblies)), __LINE__);
        }
        $this->availableForAllAssemblies = $availableForAllAssemblies;
        return $this;
    }
    /**
     * Get restrictToAssembliesList value
     * @return \StructType\RecordRefList|null
     */
    public function getRestrictToAssembliesList()
    {
        return $this->restrictToAssembliesList;
    }
    /**
     * Set restrictToAssembliesList value
     * @param \StructType\RecordRefList $restrictToAssembliesList
     * @return \StructType\Bom
     */
    public function setRestrictToAssembliesList(\StructType\RecordRefList $restrictToAssembliesList = null)
    {
        $this->restrictToAssembliesList = $restrictToAssembliesList;
        return $this;
    }
    /**
     * Get availableForAllLocations value
     * @return bool|null
     */
    public function getAvailableForAllLocations()
    {
        return $this->availableForAllLocations;
    }
    /**
     * Set availableForAllLocations value
     * @param bool $availableForAllLocations
     * @return \StructType\Bom
     */
    public function setAvailableForAllLocations($availableForAllLocations = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForAllLocations) && !is_bool($availableForAllLocations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForAllLocations, true), gettype($availableForAllLocations)), __LINE__);
        }
        $this->availableForAllLocations = $availableForAllLocations;
        return $this;
    }
    /**
     * Get restrictToLocationsList value
     * @return \StructType\RecordRefList|null
     */
    public function getRestrictToLocationsList()
    {
        return $this->restrictToLocationsList;
    }
    /**
     * Set restrictToLocationsList value
     * @param \StructType\RecordRefList $restrictToLocationsList
     * @return \StructType\Bom
     */
    public function setRestrictToLocationsList(\StructType\RecordRefList $restrictToLocationsList = null)
    {
        $this->restrictToLocationsList = $restrictToLocationsList;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\Bom
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\Bom
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Bom
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Bom
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Bom
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
