<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BinWorksheetItem StructType
 * @subpackage Structs
 */
class BinWorksheetItem extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The itemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The itemOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemOnHand;
    /**
     * The itemUnitsLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemUnitsLabel;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The itemBins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemBins;
    /**
     * The itemBinNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemBinNumbers;
    /**
     * The itemBinList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemBinList;
    /**
     * The itemPreferBin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemPreferBin;
    /**
     * The itemBlank
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemBlank;
    /**
     * Constructor method for BinWorksheetItem
     * @uses BinWorksheetItem::setItem()
     * @uses BinWorksheetItem::setItemName()
     * @uses BinWorksheetItem::setDescription()
     * @uses BinWorksheetItem::setQuantity()
     * @uses BinWorksheetItem::setItemOnHand()
     * @uses BinWorksheetItem::setItemUnitsLabel()
     * @uses BinWorksheetItem::setInventoryDetail()
     * @uses BinWorksheetItem::setItemBins()
     * @uses BinWorksheetItem::setItemBinNumbers()
     * @uses BinWorksheetItem::setItemBinList()
     * @uses BinWorksheetItem::setItemPreferBin()
     * @uses BinWorksheetItem::setItemBlank()
     * @param \StructType\RecordRef $item
     * @param string $itemName
     * @param string $description
     * @param float $quantity
     * @param string $itemOnHand
     * @param string $itemUnitsLabel
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $itemBins
     * @param string $itemBinNumbers
     * @param string $itemBinList
     * @param string $itemPreferBin
     * @param string $itemBlank
     */
    public function __construct(\StructType\RecordRef $item = null, $itemName = null, $description = null, $quantity = null, $itemOnHand = null, $itemUnitsLabel = null, \StructType\InventoryDetail $inventoryDetail = null, $itemBins = null, $itemBinNumbers = null, $itemBinList = null, $itemPreferBin = null, $itemBlank = null)
    {
        $this
            ->setItem($item)
            ->setItemName($itemName)
            ->setDescription($description)
            ->setQuantity($quantity)
            ->setItemOnHand($itemOnHand)
            ->setItemUnitsLabel($itemUnitsLabel)
            ->setInventoryDetail($inventoryDetail)
            ->setItemBins($itemBins)
            ->setItemBinNumbers($itemBinNumbers)
            ->setItemBinList($itemBinList)
            ->setItemPreferBin($itemPreferBin)
            ->setItemBlank($itemBlank);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\BinWorksheetItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get itemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->itemName;
    }
    /**
     * Set itemName value
     * @param string $itemName
     * @return \StructType\BinWorksheetItem
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->itemName = $itemName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\BinWorksheetItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\BinWorksheetItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get itemOnHand value
     * @return string|null
     */
    public function getItemOnHand()
    {
        return $this->itemOnHand;
    }
    /**
     * Set itemOnHand value
     * @param string $itemOnHand
     * @return \StructType\BinWorksheetItem
     */
    public function setItemOnHand($itemOnHand = null)
    {
        // validation for constraint: string
        if (!is_null($itemOnHand) && !is_string($itemOnHand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemOnHand, true), gettype($itemOnHand)), __LINE__);
        }
        $this->itemOnHand = $itemOnHand;
        return $this;
    }
    /**
     * Get itemUnitsLabel value
     * @return string|null
     */
    public function getItemUnitsLabel()
    {
        return $this->itemUnitsLabel;
    }
    /**
     * Set itemUnitsLabel value
     * @param string $itemUnitsLabel
     * @return \StructType\BinWorksheetItem
     */
    public function setItemUnitsLabel($itemUnitsLabel = null)
    {
        // validation for constraint: string
        if (!is_null($itemUnitsLabel) && !is_string($itemUnitsLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemUnitsLabel, true), gettype($itemUnitsLabel)), __LINE__);
        }
        $this->itemUnitsLabel = $itemUnitsLabel;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\BinWorksheetItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get itemBins value
     * @return string|null
     */
    public function getItemBins()
    {
        return $this->itemBins;
    }
    /**
     * Set itemBins value
     * @param string $itemBins
     * @return \StructType\BinWorksheetItem
     */
    public function setItemBins($itemBins = null)
    {
        // validation for constraint: string
        if (!is_null($itemBins) && !is_string($itemBins)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemBins, true), gettype($itemBins)), __LINE__);
        }
        $this->itemBins = $itemBins;
        return $this;
    }
    /**
     * Get itemBinNumbers value
     * @return string|null
     */
    public function getItemBinNumbers()
    {
        return $this->itemBinNumbers;
    }
    /**
     * Set itemBinNumbers value
     * @param string $itemBinNumbers
     * @return \StructType\BinWorksheetItem
     */
    public function setItemBinNumbers($itemBinNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($itemBinNumbers) && !is_string($itemBinNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemBinNumbers, true), gettype($itemBinNumbers)), __LINE__);
        }
        $this->itemBinNumbers = $itemBinNumbers;
        return $this;
    }
    /**
     * Get itemBinList value
     * @return string|null
     */
    public function getItemBinList()
    {
        return $this->itemBinList;
    }
    /**
     * Set itemBinList value
     * @param string $itemBinList
     * @return \StructType\BinWorksheetItem
     */
    public function setItemBinList($itemBinList = null)
    {
        // validation for constraint: string
        if (!is_null($itemBinList) && !is_string($itemBinList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemBinList, true), gettype($itemBinList)), __LINE__);
        }
        $this->itemBinList = $itemBinList;
        return $this;
    }
    /**
     * Get itemPreferBin value
     * @return string|null
     */
    public function getItemPreferBin()
    {
        return $this->itemPreferBin;
    }
    /**
     * Set itemPreferBin value
     * @param string $itemPreferBin
     * @return \StructType\BinWorksheetItem
     */
    public function setItemPreferBin($itemPreferBin = null)
    {
        // validation for constraint: string
        if (!is_null($itemPreferBin) && !is_string($itemPreferBin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemPreferBin, true), gettype($itemPreferBin)), __LINE__);
        }
        $this->itemPreferBin = $itemPreferBin;
        return $this;
    }
    /**
     * Get itemBlank value
     * @return string|null
     */
    public function getItemBlank()
    {
        return $this->itemBlank;
    }
    /**
     * Set itemBlank value
     * @param string $itemBlank
     * @return \StructType\BinWorksheetItem
     */
    public function setItemBlank($itemBlank = null)
    {
        // validation for constraint: string
        if (!is_null($itemBlank) && !is_string($itemBlank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemBlank, true), gettype($itemBlank)), __LINE__);
        }
        $this->itemBlank = $itemBlank;
        return $this;
    }
}
