<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingScheduleRecurrence StructType
 * @subpackage Structs
 */
class BillingScheduleRecurrence extends AbstractStructBase
{
    /**
     * The recurrenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $recurrenceId;
    /**
     * The count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $count;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $units;
    /**
     * The relativeToPrevious
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $relativeToPrevious;
    /**
     * The recurrenceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recurrenceDate;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The paymentTerms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentTerms;
    /**
     * Constructor method for BillingScheduleRecurrence
     * @uses BillingScheduleRecurrence::setRecurrenceId()
     * @uses BillingScheduleRecurrence::setCount()
     * @uses BillingScheduleRecurrence::setUnits()
     * @uses BillingScheduleRecurrence::setRelativeToPrevious()
     * @uses BillingScheduleRecurrence::setRecurrenceDate()
     * @uses BillingScheduleRecurrence::setAmount()
     * @uses BillingScheduleRecurrence::setPaymentTerms()
     * @param int $recurrenceId
     * @param int $count
     * @param string $units
     * @param bool $relativeToPrevious
     * @param string $recurrenceDate
     * @param float $amount
     * @param \StructType\RecordRef $paymentTerms
     */
    public function __construct($recurrenceId = null, $count = null, $units = null, $relativeToPrevious = null, $recurrenceDate = null, $amount = null, \StructType\RecordRef $paymentTerms = null)
    {
        $this
            ->setRecurrenceId($recurrenceId)
            ->setCount($count)
            ->setUnits($units)
            ->setRelativeToPrevious($relativeToPrevious)
            ->setRecurrenceDate($recurrenceDate)
            ->setAmount($amount)
            ->setPaymentTerms($paymentTerms);
    }
    /**
     * Get recurrenceId value
     * @return int|null
     */
    public function getRecurrenceId()
    {
        return $this->recurrenceId;
    }
    /**
     * Set recurrenceId value
     * @param int $recurrenceId
     * @return \StructType\BillingScheduleRecurrence
     */
    public function setRecurrenceId($recurrenceId = null)
    {
        // validation for constraint: int
        if (!is_null($recurrenceId) && !(is_int($recurrenceId) || ctype_digit($recurrenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recurrenceId, true), gettype($recurrenceId)), __LINE__);
        }
        $this->recurrenceId = $recurrenceId;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\BillingScheduleRecurrence
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get units value
     * @return string|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @uses \EnumType\BillingScheduleRecurrenceRecurrenceUnits::valueIsValid()
     * @uses \EnumType\BillingScheduleRecurrenceRecurrenceUnits::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $units
     * @return \StructType\BillingScheduleRecurrence
     */
    public function setUnits($units = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleRecurrenceRecurrenceUnits::valueIsValid($units)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleRecurrenceRecurrenceUnits', is_array($units) ? implode(', ', $units) : var_export($units, true), implode(', ', \EnumType\BillingScheduleRecurrenceRecurrenceUnits::getValidValues())), __LINE__);
        }
        $this->units = $units;
        return $this;
    }
    /**
     * Get relativeToPrevious value
     * @return bool|null
     */
    public function getRelativeToPrevious()
    {
        return $this->relativeToPrevious;
    }
    /**
     * Set relativeToPrevious value
     * @param bool $relativeToPrevious
     * @return \StructType\BillingScheduleRecurrence
     */
    public function setRelativeToPrevious($relativeToPrevious = null)
    {
        // validation for constraint: boolean
        if (!is_null($relativeToPrevious) && !is_bool($relativeToPrevious)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($relativeToPrevious, true), gettype($relativeToPrevious)), __LINE__);
        }
        $this->relativeToPrevious = $relativeToPrevious;
        return $this;
    }
    /**
     * Get recurrenceDate value
     * @return string|null
     */
    public function getRecurrenceDate()
    {
        return $this->recurrenceDate;
    }
    /**
     * Set recurrenceDate value
     * @param string $recurrenceDate
     * @return \StructType\BillingScheduleRecurrence
     */
    public function setRecurrenceDate($recurrenceDate = null)
    {
        // validation for constraint: string
        if (!is_null($recurrenceDate) && !is_string($recurrenceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recurrenceDate, true), gettype($recurrenceDate)), __LINE__);
        }
        $this->recurrenceDate = $recurrenceDate;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\BillingScheduleRecurrence
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get paymentTerms value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentTerms()
    {
        return $this->paymentTerms;
    }
    /**
     * Set paymentTerms value
     * @param \StructType\RecordRef $paymentTerms
     * @return \StructType\BillingScheduleRecurrence
     */
    public function setPaymentTerms(\StructType\RecordRef $paymentTerms = null)
    {
        $this->paymentTerms = $paymentTerms;
        return $this;
    }
}
