<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingSchedule StructType
 * @subpackage Structs
 */
class BillingSchedule extends Record
{
    /**
     * The scheduleType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $scheduleType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The recurrencePattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recurrencePattern;
    /**
     * The project
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $project;
    /**
     * The initialAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $initialAmount;
    /**
     * The initialTerms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $initialTerms;
    /**
     * The frequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $frequency;
    /**
     * The recurrenceDowMaskList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecurrenceDowMaskList
     */
    public $recurrenceDowMaskList;
    /**
     * The yearMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $yearMode;
    /**
     * The yearDowim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $yearDowim;
    /**
     * The yearDow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $yearDow;
    /**
     * The yearDowimMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $yearDowimMonth;
    /**
     * The yearMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $yearMonth;
    /**
     * The yearDom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $yearDom;
    /**
     * The monthMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $monthMode;
    /**
     * The monthDowim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $monthDowim;
    /**
     * The monthDow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $monthDow;
    /**
     * The monthDom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $monthDom;
    /**
     * The dayPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $dayPeriod;
    /**
     * The repeatEvery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $repeatEvery;
    /**
     * The billForActuals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $billForActuals;
    /**
     * The numberRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numberRemaining;
    /**
     * The inArrears
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $inArrears;
    /**
     * The recurrenceTerms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $recurrenceTerms;
    /**
     * The isPublic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPublic;
    /**
     * The applyToSubtotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $applyToSubtotal;
    /**
     * The transaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $transaction;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The seriesStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $seriesStartDate;
    /**
     * The recurrenceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillingScheduleRecurrenceList
     */
    public $recurrenceList;
    /**
     * The milestoneList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillingScheduleMilestoneList
     */
    public $milestoneList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for BillingSchedule
     * @uses BillingSchedule::setScheduleType()
     * @uses BillingSchedule::setName()
     * @uses BillingSchedule::setRecurrencePattern()
     * @uses BillingSchedule::setProject()
     * @uses BillingSchedule::setInitialAmount()
     * @uses BillingSchedule::setInitialTerms()
     * @uses BillingSchedule::setFrequency()
     * @uses BillingSchedule::setRecurrenceDowMaskList()
     * @uses BillingSchedule::setYearMode()
     * @uses BillingSchedule::setYearDowim()
     * @uses BillingSchedule::setYearDow()
     * @uses BillingSchedule::setYearDowimMonth()
     * @uses BillingSchedule::setYearMonth()
     * @uses BillingSchedule::setYearDom()
     * @uses BillingSchedule::setMonthMode()
     * @uses BillingSchedule::setMonthDowim()
     * @uses BillingSchedule::setMonthDow()
     * @uses BillingSchedule::setMonthDom()
     * @uses BillingSchedule::setDayPeriod()
     * @uses BillingSchedule::setRepeatEvery()
     * @uses BillingSchedule::setBillForActuals()
     * @uses BillingSchedule::setNumberRemaining()
     * @uses BillingSchedule::setInArrears()
     * @uses BillingSchedule::setRecurrenceTerms()
     * @uses BillingSchedule::setIsPublic()
     * @uses BillingSchedule::setApplyToSubtotal()
     * @uses BillingSchedule::setTransaction()
     * @uses BillingSchedule::setIsInactive()
     * @uses BillingSchedule::setSeriesStartDate()
     * @uses BillingSchedule::setRecurrenceList()
     * @uses BillingSchedule::setMilestoneList()
     * @uses BillingSchedule::setInternalId()
     * @uses BillingSchedule::setExternalId()
     * @param string $scheduleType
     * @param string $name
     * @param string $recurrencePattern
     * @param \StructType\RecordRef $project
     * @param string $initialAmount
     * @param \StructType\RecordRef $initialTerms
     * @param string $frequency
     * @param \StructType\RecurrenceDowMaskList $recurrenceDowMaskList
     * @param string $yearMode
     * @param string $yearDowim
     * @param string $yearDow
     * @param string $yearDowimMonth
     * @param string $yearMonth
     * @param int $yearDom
     * @param string $monthMode
     * @param string $monthDowim
     * @param string $monthDow
     * @param int $monthDom
     * @param int $dayPeriod
     * @param string $repeatEvery
     * @param bool $billForActuals
     * @param int $numberRemaining
     * @param bool $inArrears
     * @param \StructType\RecordRef $recurrenceTerms
     * @param bool $isPublic
     * @param bool $applyToSubtotal
     * @param \StructType\RecordRef $transaction
     * @param bool $isInactive
     * @param string $seriesStartDate
     * @param \StructType\BillingScheduleRecurrenceList $recurrenceList
     * @param \StructType\BillingScheduleMilestoneList $milestoneList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($scheduleType = null, $name = null, $recurrencePattern = null, \StructType\RecordRef $project = null, $initialAmount = null, \StructType\RecordRef $initialTerms = null, $frequency = null, \StructType\RecurrenceDowMaskList $recurrenceDowMaskList = null, $yearMode = null, $yearDowim = null, $yearDow = null, $yearDowimMonth = null, $yearMonth = null, $yearDom = null, $monthMode = null, $monthDowim = null, $monthDow = null, $monthDom = null, $dayPeriod = null, $repeatEvery = null, $billForActuals = null, $numberRemaining = null, $inArrears = null, \StructType\RecordRef $recurrenceTerms = null, $isPublic = null, $applyToSubtotal = null, \StructType\RecordRef $transaction = null, $isInactive = null, $seriesStartDate = null, \StructType\BillingScheduleRecurrenceList $recurrenceList = null, \StructType\BillingScheduleMilestoneList $milestoneList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setScheduleType($scheduleType)
            ->setName($name)
            ->setRecurrencePattern($recurrencePattern)
            ->setProject($project)
            ->setInitialAmount($initialAmount)
            ->setInitialTerms($initialTerms)
            ->setFrequency($frequency)
            ->setRecurrenceDowMaskList($recurrenceDowMaskList)
            ->setYearMode($yearMode)
            ->setYearDowim($yearDowim)
            ->setYearDow($yearDow)
            ->setYearDowimMonth($yearDowimMonth)
            ->setYearMonth($yearMonth)
            ->setYearDom($yearDom)
            ->setMonthMode($monthMode)
            ->setMonthDowim($monthDowim)
            ->setMonthDow($monthDow)
            ->setMonthDom($monthDom)
            ->setDayPeriod($dayPeriod)
            ->setRepeatEvery($repeatEvery)
            ->setBillForActuals($billForActuals)
            ->setNumberRemaining($numberRemaining)
            ->setInArrears($inArrears)
            ->setRecurrenceTerms($recurrenceTerms)
            ->setIsPublic($isPublic)
            ->setApplyToSubtotal($applyToSubtotal)
            ->setTransaction($transaction)
            ->setIsInactive($isInactive)
            ->setSeriesStartDate($seriesStartDate)
            ->setRecurrenceList($recurrenceList)
            ->setMilestoneList($milestoneList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get scheduleType value
     * @return string|null
     */
    public function getScheduleType()
    {
        return $this->scheduleType;
    }
    /**
     * Set scheduleType value
     * @uses \EnumType\BillingScheduleType::valueIsValid()
     * @uses \EnumType\BillingScheduleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduleType
     * @return \StructType\BillingSchedule
     */
    public function setScheduleType($scheduleType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleType::valueIsValid($scheduleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleType', is_array($scheduleType) ? implode(', ', $scheduleType) : var_export($scheduleType, true), implode(', ', \EnumType\BillingScheduleType::getValidValues())), __LINE__);
        }
        $this->scheduleType = $scheduleType;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\BillingSchedule
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get recurrencePattern value
     * @return string|null
     */
    public function getRecurrencePattern()
    {
        return $this->recurrencePattern;
    }
    /**
     * Set recurrencePattern value
     * @uses \EnumType\BillingScheduleRecurrencePattern::valueIsValid()
     * @uses \EnumType\BillingScheduleRecurrencePattern::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recurrencePattern
     * @return \StructType\BillingSchedule
     */
    public function setRecurrencePattern($recurrencePattern = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleRecurrencePattern::valueIsValid($recurrencePattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleRecurrencePattern', is_array($recurrencePattern) ? implode(', ', $recurrencePattern) : var_export($recurrencePattern, true), implode(', ', \EnumType\BillingScheduleRecurrencePattern::getValidValues())), __LINE__);
        }
        $this->recurrencePattern = $recurrencePattern;
        return $this;
    }
    /**
     * Get project value
     * @return \StructType\RecordRef|null
     */
    public function getProject()
    {
        return $this->project;
    }
    /**
     * Set project value
     * @param \StructType\RecordRef $project
     * @return \StructType\BillingSchedule
     */
    public function setProject(\StructType\RecordRef $project = null)
    {
        $this->project = $project;
        return $this;
    }
    /**
     * Get initialAmount value
     * @return string|null
     */
    public function getInitialAmount()
    {
        return $this->initialAmount;
    }
    /**
     * Set initialAmount value
     * @param string $initialAmount
     * @return \StructType\BillingSchedule
     */
    public function setInitialAmount($initialAmount = null)
    {
        // validation for constraint: string
        if (!is_null($initialAmount) && !is_string($initialAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initialAmount, true), gettype($initialAmount)), __LINE__);
        }
        $this->initialAmount = $initialAmount;
        return $this;
    }
    /**
     * Get initialTerms value
     * @return \StructType\RecordRef|null
     */
    public function getInitialTerms()
    {
        return $this->initialTerms;
    }
    /**
     * Set initialTerms value
     * @param \StructType\RecordRef $initialTerms
     * @return \StructType\BillingSchedule
     */
    public function setInitialTerms(\StructType\RecordRef $initialTerms = null)
    {
        $this->initialTerms = $initialTerms;
        return $this;
    }
    /**
     * Get frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->frequency;
    }
    /**
     * Set frequency value
     * @uses \EnumType\BillingScheduleFrequency::valueIsValid()
     * @uses \EnumType\BillingScheduleFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequency
     * @return \StructType\BillingSchedule
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleFrequency::valueIsValid($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleFrequency', is_array($frequency) ? implode(', ', $frequency) : var_export($frequency, true), implode(', ', \EnumType\BillingScheduleFrequency::getValidValues())), __LINE__);
        }
        $this->frequency = $frequency;
        return $this;
    }
    /**
     * Get recurrenceDowMaskList value
     * @return \StructType\RecurrenceDowMaskList|null
     */
    public function getRecurrenceDowMaskList()
    {
        return $this->recurrenceDowMaskList;
    }
    /**
     * Set recurrenceDowMaskList value
     * @param \StructType\RecurrenceDowMaskList $recurrenceDowMaskList
     * @return \StructType\BillingSchedule
     */
    public function setRecurrenceDowMaskList(\StructType\RecurrenceDowMaskList $recurrenceDowMaskList = null)
    {
        $this->recurrenceDowMaskList = $recurrenceDowMaskList;
        return $this;
    }
    /**
     * Get yearMode value
     * @return string|null
     */
    public function getYearMode()
    {
        return $this->yearMode;
    }
    /**
     * Set yearMode value
     * @uses \EnumType\BillingScheduleRecurrenceMode::valueIsValid()
     * @uses \EnumType\BillingScheduleRecurrenceMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $yearMode
     * @return \StructType\BillingSchedule
     */
    public function setYearMode($yearMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleRecurrenceMode::valueIsValid($yearMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleRecurrenceMode', is_array($yearMode) ? implode(', ', $yearMode) : var_export($yearMode, true), implode(', ', \EnumType\BillingScheduleRecurrenceMode::getValidValues())), __LINE__);
        }
        $this->yearMode = $yearMode;
        return $this;
    }
    /**
     * Get yearDowim value
     * @return string|null
     */
    public function getYearDowim()
    {
        return $this->yearDowim;
    }
    /**
     * Set yearDowim value
     * @uses \EnumType\BillingScheduleYearDowim::valueIsValid()
     * @uses \EnumType\BillingScheduleYearDowim::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $yearDowim
     * @return \StructType\BillingSchedule
     */
    public function setYearDowim($yearDowim = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleYearDowim::valueIsValid($yearDowim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleYearDowim', is_array($yearDowim) ? implode(', ', $yearDowim) : var_export($yearDowim, true), implode(', ', \EnumType\BillingScheduleYearDowim::getValidValues())), __LINE__);
        }
        $this->yearDowim = $yearDowim;
        return $this;
    }
    /**
     * Get yearDow value
     * @return string|null
     */
    public function getYearDow()
    {
        return $this->yearDow;
    }
    /**
     * Set yearDow value
     * @uses \EnumType\BillingScheduleYearDow::valueIsValid()
     * @uses \EnumType\BillingScheduleYearDow::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $yearDow
     * @return \StructType\BillingSchedule
     */
    public function setYearDow($yearDow = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleYearDow::valueIsValid($yearDow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleYearDow', is_array($yearDow) ? implode(', ', $yearDow) : var_export($yearDow, true), implode(', ', \EnumType\BillingScheduleYearDow::getValidValues())), __LINE__);
        }
        $this->yearDow = $yearDow;
        return $this;
    }
    /**
     * Get yearDowimMonth value
     * @return string|null
     */
    public function getYearDowimMonth()
    {
        return $this->yearDowimMonth;
    }
    /**
     * Set yearDowimMonth value
     * @uses \EnumType\BillingScheduleYearDowimMonth::valueIsValid()
     * @uses \EnumType\BillingScheduleYearDowimMonth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $yearDowimMonth
     * @return \StructType\BillingSchedule
     */
    public function setYearDowimMonth($yearDowimMonth = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleYearDowimMonth::valueIsValid($yearDowimMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleYearDowimMonth', is_array($yearDowimMonth) ? implode(', ', $yearDowimMonth) : var_export($yearDowimMonth, true), implode(', ', \EnumType\BillingScheduleYearDowimMonth::getValidValues())), __LINE__);
        }
        $this->yearDowimMonth = $yearDowimMonth;
        return $this;
    }
    /**
     * Get yearMonth value
     * @return string|null
     */
    public function getYearMonth()
    {
        return $this->yearMonth;
    }
    /**
     * Set yearMonth value
     * @uses \EnumType\BillingScheduleYearMonth::valueIsValid()
     * @uses \EnumType\BillingScheduleYearMonth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $yearMonth
     * @return \StructType\BillingSchedule
     */
    public function setYearMonth($yearMonth = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleYearMonth::valueIsValid($yearMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleYearMonth', is_array($yearMonth) ? implode(', ', $yearMonth) : var_export($yearMonth, true), implode(', ', \EnumType\BillingScheduleYearMonth::getValidValues())), __LINE__);
        }
        $this->yearMonth = $yearMonth;
        return $this;
    }
    /**
     * Get yearDom value
     * @return int|null
     */
    public function getYearDom()
    {
        return $this->yearDom;
    }
    /**
     * Set yearDom value
     * @param int $yearDom
     * @return \StructType\BillingSchedule
     */
    public function setYearDom($yearDom = null)
    {
        // validation for constraint: int
        if (!is_null($yearDom) && !(is_int($yearDom) || ctype_digit($yearDom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($yearDom, true), gettype($yearDom)), __LINE__);
        }
        $this->yearDom = $yearDom;
        return $this;
    }
    /**
     * Get monthMode value
     * @return string|null
     */
    public function getMonthMode()
    {
        return $this->monthMode;
    }
    /**
     * Set monthMode value
     * @uses \EnumType\BillingScheduleRecurrenceMode::valueIsValid()
     * @uses \EnumType\BillingScheduleRecurrenceMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthMode
     * @return \StructType\BillingSchedule
     */
    public function setMonthMode($monthMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleRecurrenceMode::valueIsValid($monthMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleRecurrenceMode', is_array($monthMode) ? implode(', ', $monthMode) : var_export($monthMode, true), implode(', ', \EnumType\BillingScheduleRecurrenceMode::getValidValues())), __LINE__);
        }
        $this->monthMode = $monthMode;
        return $this;
    }
    /**
     * Get monthDowim value
     * @return string|null
     */
    public function getMonthDowim()
    {
        return $this->monthDowim;
    }
    /**
     * Set monthDowim value
     * @uses \EnumType\BillingScheduleMonthDowim::valueIsValid()
     * @uses \EnumType\BillingScheduleMonthDowim::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthDowim
     * @return \StructType\BillingSchedule
     */
    public function setMonthDowim($monthDowim = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleMonthDowim::valueIsValid($monthDowim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleMonthDowim', is_array($monthDowim) ? implode(', ', $monthDowim) : var_export($monthDowim, true), implode(', ', \EnumType\BillingScheduleMonthDowim::getValidValues())), __LINE__);
        }
        $this->monthDowim = $monthDowim;
        return $this;
    }
    /**
     * Get monthDow value
     * @return string|null
     */
    public function getMonthDow()
    {
        return $this->monthDow;
    }
    /**
     * Set monthDow value
     * @uses \EnumType\BillingScheduleMonthDow::valueIsValid()
     * @uses \EnumType\BillingScheduleMonthDow::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthDow
     * @return \StructType\BillingSchedule
     */
    public function setMonthDow($monthDow = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleMonthDow::valueIsValid($monthDow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleMonthDow', is_array($monthDow) ? implode(', ', $monthDow) : var_export($monthDow, true), implode(', ', \EnumType\BillingScheduleMonthDow::getValidValues())), __LINE__);
        }
        $this->monthDow = $monthDow;
        return $this;
    }
    /**
     * Get monthDom value
     * @return int|null
     */
    public function getMonthDom()
    {
        return $this->monthDom;
    }
    /**
     * Set monthDom value
     * @param int $monthDom
     * @return \StructType\BillingSchedule
     */
    public function setMonthDom($monthDom = null)
    {
        // validation for constraint: int
        if (!is_null($monthDom) && !(is_int($monthDom) || ctype_digit($monthDom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monthDom, true), gettype($monthDom)), __LINE__);
        }
        $this->monthDom = $monthDom;
        return $this;
    }
    /**
     * Get dayPeriod value
     * @return int|null
     */
    public function getDayPeriod()
    {
        return $this->dayPeriod;
    }
    /**
     * Set dayPeriod value
     * @param int $dayPeriod
     * @return \StructType\BillingSchedule
     */
    public function setDayPeriod($dayPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($dayPeriod) && !(is_int($dayPeriod) || ctype_digit($dayPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dayPeriod, true), gettype($dayPeriod)), __LINE__);
        }
        $this->dayPeriod = $dayPeriod;
        return $this;
    }
    /**
     * Get repeatEvery value
     * @return string|null
     */
    public function getRepeatEvery()
    {
        return $this->repeatEvery;
    }
    /**
     * Set repeatEvery value
     * @uses \EnumType\BillingScheduleRepeatEvery::valueIsValid()
     * @uses \EnumType\BillingScheduleRepeatEvery::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $repeatEvery
     * @return \StructType\BillingSchedule
     */
    public function setRepeatEvery($repeatEvery = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingScheduleRepeatEvery::valueIsValid($repeatEvery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingScheduleRepeatEvery', is_array($repeatEvery) ? implode(', ', $repeatEvery) : var_export($repeatEvery, true), implode(', ', \EnumType\BillingScheduleRepeatEvery::getValidValues())), __LINE__);
        }
        $this->repeatEvery = $repeatEvery;
        return $this;
    }
    /**
     * Get billForActuals value
     * @return bool|null
     */
    public function getBillForActuals()
    {
        return $this->billForActuals;
    }
    /**
     * Set billForActuals value
     * @param bool $billForActuals
     * @return \StructType\BillingSchedule
     */
    public function setBillForActuals($billForActuals = null)
    {
        // validation for constraint: boolean
        if (!is_null($billForActuals) && !is_bool($billForActuals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billForActuals, true), gettype($billForActuals)), __LINE__);
        }
        $this->billForActuals = $billForActuals;
        return $this;
    }
    /**
     * Get numberRemaining value
     * @return int|null
     */
    public function getNumberRemaining()
    {
        return $this->numberRemaining;
    }
    /**
     * Set numberRemaining value
     * @param int $numberRemaining
     * @return \StructType\BillingSchedule
     */
    public function setNumberRemaining($numberRemaining = null)
    {
        // validation for constraint: int
        if (!is_null($numberRemaining) && !(is_int($numberRemaining) || ctype_digit($numberRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberRemaining, true), gettype($numberRemaining)), __LINE__);
        }
        $this->numberRemaining = $numberRemaining;
        return $this;
    }
    /**
     * Get inArrears value
     * @return bool|null
     */
    public function getInArrears()
    {
        return $this->inArrears;
    }
    /**
     * Set inArrears value
     * @param bool $inArrears
     * @return \StructType\BillingSchedule
     */
    public function setInArrears($inArrears = null)
    {
        // validation for constraint: boolean
        if (!is_null($inArrears) && !is_bool($inArrears)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inArrears, true), gettype($inArrears)), __LINE__);
        }
        $this->inArrears = $inArrears;
        return $this;
    }
    /**
     * Get recurrenceTerms value
     * @return \StructType\RecordRef|null
     */
    public function getRecurrenceTerms()
    {
        return $this->recurrenceTerms;
    }
    /**
     * Set recurrenceTerms value
     * @param \StructType\RecordRef $recurrenceTerms
     * @return \StructType\BillingSchedule
     */
    public function setRecurrenceTerms(\StructType\RecordRef $recurrenceTerms = null)
    {
        $this->recurrenceTerms = $recurrenceTerms;
        return $this;
    }
    /**
     * Get isPublic value
     * @return bool|null
     */
    public function getIsPublic()
    {
        return $this->isPublic;
    }
    /**
     * Set isPublic value
     * @param bool $isPublic
     * @return \StructType\BillingSchedule
     */
    public function setIsPublic($isPublic = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPublic) && !is_bool($isPublic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPublic, true), gettype($isPublic)), __LINE__);
        }
        $this->isPublic = $isPublic;
        return $this;
    }
    /**
     * Get applyToSubtotal value
     * @return bool|null
     */
    public function getApplyToSubtotal()
    {
        return $this->applyToSubtotal;
    }
    /**
     * Set applyToSubtotal value
     * @param bool $applyToSubtotal
     * @return \StructType\BillingSchedule
     */
    public function setApplyToSubtotal($applyToSubtotal = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyToSubtotal) && !is_bool($applyToSubtotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applyToSubtotal, true), gettype($applyToSubtotal)), __LINE__);
        }
        $this->applyToSubtotal = $applyToSubtotal;
        return $this;
    }
    /**
     * Get transaction value
     * @return \StructType\RecordRef|null
     */
    public function getTransaction()
    {
        return $this->transaction;
    }
    /**
     * Set transaction value
     * @param \StructType\RecordRef $transaction
     * @return \StructType\BillingSchedule
     */
    public function setTransaction(\StructType\RecordRef $transaction = null)
    {
        $this->transaction = $transaction;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\BillingSchedule
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get seriesStartDate value
     * @return string|null
     */
    public function getSeriesStartDate()
    {
        return $this->seriesStartDate;
    }
    /**
     * Set seriesStartDate value
     * @param string $seriesStartDate
     * @return \StructType\BillingSchedule
     */
    public function setSeriesStartDate($seriesStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($seriesStartDate) && !is_string($seriesStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesStartDate, true), gettype($seriesStartDate)), __LINE__);
        }
        $this->seriesStartDate = $seriesStartDate;
        return $this;
    }
    /**
     * Get recurrenceList value
     * @return \StructType\BillingScheduleRecurrenceList|null
     */
    public function getRecurrenceList()
    {
        return $this->recurrenceList;
    }
    /**
     * Set recurrenceList value
     * @param \StructType\BillingScheduleRecurrenceList $recurrenceList
     * @return \StructType\BillingSchedule
     */
    public function setRecurrenceList(\StructType\BillingScheduleRecurrenceList $recurrenceList = null)
    {
        $this->recurrenceList = $recurrenceList;
        return $this;
    }
    /**
     * Get milestoneList value
     * @return \StructType\BillingScheduleMilestoneList|null
     */
    public function getMilestoneList()
    {
        return $this->milestoneList;
    }
    /**
     * Set milestoneList value
     * @param \StructType\BillingScheduleMilestoneList $milestoneList
     * @return \StructType\BillingSchedule
     */
    public function setMilestoneList(\StructType\BillingScheduleMilestoneList $milestoneList = null)
    {
        $this->milestoneList = $milestoneList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\BillingSchedule
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\BillingSchedule
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
