<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingRatesMatrix StructType
 * @subpackage Structs
 */
class BillingRatesMatrix extends AbstractStructBase
{
    /**
     * The billingRates
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BillingRates[]
     */
    public $billingRates;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for BillingRatesMatrix
     * @uses BillingRatesMatrix::setBillingRates()
     * @uses BillingRatesMatrix::setReplaceAll()
     * @param \StructType\BillingRates[] $billingRates
     * @param bool $replaceAll
     */
    public function __construct(array $billingRates = array(), $replaceAll = true)
    {
        $this
            ->setBillingRates($billingRates)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get billingRates value
     * @return \StructType\BillingRates[]|null
     */
    public function getBillingRates()
    {
        return $this->billingRates;
    }
    /**
     * This method is responsible for validating the values passed to the setBillingRates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillingRates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillingRatesForArrayConstraintsFromSetBillingRates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingRatesMatrixBillingRatesItem) {
            // validation for constraint: itemType
            if (!$billingRatesMatrixBillingRatesItem instanceof \StructType\BillingRates) {
                $invalidValues[] = is_object($billingRatesMatrixBillingRatesItem) ? get_class($billingRatesMatrixBillingRatesItem) : sprintf('%s(%s)', gettype($billingRatesMatrixBillingRatesItem), var_export($billingRatesMatrixBillingRatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The billingRates property can only contain items of type \StructType\BillingRates, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set billingRates value
     * @throws \InvalidArgumentException
     * @param \StructType\BillingRates[] $billingRates
     * @return \StructType\BillingRatesMatrix
     */
    public function setBillingRates(array $billingRates = array())
    {
        // validation for constraint: array
        if ('' !== ($billingRatesArrayErrorMessage = self::validateBillingRatesForArrayConstraintsFromSetBillingRates($billingRates))) {
            throw new \InvalidArgumentException($billingRatesArrayErrorMessage, __LINE__);
        }
        $this->billingRates = $billingRates;
        return $this;
    }
    /**
     * Add item to billingRates value
     * @throws \InvalidArgumentException
     * @param \StructType\BillingRates $item
     * @return \StructType\BillingRatesMatrix
     */
    public function addToBillingRates(\StructType\BillingRates $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BillingRates) {
            throw new \InvalidArgumentException(sprintf('The billingRates property can only contain items of type \StructType\BillingRates, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->billingRates[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\BillingRatesMatrix
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
