<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingAccountSearchRowBasic StructType
 * @subpackage Structs
 */
class BillingAccountSearchRowBasic extends SearchRowBasic
{
    /**
     * The billingSchedule
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $billingSchedule;
    /**
     * The cashSaleForm
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $cashSaleForm;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $class;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $currency;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $customer;
    /**
     * The customerDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $customerDefault;
    /**
     * The dateCreated
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $dateCreated;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $department;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The frequency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $frequency;
    /**
     * The idNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $idNumber;
    /**
     * The inactive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $inactive;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The invoiceForm
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $invoiceForm;
    /**
     * The lastBillCycleDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $lastBillCycleDate;
    /**
     * The lastBillDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $lastBillDate;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $location;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $memo;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $name;
    /**
     * The nextBillCycleDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $nextBillCycleDate;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $startDate;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $subsidiary;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for BillingAccountSearchRowBasic
     * @uses BillingAccountSearchRowBasic::setBillingSchedule()
     * @uses BillingAccountSearchRowBasic::setCashSaleForm()
     * @uses BillingAccountSearchRowBasic::setClass()
     * @uses BillingAccountSearchRowBasic::setCurrency()
     * @uses BillingAccountSearchRowBasic::setCustomer()
     * @uses BillingAccountSearchRowBasic::setCustomerDefault()
     * @uses BillingAccountSearchRowBasic::setDateCreated()
     * @uses BillingAccountSearchRowBasic::setDepartment()
     * @uses BillingAccountSearchRowBasic::setExternalId()
     * @uses BillingAccountSearchRowBasic::setFrequency()
     * @uses BillingAccountSearchRowBasic::setIdNumber()
     * @uses BillingAccountSearchRowBasic::setInactive()
     * @uses BillingAccountSearchRowBasic::setInternalId()
     * @uses BillingAccountSearchRowBasic::setInvoiceForm()
     * @uses BillingAccountSearchRowBasic::setLastBillCycleDate()
     * @uses BillingAccountSearchRowBasic::setLastBillDate()
     * @uses BillingAccountSearchRowBasic::setLocation()
     * @uses BillingAccountSearchRowBasic::setMemo()
     * @uses BillingAccountSearchRowBasic::setName()
     * @uses BillingAccountSearchRowBasic::setNextBillCycleDate()
     * @uses BillingAccountSearchRowBasic::setStartDate()
     * @uses BillingAccountSearchRowBasic::setSubsidiary()
     * @uses BillingAccountSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnSelectField[] $billingSchedule
     * @param \StructType\SearchColumnSelectField[] $cashSaleForm
     * @param \StructType\SearchColumnSelectField[] $class
     * @param \StructType\SearchColumnSelectField[] $currency
     * @param \StructType\SearchColumnSelectField[] $customer
     * @param \StructType\SearchColumnBooleanField[] $customerDefault
     * @param \StructType\SearchColumnDateField[] $dateCreated
     * @param \StructType\SearchColumnSelectField[] $department
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnEnumSelectField[] $frequency
     * @param \StructType\SearchColumnStringField[] $idNumber
     * @param \StructType\SearchColumnBooleanField[] $inactive
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnSelectField[] $invoiceForm
     * @param \StructType\SearchColumnDateField[] $lastBillCycleDate
     * @param \StructType\SearchColumnDateField[] $lastBillDate
     * @param \StructType\SearchColumnSelectField[] $location
     * @param \StructType\SearchColumnStringField[] $memo
     * @param \StructType\SearchColumnStringField[] $name
     * @param \StructType\SearchColumnDateField[] $nextBillCycleDate
     * @param \StructType\SearchColumnDateField[] $startDate
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $billingSchedule = array(), array $cashSaleForm = array(), array $class = array(), array $currency = array(), array $customer = array(), array $customerDefault = array(), array $dateCreated = array(), array $department = array(), array $externalId = array(), array $frequency = array(), array $idNumber = array(), array $inactive = array(), array $internalId = array(), array $invoiceForm = array(), array $lastBillCycleDate = array(), array $lastBillDate = array(), array $location = array(), array $memo = array(), array $name = array(), array $nextBillCycleDate = array(), array $startDate = array(), array $subsidiary = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setBillingSchedule($billingSchedule)
            ->setCashSaleForm($cashSaleForm)
            ->setClass($class)
            ->setCurrency($currency)
            ->setCustomer($customer)
            ->setCustomerDefault($customerDefault)
            ->setDateCreated($dateCreated)
            ->setDepartment($department)
            ->setExternalId($externalId)
            ->setFrequency($frequency)
            ->setIdNumber($idNumber)
            ->setInactive($inactive)
            ->setInternalId($internalId)
            ->setInvoiceForm($invoiceForm)
            ->setLastBillCycleDate($lastBillCycleDate)
            ->setLastBillDate($lastBillDate)
            ->setLocation($location)
            ->setMemo($memo)
            ->setName($name)
            ->setNextBillCycleDate($nextBillCycleDate)
            ->setStartDate($startDate)
            ->setSubsidiary($subsidiary)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get billingSchedule value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getBillingSchedule()
    {
        return $this->billingSchedule;
    }
    /**
     * This method is responsible for validating the values passed to the setBillingSchedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillingSchedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillingScheduleForArrayConstraintsFromSetBillingSchedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicBillingScheduleItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicBillingScheduleItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicBillingScheduleItem) ? get_class($billingAccountSearchRowBasicBillingScheduleItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicBillingScheduleItem), var_export($billingAccountSearchRowBasicBillingScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The billingSchedule property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set billingSchedule value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $billingSchedule
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setBillingSchedule(array $billingSchedule = array())
    {
        // validation for constraint: array
        if ('' !== ($billingScheduleArrayErrorMessage = self::validateBillingScheduleForArrayConstraintsFromSetBillingSchedule($billingSchedule))) {
            throw new \InvalidArgumentException($billingScheduleArrayErrorMessage, __LINE__);
        }
        $this->billingSchedule = $billingSchedule;
        return $this;
    }
    /**
     * Add item to billingSchedule value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToBillingSchedule(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The billingSchedule property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->billingSchedule[] = $item;
        return $this;
    }
    /**
     * Get cashSaleForm value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getCashSaleForm()
    {
        return $this->cashSaleForm;
    }
    /**
     * This method is responsible for validating the values passed to the setCashSaleForm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCashSaleForm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCashSaleFormForArrayConstraintsFromSetCashSaleForm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicCashSaleFormItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicCashSaleFormItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicCashSaleFormItem) ? get_class($billingAccountSearchRowBasicCashSaleFormItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicCashSaleFormItem), var_export($billingAccountSearchRowBasicCashSaleFormItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cashSaleForm property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cashSaleForm value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $cashSaleForm
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setCashSaleForm(array $cashSaleForm = array())
    {
        // validation for constraint: array
        if ('' !== ($cashSaleFormArrayErrorMessage = self::validateCashSaleFormForArrayConstraintsFromSetCashSaleForm($cashSaleForm))) {
            throw new \InvalidArgumentException($cashSaleFormArrayErrorMessage, __LINE__);
        }
        $this->cashSaleForm = $cashSaleForm;
        return $this;
    }
    /**
     * Add item to cashSaleForm value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToCashSaleForm(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The cashSaleForm property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cashSaleForm[] = $item;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * This method is responsible for validating the values passed to the setClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClassForArrayConstraintsFromSetClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicClassItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicClassItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicClassItem) ? get_class($billingAccountSearchRowBasicClassItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicClassItem), var_export($billingAccountSearchRowBasicClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The class property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set class value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $class
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setClass(array $class = array())
    {
        // validation for constraint: array
        if ('' !== ($classArrayErrorMessage = self::validateClassForArrayConstraintsFromSetClass($class))) {
            throw new \InvalidArgumentException($classArrayErrorMessage, __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Add item to class value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToClass(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The class property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->class[] = $item;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyForArrayConstraintsFromSetCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicCurrencyItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicCurrencyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicCurrencyItem) ? get_class($billingAccountSearchRowBasicCurrencyItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicCurrencyItem), var_export($billingAccountSearchRowBasicCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The currency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $currency
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setCurrency(array $currency = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyArrayErrorMessage = self::validateCurrencyForArrayConstraintsFromSetCurrency($currency))) {
            throw new \InvalidArgumentException($currencyArrayErrorMessage, __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Add item to currency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToCurrency(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The currency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->currency[] = $item;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerForArrayConstraintsFromSetCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicCustomerItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicCustomerItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicCustomerItem) ? get_class($billingAccountSearchRowBasicCustomerItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicCustomerItem), var_export($billingAccountSearchRowBasicCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customer property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customer value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $customer
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setCustomer(array $customer = array())
    {
        // validation for constraint: array
        if ('' !== ($customerArrayErrorMessage = self::validateCustomerForArrayConstraintsFromSetCustomer($customer))) {
            throw new \InvalidArgumentException($customerArrayErrorMessage, __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Add item to customer value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToCustomer(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The customer property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customer[] = $item;
        return $this;
    }
    /**
     * Get customerDefault value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getCustomerDefault()
    {
        return $this->customerDefault;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerDefault method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerDefault method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerDefaultForArrayConstraintsFromSetCustomerDefault(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicCustomerDefaultItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicCustomerDefaultItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicCustomerDefaultItem) ? get_class($billingAccountSearchRowBasicCustomerDefaultItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicCustomerDefaultItem), var_export($billingAccountSearchRowBasicCustomerDefaultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customerDefault property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customerDefault value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $customerDefault
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setCustomerDefault(array $customerDefault = array())
    {
        // validation for constraint: array
        if ('' !== ($customerDefaultArrayErrorMessage = self::validateCustomerDefaultForArrayConstraintsFromSetCustomerDefault($customerDefault))) {
            throw new \InvalidArgumentException($customerDefaultArrayErrorMessage, __LINE__);
        }
        $this->customerDefault = $customerDefault;
        return $this;
    }
    /**
     * Add item to customerDefault value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToCustomerDefault(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The customerDefault property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customerDefault[] = $item;
        return $this;
    }
    /**
     * Get dateCreated value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
    /**
     * This method is responsible for validating the values passed to the setDateCreated method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateCreated method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateCreatedForArrayConstraintsFromSetDateCreated(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicDateCreatedItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicDateCreatedItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicDateCreatedItem) ? get_class($billingAccountSearchRowBasicDateCreatedItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicDateCreatedItem), var_export($billingAccountSearchRowBasicDateCreatedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dateCreated property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dateCreated value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $dateCreated
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setDateCreated(array $dateCreated = array())
    {
        // validation for constraint: array
        if ('' !== ($dateCreatedArrayErrorMessage = self::validateDateCreatedForArrayConstraintsFromSetDateCreated($dateCreated))) {
            throw new \InvalidArgumentException($dateCreatedArrayErrorMessage, __LINE__);
        }
        $this->dateCreated = $dateCreated;
        return $this;
    }
    /**
     * Add item to dateCreated value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToDateCreated(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The dateCreated property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dateCreated[] = $item;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * This method is responsible for validating the values passed to the setDepartment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepartment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepartmentForArrayConstraintsFromSetDepartment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicDepartmentItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicDepartmentItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicDepartmentItem) ? get_class($billingAccountSearchRowBasicDepartmentItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicDepartmentItem), var_export($billingAccountSearchRowBasicDepartmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The department property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set department value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $department
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setDepartment(array $department = array())
    {
        // validation for constraint: array
        if ('' !== ($departmentArrayErrorMessage = self::validateDepartmentForArrayConstraintsFromSetDepartment($department))) {
            throw new \InvalidArgumentException($departmentArrayErrorMessage, __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Add item to department value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToDepartment(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The department property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->department[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicExternalIdItem) ? get_class($billingAccountSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicExternalIdItem), var_export($billingAccountSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get frequency value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getFrequency()
    {
        return $this->frequency;
    }
    /**
     * This method is responsible for validating the values passed to the setFrequency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFrequency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFrequencyForArrayConstraintsFromSetFrequency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicFrequencyItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicFrequencyItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicFrequencyItem) ? get_class($billingAccountSearchRowBasicFrequencyItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicFrequencyItem), var_export($billingAccountSearchRowBasicFrequencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The frequency property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set frequency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $frequency
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setFrequency(array $frequency = array())
    {
        // validation for constraint: array
        if ('' !== ($frequencyArrayErrorMessage = self::validateFrequencyForArrayConstraintsFromSetFrequency($frequency))) {
            throw new \InvalidArgumentException($frequencyArrayErrorMessage, __LINE__);
        }
        $this->frequency = $frequency;
        return $this;
    }
    /**
     * Add item to frequency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToFrequency(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The frequency property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->frequency[] = $item;
        return $this;
    }
    /**
     * Get idNumber value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getIdNumber()
    {
        return $this->idNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setIdNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdNumberForArrayConstraintsFromSetIdNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicIdNumberItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicIdNumberItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicIdNumberItem) ? get_class($billingAccountSearchRowBasicIdNumberItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicIdNumberItem), var_export($billingAccountSearchRowBasicIdNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idNumber property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $idNumber
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setIdNumber(array $idNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($idNumberArrayErrorMessage = self::validateIdNumberForArrayConstraintsFromSetIdNumber($idNumber))) {
            throw new \InvalidArgumentException($idNumberArrayErrorMessage, __LINE__);
        }
        $this->idNumber = $idNumber;
        return $this;
    }
    /**
     * Add item to idNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToIdNumber(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The idNumber property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idNumber[] = $item;
        return $this;
    }
    /**
     * Get inactive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getInactive()
    {
        return $this->inactive;
    }
    /**
     * This method is responsible for validating the values passed to the setInactive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInactive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInactiveForArrayConstraintsFromSetInactive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicInactiveItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicInactiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicInactiveItem) ? get_class($billingAccountSearchRowBasicInactiveItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicInactiveItem), var_export($billingAccountSearchRowBasicInactiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The inactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set inactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $inactive
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setInactive(array $inactive = array())
    {
        // validation for constraint: array
        if ('' !== ($inactiveArrayErrorMessage = self::validateInactiveForArrayConstraintsFromSetInactive($inactive))) {
            throw new \InvalidArgumentException($inactiveArrayErrorMessage, __LINE__);
        }
        $this->inactive = $inactive;
        return $this;
    }
    /**
     * Add item to inactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToInactive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The inactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->inactive[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicInternalIdItem) ? get_class($billingAccountSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicInternalIdItem), var_export($billingAccountSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get invoiceForm value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInvoiceForm()
    {
        return $this->invoiceForm;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceForm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceForm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceFormForArrayConstraintsFromSetInvoiceForm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicInvoiceFormItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicInvoiceFormItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicInvoiceFormItem) ? get_class($billingAccountSearchRowBasicInvoiceFormItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicInvoiceFormItem), var_export($billingAccountSearchRowBasicInvoiceFormItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The invoiceForm property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set invoiceForm value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $invoiceForm
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setInvoiceForm(array $invoiceForm = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceFormArrayErrorMessage = self::validateInvoiceFormForArrayConstraintsFromSetInvoiceForm($invoiceForm))) {
            throw new \InvalidArgumentException($invoiceFormArrayErrorMessage, __LINE__);
        }
        $this->invoiceForm = $invoiceForm;
        return $this;
    }
    /**
     * Add item to invoiceForm value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToInvoiceForm(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The invoiceForm property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->invoiceForm[] = $item;
        return $this;
    }
    /**
     * Get lastBillCycleDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getLastBillCycleDate()
    {
        return $this->lastBillCycleDate;
    }
    /**
     * This method is responsible for validating the values passed to the setLastBillCycleDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastBillCycleDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLastBillCycleDateForArrayConstraintsFromSetLastBillCycleDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicLastBillCycleDateItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicLastBillCycleDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicLastBillCycleDateItem) ? get_class($billingAccountSearchRowBasicLastBillCycleDateItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicLastBillCycleDateItem), var_export($billingAccountSearchRowBasicLastBillCycleDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lastBillCycleDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lastBillCycleDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $lastBillCycleDate
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setLastBillCycleDate(array $lastBillCycleDate = array())
    {
        // validation for constraint: array
        if ('' !== ($lastBillCycleDateArrayErrorMessage = self::validateLastBillCycleDateForArrayConstraintsFromSetLastBillCycleDate($lastBillCycleDate))) {
            throw new \InvalidArgumentException($lastBillCycleDateArrayErrorMessage, __LINE__);
        }
        $this->lastBillCycleDate = $lastBillCycleDate;
        return $this;
    }
    /**
     * Add item to lastBillCycleDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToLastBillCycleDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The lastBillCycleDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lastBillCycleDate[] = $item;
        return $this;
    }
    /**
     * Get lastBillDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getLastBillDate()
    {
        return $this->lastBillDate;
    }
    /**
     * This method is responsible for validating the values passed to the setLastBillDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastBillDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLastBillDateForArrayConstraintsFromSetLastBillDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicLastBillDateItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicLastBillDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicLastBillDateItem) ? get_class($billingAccountSearchRowBasicLastBillDateItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicLastBillDateItem), var_export($billingAccountSearchRowBasicLastBillDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lastBillDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lastBillDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $lastBillDate
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setLastBillDate(array $lastBillDate = array())
    {
        // validation for constraint: array
        if ('' !== ($lastBillDateArrayErrorMessage = self::validateLastBillDateForArrayConstraintsFromSetLastBillDate($lastBillDate))) {
            throw new \InvalidArgumentException($lastBillDateArrayErrorMessage, __LINE__);
        }
        $this->lastBillDate = $lastBillDate;
        return $this;
    }
    /**
     * Add item to lastBillDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToLastBillDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The lastBillDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lastBillDate[] = $item;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicLocationItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicLocationItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicLocationItem) ? get_class($billingAccountSearchRowBasicLocationItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicLocationItem), var_export($billingAccountSearchRowBasicLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The location property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $location
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Add item to location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToLocation(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The location property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->location[] = $item;
        return $this;
    }
    /**
     * Get memo value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * This method is responsible for validating the values passed to the setMemo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMemo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMemoForArrayConstraintsFromSetMemo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicMemoItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicMemoItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicMemoItem) ? get_class($billingAccountSearchRowBasicMemoItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicMemoItem), var_export($billingAccountSearchRowBasicMemoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The memo property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set memo value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $memo
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setMemo(array $memo = array())
    {
        // validation for constraint: array
        if ('' !== ($memoArrayErrorMessage = self::validateMemoForArrayConstraintsFromSetMemo($memo))) {
            throw new \InvalidArgumentException($memoArrayErrorMessage, __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Add item to memo value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToMemo(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The memo property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->memo[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicNameItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicNameItem) ? get_class($billingAccountSearchRowBasicNameItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicNameItem), var_export($billingAccountSearchRowBasicNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $name
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
    /**
     * Get nextBillCycleDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getNextBillCycleDate()
    {
        return $this->nextBillCycleDate;
    }
    /**
     * This method is responsible for validating the values passed to the setNextBillCycleDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNextBillCycleDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNextBillCycleDateForArrayConstraintsFromSetNextBillCycleDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicNextBillCycleDateItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicNextBillCycleDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicNextBillCycleDateItem) ? get_class($billingAccountSearchRowBasicNextBillCycleDateItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicNextBillCycleDateItem), var_export($billingAccountSearchRowBasicNextBillCycleDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nextBillCycleDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nextBillCycleDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $nextBillCycleDate
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setNextBillCycleDate(array $nextBillCycleDate = array())
    {
        // validation for constraint: array
        if ('' !== ($nextBillCycleDateArrayErrorMessage = self::validateNextBillCycleDateForArrayConstraintsFromSetNextBillCycleDate($nextBillCycleDate))) {
            throw new \InvalidArgumentException($nextBillCycleDateArrayErrorMessage, __LINE__);
        }
        $this->nextBillCycleDate = $nextBillCycleDate;
        return $this;
    }
    /**
     * Add item to nextBillCycleDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToNextBillCycleDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The nextBillCycleDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nextBillCycleDate[] = $item;
        return $this;
    }
    /**
     * Get startDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * This method is responsible for validating the values passed to the setStartDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartDateForArrayConstraintsFromSetStartDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicStartDateItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicStartDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicStartDateItem) ? get_class($billingAccountSearchRowBasicStartDateItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicStartDateItem), var_export($billingAccountSearchRowBasicStartDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The startDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set startDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $startDate
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setStartDate(array $startDate = array())
    {
        // validation for constraint: array
        if ('' !== ($startDateArrayErrorMessage = self::validateStartDateForArrayConstraintsFromSetStartDate($startDate))) {
            throw new \InvalidArgumentException($startDateArrayErrorMessage, __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Add item to startDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToStartDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The startDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->startDate[] = $item;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiaryForArrayConstraintsFromSetSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchRowBasicSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchRowBasicSubsidiaryItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($billingAccountSearchRowBasicSubsidiaryItem) ? get_class($billingAccountSearchRowBasicSubsidiaryItem) : sprintf('%s(%s)', gettype($billingAccountSearchRowBasicSubsidiaryItem), var_export($billingAccountSearchRowBasicSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setSubsidiary(array $subsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiaryArrayErrorMessage = self::validateSubsidiaryForArrayConstraintsFromSetSubsidiary($subsidiary))) {
            throw new \InvalidArgumentException($subsidiaryArrayErrorMessage, __LINE__);
        }
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Add item to subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function addToSubsidiary(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiary[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\BillingAccountSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
