<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingAccountSearch StructType
 * @subpackage Structs
 */
class BillingAccountSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillingAccountSearchBasic
     */
    public $basic;
    /**
     * The jobJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JobSearchBasic
     */
    public $jobJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for BillingAccountSearch
     * @uses BillingAccountSearch::setBasic()
     * @uses BillingAccountSearch::setJobJoin()
     * @uses BillingAccountSearch::setCustomSearchJoin()
     * @param \StructType\BillingAccountSearchBasic $basic
     * @param \StructType\JobSearchBasic $jobJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\BillingAccountSearchBasic $basic = null, \StructType\JobSearchBasic $jobJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setJobJoin($jobJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\BillingAccountSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\BillingAccountSearchBasic $basic
     * @return \StructType\BillingAccountSearch
     */
    public function setBasic(\StructType\BillingAccountSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get jobJoin value
     * @return \StructType\JobSearchBasic|null
     */
    public function getJobJoin()
    {
        return $this->jobJoin;
    }
    /**
     * Set jobJoin value
     * @param \StructType\JobSearchBasic $jobJoin
     * @return \StructType\BillingAccountSearch
     */
    public function setJobJoin(\StructType\JobSearchBasic $jobJoin = null)
    {
        $this->jobJoin = $jobJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingAccountSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$billingAccountSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($billingAccountSearchCustomSearchJoinItem) ? get_class($billingAccountSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($billingAccountSearchCustomSearchJoinItem), var_export($billingAccountSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\BillingAccountSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\BillingAccountSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
