<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AsyncStatusResult StructType
 * @subpackage Structs
 */
class AsyncStatusResult extends AbstractStructBase
{
    /**
     * The jobId
     * @var string
     */
    public $jobId;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The percentCompleted
     * @var float
     */
    public $percentCompleted;
    /**
     * The estRemainingDuration
     * @var float
     */
    public $estRemainingDuration;
    /**
     * Constructor method for AsyncStatusResult
     * @uses AsyncStatusResult::setJobId()
     * @uses AsyncStatusResult::setStatus()
     * @uses AsyncStatusResult::setPercentCompleted()
     * @uses AsyncStatusResult::setEstRemainingDuration()
     * @param string $jobId
     * @param string $status
     * @param float $percentCompleted
     * @param float $estRemainingDuration
     */
    public function __construct($jobId = null, $status = null, $percentCompleted = null, $estRemainingDuration = null)
    {
        $this
            ->setJobId($jobId)
            ->setStatus($status)
            ->setPercentCompleted($percentCompleted)
            ->setEstRemainingDuration($estRemainingDuration);
    }
    /**
     * Get jobId value
     * @return string|null
     */
    public function getJobId()
    {
        return $this->jobId;
    }
    /**
     * Set jobId value
     * @param string $jobId
     * @return \StructType\AsyncStatusResult
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: string
        if (!is_null($jobId) && !is_string($jobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->jobId = $jobId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\AsyncStatusType::valueIsValid()
     * @uses \EnumType\AsyncStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\AsyncStatusResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AsyncStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AsyncStatusType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\AsyncStatusType::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get percentCompleted value
     * @return float|null
     */
    public function getPercentCompleted()
    {
        return $this->percentCompleted;
    }
    /**
     * Set percentCompleted value
     * @param float $percentCompleted
     * @return \StructType\AsyncStatusResult
     */
    public function setPercentCompleted($percentCompleted = null)
    {
        // validation for constraint: float
        if (!is_null($percentCompleted) && !(is_float($percentCompleted) || is_numeric($percentCompleted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentCompleted, true), gettype($percentCompleted)), __LINE__);
        }
        $this->percentCompleted = $percentCompleted;
        return $this;
    }
    /**
     * Get estRemainingDuration value
     * @return float|null
     */
    public function getEstRemainingDuration()
    {
        return $this->estRemainingDuration;
    }
    /**
     * Set estRemainingDuration value
     * @param float $estRemainingDuration
     * @return \StructType\AsyncStatusResult
     */
    public function setEstRemainingDuration($estRemainingDuration = null)
    {
        // validation for constraint: float
        if (!is_null($estRemainingDuration) && !(is_float($estRemainingDuration) || is_numeric($estRemainingDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estRemainingDuration, true), gettype($estRemainingDuration)), __LINE__);
        }
        $this->estRemainingDuration = $estRemainingDuration;
        return $this;
    }
}
