<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssemblyItemBomSearchRowBasic StructType
 * @subpackage Structs
 */
class AssemblyItemBomSearchRowBasic extends SearchRowBasic
{
    /**
     * The assembly
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $assembly;
    /**
     * The billOfMaterials
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $billOfMaterials;
    /**
     * The default
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $default;
    /**
     * The locations
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $locations;
    /**
     * Constructor method for AssemblyItemBomSearchRowBasic
     * @uses AssemblyItemBomSearchRowBasic::setAssembly()
     * @uses AssemblyItemBomSearchRowBasic::setBillOfMaterials()
     * @uses AssemblyItemBomSearchRowBasic::setDefault()
     * @uses AssemblyItemBomSearchRowBasic::setLocations()
     * @param \StructType\SearchColumnSelectField[] $assembly
     * @param \StructType\SearchColumnSelectField[] $billOfMaterials
     * @param \StructType\SearchColumnBooleanField[] $default
     * @param \StructType\SearchColumnSelectField[] $locations
     */
    public function __construct(array $assembly = array(), array $billOfMaterials = array(), array $default = array(), array $locations = array())
    {
        $this
            ->setAssembly($assembly)
            ->setBillOfMaterials($billOfMaterials)
            ->setDefault($default)
            ->setLocations($locations);
    }
    /**
     * Get assembly value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getAssembly()
    {
        return $this->assembly;
    }
    /**
     * This method is responsible for validating the values passed to the setAssembly method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssembly method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssemblyForArrayConstraintsFromSetAssembly(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assemblyItemBomSearchRowBasicAssemblyItem) {
            // validation for constraint: itemType
            if (!$assemblyItemBomSearchRowBasicAssemblyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($assemblyItemBomSearchRowBasicAssemblyItem) ? get_class($assemblyItemBomSearchRowBasicAssemblyItem) : sprintf('%s(%s)', gettype($assemblyItemBomSearchRowBasicAssemblyItem), var_export($assemblyItemBomSearchRowBasicAssemblyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The assembly property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set assembly value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $assembly
     * @return \StructType\AssemblyItemBomSearchRowBasic
     */
    public function setAssembly(array $assembly = array())
    {
        // validation for constraint: array
        if ('' !== ($assemblyArrayErrorMessage = self::validateAssemblyForArrayConstraintsFromSetAssembly($assembly))) {
            throw new \InvalidArgumentException($assemblyArrayErrorMessage, __LINE__);
        }
        $this->assembly = $assembly;
        return $this;
    }
    /**
     * Add item to assembly value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AssemblyItemBomSearchRowBasic
     */
    public function addToAssembly(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The assembly property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->assembly[] = $item;
        return $this;
    }
    /**
     * Get billOfMaterials value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getBillOfMaterials()
    {
        return $this->billOfMaterials;
    }
    /**
     * This method is responsible for validating the values passed to the setBillOfMaterials method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillOfMaterials method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillOfMaterialsForArrayConstraintsFromSetBillOfMaterials(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assemblyItemBomSearchRowBasicBillOfMaterialsItem) {
            // validation for constraint: itemType
            if (!$assemblyItemBomSearchRowBasicBillOfMaterialsItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($assemblyItemBomSearchRowBasicBillOfMaterialsItem) ? get_class($assemblyItemBomSearchRowBasicBillOfMaterialsItem) : sprintf('%s(%s)', gettype($assemblyItemBomSearchRowBasicBillOfMaterialsItem), var_export($assemblyItemBomSearchRowBasicBillOfMaterialsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The billOfMaterials property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set billOfMaterials value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $billOfMaterials
     * @return \StructType\AssemblyItemBomSearchRowBasic
     */
    public function setBillOfMaterials(array $billOfMaterials = array())
    {
        // validation for constraint: array
        if ('' !== ($billOfMaterialsArrayErrorMessage = self::validateBillOfMaterialsForArrayConstraintsFromSetBillOfMaterials($billOfMaterials))) {
            throw new \InvalidArgumentException($billOfMaterialsArrayErrorMessage, __LINE__);
        }
        $this->billOfMaterials = $billOfMaterials;
        return $this;
    }
    /**
     * Add item to billOfMaterials value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AssemblyItemBomSearchRowBasic
     */
    public function addToBillOfMaterials(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The billOfMaterials property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->billOfMaterials[] = $item;
        return $this;
    }
    /**
     * Get default value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getDefault()
    {
        return $this->default;
    }
    /**
     * This method is responsible for validating the values passed to the setDefault method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefault method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDefaultForArrayConstraintsFromSetDefault(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assemblyItemBomSearchRowBasicDefaultItem) {
            // validation for constraint: itemType
            if (!$assemblyItemBomSearchRowBasicDefaultItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($assemblyItemBomSearchRowBasicDefaultItem) ? get_class($assemblyItemBomSearchRowBasicDefaultItem) : sprintf('%s(%s)', gettype($assemblyItemBomSearchRowBasicDefaultItem), var_export($assemblyItemBomSearchRowBasicDefaultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The default property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set default value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $default
     * @return \StructType\AssemblyItemBomSearchRowBasic
     */
    public function setDefault(array $default = array())
    {
        // validation for constraint: array
        if ('' !== ($defaultArrayErrorMessage = self::validateDefaultForArrayConstraintsFromSetDefault($default))) {
            throw new \InvalidArgumentException($defaultArrayErrorMessage, __LINE__);
        }
        $this->default = $default;
        return $this;
    }
    /**
     * Add item to default value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\AssemblyItemBomSearchRowBasic
     */
    public function addToDefault(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The default property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->default[] = $item;
        return $this;
    }
    /**
     * Get locations value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getLocations()
    {
        return $this->locations;
    }
    /**
     * This method is responsible for validating the values passed to the setLocations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationsForArrayConstraintsFromSetLocations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assemblyItemBomSearchRowBasicLocationsItem) {
            // validation for constraint: itemType
            if (!$assemblyItemBomSearchRowBasicLocationsItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($assemblyItemBomSearchRowBasicLocationsItem) ? get_class($assemblyItemBomSearchRowBasicLocationsItem) : sprintf('%s(%s)', gettype($assemblyItemBomSearchRowBasicLocationsItem), var_export($assemblyItemBomSearchRowBasicLocationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The locations property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set locations value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $locations
     * @return \StructType\AssemblyItemBomSearchRowBasic
     */
    public function setLocations(array $locations = array())
    {
        // validation for constraint: array
        if ('' !== ($locationsArrayErrorMessage = self::validateLocationsForArrayConstraintsFromSetLocations($locations))) {
            throw new \InvalidArgumentException($locationsArrayErrorMessage, __LINE__);
        }
        $this->locations = $locations;
        return $this;
    }
    /**
     * Add item to locations value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AssemblyItemBomSearchRowBasic
     */
    public function addToLocations(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The locations property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->locations[] = $item;
        return $this;
    }
}
