<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssemblyBuild StructType
 * @subpackage Structs
 */
class AssemblyBuild extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The buildable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $buildable;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The billOfMaterials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billOfMaterials;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The binNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $binNumbers;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The revision
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revision;
    /**
     * The billOfMaterialsRevision
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billOfMaterialsRevision;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The componentList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AssemblyComponentList
     */
    public $componentList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for AssemblyBuild
     * @uses AssemblyBuild::setCreatedDate()
     * @uses AssemblyBuild::setExpirationDate()
     * @uses AssemblyBuild::setLastModifiedDate()
     * @uses AssemblyBuild::setCustomForm()
     * @uses AssemblyBuild::setCreatedFrom()
     * @uses AssemblyBuild::setTranDate()
     * @uses AssemblyBuild::setPostingPeriod()
     * @uses AssemblyBuild::setTranId()
     * @uses AssemblyBuild::setItem()
     * @uses AssemblyBuild::setBuildable()
     * @uses AssemblyBuild::setQuantity()
     * @uses AssemblyBuild::setUnits()
     * @uses AssemblyBuild::setTotal()
     * @uses AssemblyBuild::setBillOfMaterials()
     * @uses AssemblyBuild::setInventoryDetail()
     * @uses AssemblyBuild::setSerialNumbers()
     * @uses AssemblyBuild::setBinNumbers()
     * @uses AssemblyBuild::setSubsidiary()
     * @uses AssemblyBuild::setDepartment()
     * @uses AssemblyBuild::setClass()
     * @uses AssemblyBuild::setLocation()
     * @uses AssemblyBuild::setRevision()
     * @uses AssemblyBuild::setBillOfMaterialsRevision()
     * @uses AssemblyBuild::setMemo()
     * @uses AssemblyBuild::setComponentList()
     * @uses AssemblyBuild::setAccountingBookDetailList()
     * @uses AssemblyBuild::setCustomFieldList()
     * @uses AssemblyBuild::setInternalId()
     * @uses AssemblyBuild::setExternalId()
     * @param string $createdDate
     * @param string $expirationDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $createdFrom
     * @param string $tranDate
     * @param \StructType\RecordRef $postingPeriod
     * @param string $tranId
     * @param \StructType\RecordRef $item
     * @param float $buildable
     * @param float $quantity
     * @param \StructType\RecordRef $units
     * @param float $total
     * @param \StructType\RecordRef $billOfMaterials
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $serialNumbers
     * @param string $binNumbers
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $revision
     * @param \StructType\RecordRef $billOfMaterialsRevision
     * @param string $memo
     * @param \StructType\AssemblyComponentList $componentList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $expirationDate = null, $lastModifiedDate = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $createdFrom = null, $tranDate = null, \StructType\RecordRef $postingPeriod = null, $tranId = null, \StructType\RecordRef $item = null, $buildable = null, $quantity = null, \StructType\RecordRef $units = null, $total = null, \StructType\RecordRef $billOfMaterials = null, \StructType\InventoryDetail $inventoryDetail = null, $serialNumbers = null, $binNumbers = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $revision = null, \StructType\RecordRef $billOfMaterialsRevision = null, $memo = null, \StructType\AssemblyComponentList $componentList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setExpirationDate($expirationDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomForm($customForm)
            ->setCreatedFrom($createdFrom)
            ->setTranDate($tranDate)
            ->setPostingPeriod($postingPeriod)
            ->setTranId($tranId)
            ->setItem($item)
            ->setBuildable($buildable)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setTotal($total)
            ->setBillOfMaterials($billOfMaterials)
            ->setInventoryDetail($inventoryDetail)
            ->setSerialNumbers($serialNumbers)
            ->setBinNumbers($binNumbers)
            ->setSubsidiary($subsidiary)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setRevision($revision)
            ->setBillOfMaterialsRevision($billOfMaterialsRevision)
            ->setMemo($memo)
            ->setComponentList($componentList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\AssemblyBuild
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\AssemblyBuild
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\AssemblyBuild
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\AssemblyBuild
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\AssemblyBuild
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\AssemblyBuild
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\AssemblyBuild
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\AssemblyBuild
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\AssemblyBuild
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get buildable value
     * @return float|null
     */
    public function getBuildable()
    {
        return $this->buildable;
    }
    /**
     * Set buildable value
     * @param float $buildable
     * @return \StructType\AssemblyBuild
     */
    public function setBuildable($buildable = null)
    {
        // validation for constraint: float
        if (!is_null($buildable) && !(is_float($buildable) || is_numeric($buildable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($buildable, true), gettype($buildable)), __LINE__);
        }
        $this->buildable = $buildable;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\AssemblyBuild
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\AssemblyBuild
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\AssemblyBuild
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get billOfMaterials value
     * @return \StructType\RecordRef|null
     */
    public function getBillOfMaterials()
    {
        return $this->billOfMaterials;
    }
    /**
     * Set billOfMaterials value
     * @param \StructType\RecordRef $billOfMaterials
     * @return \StructType\AssemblyBuild
     */
    public function setBillOfMaterials(\StructType\RecordRef $billOfMaterials = null)
    {
        $this->billOfMaterials = $billOfMaterials;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\AssemblyBuild
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\AssemblyBuild
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get binNumbers value
     * @return string|null
     */
    public function getBinNumbers()
    {
        return $this->binNumbers;
    }
    /**
     * Set binNumbers value
     * @param string $binNumbers
     * @return \StructType\AssemblyBuild
     */
    public function setBinNumbers($binNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($binNumbers) && !is_string($binNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binNumbers, true), gettype($binNumbers)), __LINE__);
        }
        $this->binNumbers = $binNumbers;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\AssemblyBuild
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\AssemblyBuild
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\AssemblyBuild
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\AssemblyBuild
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get revision value
     * @return \StructType\RecordRef|null
     */
    public function getRevision()
    {
        return $this->revision;
    }
    /**
     * Set revision value
     * @param \StructType\RecordRef $revision
     * @return \StructType\AssemblyBuild
     */
    public function setRevision(\StructType\RecordRef $revision = null)
    {
        $this->revision = $revision;
        return $this;
    }
    /**
     * Get billOfMaterialsRevision value
     * @return \StructType\RecordRef|null
     */
    public function getBillOfMaterialsRevision()
    {
        return $this->billOfMaterialsRevision;
    }
    /**
     * Set billOfMaterialsRevision value
     * @param \StructType\RecordRef $billOfMaterialsRevision
     * @return \StructType\AssemblyBuild
     */
    public function setBillOfMaterialsRevision(\StructType\RecordRef $billOfMaterialsRevision = null)
    {
        $this->billOfMaterialsRevision = $billOfMaterialsRevision;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\AssemblyBuild
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get componentList value
     * @return \StructType\AssemblyComponentList|null
     */
    public function getComponentList()
    {
        return $this->componentList;
    }
    /**
     * Set componentList value
     * @param \StructType\AssemblyComponentList $componentList
     * @return \StructType\AssemblyBuild
     */
    public function setComponentList(\StructType\AssemblyComponentList $componentList = null)
    {
        $this->componentList = $componentList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\AssemblyBuild
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\AssemblyBuild
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\AssemblyBuild
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\AssemblyBuild
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
