<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationInfo StructType
 * @subpackage Structs
 */
class ApplicationInfo extends AbstractStructBase
{
    /**
     * The applicationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $applicationId;
    /**
     * Constructor method for ApplicationInfo
     * @uses ApplicationInfo::setApplicationId()
     * @param string $applicationId
     */
    public function __construct($applicationId = null)
    {
        $this
            ->setApplicationId($applicationId);
    }
    /**
     * Get applicationId value
     * @return string
     */
    public function getApplicationId()
    {
        return $this->applicationId;
    }
    /**
     * Set applicationId value
     * @param string $applicationId
     * @return \StructType\ApplicationInfo
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        $this->applicationId = $applicationId;
        return $this;
    }
}
