<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends Record
{
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $internalId;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The attention
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $attention;
    /**
     * The addressee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressee;
    /**
     * The addrPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addrPhone;
    /**
     * The addr1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addr1;
    /**
     * The addr2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addr2;
    /**
     * The addr3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addr3;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zip;
    /**
     * The addrText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addrText;
    /**
     * The override
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $override;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for Address
     * @uses Address::setInternalId()
     * @uses Address::setCountry()
     * @uses Address::setAttention()
     * @uses Address::setAddressee()
     * @uses Address::setAddrPhone()
     * @uses Address::setAddr1()
     * @uses Address::setAddr2()
     * @uses Address::setAddr3()
     * @uses Address::setCity()
     * @uses Address::setState()
     * @uses Address::setZip()
     * @uses Address::setAddrText()
     * @uses Address::setOverride()
     * @uses Address::setCustomFieldList()
     * @param string $internalId
     * @param string $country
     * @param string $attention
     * @param string $addressee
     * @param string $addrPhone
     * @param string $addr1
     * @param string $addr2
     * @param string $addr3
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $addrText
     * @param bool $override
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct($internalId = null, $country = null, $attention = null, $addressee = null, $addrPhone = null, $addr1 = null, $addr2 = null, $addr3 = null, $city = null, $state = null, $zip = null, $addrText = null, $override = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setInternalId($internalId)
            ->setCountry($country)
            ->setAttention($attention)
            ->setAddressee($addressee)
            ->setAddrPhone($addrPhone)
            ->setAddr1($addr1)
            ->setAddr2($addr2)
            ->setAddr3($addr3)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setAddrText($addrText)
            ->setOverride($override)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Address
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @uses \EnumType\Country::valueIsValid()
     * @uses \EnumType\Country::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\Address
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Country::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Country', is_array($country) ? implode(', ', $country) : var_export($country, true), implode(', ', \EnumType\Country::getValidValues())), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get attention value
     * @return string|null
     */
    public function getAttention()
    {
        return $this->attention;
    }
    /**
     * Set attention value
     * @param string $attention
     * @return \StructType\Address
     */
    public function setAttention($attention = null)
    {
        // validation for constraint: string
        if (!is_null($attention) && !is_string($attention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attention, true), gettype($attention)), __LINE__);
        }
        $this->attention = $attention;
        return $this;
    }
    /**
     * Get addressee value
     * @return string|null
     */
    public function getAddressee()
    {
        return $this->addressee;
    }
    /**
     * Set addressee value
     * @param string $addressee
     * @return \StructType\Address
     */
    public function setAddressee($addressee = null)
    {
        // validation for constraint: string
        if (!is_null($addressee) && !is_string($addressee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressee, true), gettype($addressee)), __LINE__);
        }
        $this->addressee = $addressee;
        return $this;
    }
    /**
     * Get addrPhone value
     * @return string|null
     */
    public function getAddrPhone()
    {
        return $this->addrPhone;
    }
    /**
     * Set addrPhone value
     * @param string $addrPhone
     * @return \StructType\Address
     */
    public function setAddrPhone($addrPhone = null)
    {
        // validation for constraint: string
        if (!is_null($addrPhone) && !is_string($addrPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addrPhone, true), gettype($addrPhone)), __LINE__);
        }
        $this->addrPhone = $addrPhone;
        return $this;
    }
    /**
     * Get addr1 value
     * @return string|null
     */
    public function getAddr1()
    {
        return $this->addr1;
    }
    /**
     * Set addr1 value
     * @param string $addr1
     * @return \StructType\Address
     */
    public function setAddr1($addr1 = null)
    {
        // validation for constraint: string
        if (!is_null($addr1) && !is_string($addr1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addr1, true), gettype($addr1)), __LINE__);
        }
        $this->addr1 = $addr1;
        return $this;
    }
    /**
     * Get addr2 value
     * @return string|null
     */
    public function getAddr2()
    {
        return $this->addr2;
    }
    /**
     * Set addr2 value
     * @param string $addr2
     * @return \StructType\Address
     */
    public function setAddr2($addr2 = null)
    {
        // validation for constraint: string
        if (!is_null($addr2) && !is_string($addr2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addr2, true), gettype($addr2)), __LINE__);
        }
        $this->addr2 = $addr2;
        return $this;
    }
    /**
     * Get addr3 value
     * @return string|null
     */
    public function getAddr3()
    {
        return $this->addr3;
    }
    /**
     * Set addr3 value
     * @param string $addr3
     * @return \StructType\Address
     */
    public function setAddr3($addr3 = null)
    {
        // validation for constraint: string
        if (!is_null($addr3) && !is_string($addr3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addr3, true), gettype($addr3)), __LINE__);
        }
        $this->addr3 = $addr3;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\Address
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\Address
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get addrText value
     * @return string|null
     */
    public function getAddrText()
    {
        return $this->addrText;
    }
    /**
     * Set addrText value
     * @param string $addrText
     * @return \StructType\Address
     */
    public function setAddrText($addrText = null)
    {
        // validation for constraint: string
        if (!is_null($addrText) && !is_string($addrText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addrText, true), gettype($addrText)), __LINE__);
        }
        $this->addrText = $addrText;
        return $this;
    }
    /**
     * Get override value
     * @return bool|null
     */
    public function getOverride()
    {
        return $this->override;
    }
    /**
     * Set override value
     * @param bool $override
     * @return \StructType\Address
     */
    public function setOverride($override = null)
    {
        // validation for constraint: boolean
        if (!is_null($override) && !is_bool($override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($override, true), gettype($override)), __LINE__);
        }
        $this->override = $override;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Address
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
