<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountingPeriod StructType
 * @subpackage Structs
 */
class AccountingPeriod extends Record
{
    /**
     * The periodName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $periodName;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The fiscalCalendar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $fiscalCalendar;
    /**
     * The closedOnDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $closedOnDate;
    /**
     * The isAdjust
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isAdjust;
    /**
     * The fiscalCalendarsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingPeriodFiscalCalendarsList
     */
    public $fiscalCalendarsList;
    /**
     * The isQuarter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isQuarter;
    /**
     * The isYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isYear;
    /**
     * The closed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $closed;
    /**
     * The apLocked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $apLocked;
    /**
     * The arLocked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $arLocked;
    /**
     * The payrollLocked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $payrollLocked;
    /**
     * The allLocked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allLocked;
    /**
     * The allowNonGLChanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowNonGLChanges;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * Constructor method for AccountingPeriod
     * @uses AccountingPeriod::setPeriodName()
     * @uses AccountingPeriod::setParent()
     * @uses AccountingPeriod::setStartDate()
     * @uses AccountingPeriod::setEndDate()
     * @uses AccountingPeriod::setFiscalCalendar()
     * @uses AccountingPeriod::setClosedOnDate()
     * @uses AccountingPeriod::setIsAdjust()
     * @uses AccountingPeriod::setFiscalCalendarsList()
     * @uses AccountingPeriod::setIsQuarter()
     * @uses AccountingPeriod::setIsYear()
     * @uses AccountingPeriod::setClosed()
     * @uses AccountingPeriod::setApLocked()
     * @uses AccountingPeriod::setArLocked()
     * @uses AccountingPeriod::setPayrollLocked()
     * @uses AccountingPeriod::setAllLocked()
     * @uses AccountingPeriod::setAllowNonGLChanges()
     * @uses AccountingPeriod::setInternalId()
     * @param string $periodName
     * @param \StructType\RecordRef $parent
     * @param string $startDate
     * @param string $endDate
     * @param \StructType\RecordRef $fiscalCalendar
     * @param string $closedOnDate
     * @param bool $isAdjust
     * @param \StructType\AccountingPeriodFiscalCalendarsList $fiscalCalendarsList
     * @param bool $isQuarter
     * @param bool $isYear
     * @param bool $closed
     * @param bool $apLocked
     * @param bool $arLocked
     * @param bool $payrollLocked
     * @param bool $allLocked
     * @param bool $allowNonGLChanges
     * @param string $internalId
     */
    public function __construct($periodName = null, \StructType\RecordRef $parent = null, $startDate = null, $endDate = null, \StructType\RecordRef $fiscalCalendar = null, $closedOnDate = null, $isAdjust = null, \StructType\AccountingPeriodFiscalCalendarsList $fiscalCalendarsList = null, $isQuarter = null, $isYear = null, $closed = null, $apLocked = null, $arLocked = null, $payrollLocked = null, $allLocked = null, $allowNonGLChanges = null, $internalId = null)
    {
        $this
            ->setPeriodName($periodName)
            ->setParent($parent)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setFiscalCalendar($fiscalCalendar)
            ->setClosedOnDate($closedOnDate)
            ->setIsAdjust($isAdjust)
            ->setFiscalCalendarsList($fiscalCalendarsList)
            ->setIsQuarter($isQuarter)
            ->setIsYear($isYear)
            ->setClosed($closed)
            ->setApLocked($apLocked)
            ->setArLocked($arLocked)
            ->setPayrollLocked($payrollLocked)
            ->setAllLocked($allLocked)
            ->setAllowNonGLChanges($allowNonGLChanges)
            ->setInternalId($internalId);
    }
    /**
     * Get periodName value
     * @return string|null
     */
    public function getPeriodName()
    {
        return $this->periodName;
    }
    /**
     * Set periodName value
     * @param string $periodName
     * @return \StructType\AccountingPeriod
     */
    public function setPeriodName($periodName = null)
    {
        // validation for constraint: string
        if (!is_null($periodName) && !is_string($periodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodName, true), gettype($periodName)), __LINE__);
        }
        $this->periodName = $periodName;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\AccountingPeriod
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\AccountingPeriod
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\AccountingPeriod
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get fiscalCalendar value
     * @return \StructType\RecordRef|null
     */
    public function getFiscalCalendar()
    {
        return $this->fiscalCalendar;
    }
    /**
     * Set fiscalCalendar value
     * @param \StructType\RecordRef $fiscalCalendar
     * @return \StructType\AccountingPeriod
     */
    public function setFiscalCalendar(\StructType\RecordRef $fiscalCalendar = null)
    {
        $this->fiscalCalendar = $fiscalCalendar;
        return $this;
    }
    /**
     * Get closedOnDate value
     * @return string|null
     */
    public function getClosedOnDate()
    {
        return $this->closedOnDate;
    }
    /**
     * Set closedOnDate value
     * @param string $closedOnDate
     * @return \StructType\AccountingPeriod
     */
    public function setClosedOnDate($closedOnDate = null)
    {
        // validation for constraint: string
        if (!is_null($closedOnDate) && !is_string($closedOnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closedOnDate, true), gettype($closedOnDate)), __LINE__);
        }
        $this->closedOnDate = $closedOnDate;
        return $this;
    }
    /**
     * Get isAdjust value
     * @return bool|null
     */
    public function getIsAdjust()
    {
        return $this->isAdjust;
    }
    /**
     * Set isAdjust value
     * @param bool $isAdjust
     * @return \StructType\AccountingPeriod
     */
    public function setIsAdjust($isAdjust = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAdjust) && !is_bool($isAdjust)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAdjust, true), gettype($isAdjust)), __LINE__);
        }
        $this->isAdjust = $isAdjust;
        return $this;
    }
    /**
     * Get fiscalCalendarsList value
     * @return \StructType\AccountingPeriodFiscalCalendarsList|null
     */
    public function getFiscalCalendarsList()
    {
        return $this->fiscalCalendarsList;
    }
    /**
     * Set fiscalCalendarsList value
     * @param \StructType\AccountingPeriodFiscalCalendarsList $fiscalCalendarsList
     * @return \StructType\AccountingPeriod
     */
    public function setFiscalCalendarsList(\StructType\AccountingPeriodFiscalCalendarsList $fiscalCalendarsList = null)
    {
        $this->fiscalCalendarsList = $fiscalCalendarsList;
        return $this;
    }
    /**
     * Get isQuarter value
     * @return bool|null
     */
    public function getIsQuarter()
    {
        return $this->isQuarter;
    }
    /**
     * Set isQuarter value
     * @param bool $isQuarter
     * @return \StructType\AccountingPeriod
     */
    public function setIsQuarter($isQuarter = null)
    {
        // validation for constraint: boolean
        if (!is_null($isQuarter) && !is_bool($isQuarter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isQuarter, true), gettype($isQuarter)), __LINE__);
        }
        $this->isQuarter = $isQuarter;
        return $this;
    }
    /**
     * Get isYear value
     * @return bool|null
     */
    public function getIsYear()
    {
        return $this->isYear;
    }
    /**
     * Set isYear value
     * @param bool $isYear
     * @return \StructType\AccountingPeriod
     */
    public function setIsYear($isYear = null)
    {
        // validation for constraint: boolean
        if (!is_null($isYear) && !is_bool($isYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isYear, true), gettype($isYear)), __LINE__);
        }
        $this->isYear = $isYear;
        return $this;
    }
    /**
     * Get closed value
     * @return bool|null
     */
    public function getClosed()
    {
        return $this->closed;
    }
    /**
     * Set closed value
     * @param bool $closed
     * @return \StructType\AccountingPeriod
     */
    public function setClosed($closed = null)
    {
        // validation for constraint: boolean
        if (!is_null($closed) && !is_bool($closed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($closed, true), gettype($closed)), __LINE__);
        }
        $this->closed = $closed;
        return $this;
    }
    /**
     * Get apLocked value
     * @return bool|null
     */
    public function getApLocked()
    {
        return $this->apLocked;
    }
    /**
     * Set apLocked value
     * @param bool $apLocked
     * @return \StructType\AccountingPeriod
     */
    public function setApLocked($apLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($apLocked) && !is_bool($apLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($apLocked, true), gettype($apLocked)), __LINE__);
        }
        $this->apLocked = $apLocked;
        return $this;
    }
    /**
     * Get arLocked value
     * @return bool|null
     */
    public function getArLocked()
    {
        return $this->arLocked;
    }
    /**
     * Set arLocked value
     * @param bool $arLocked
     * @return \StructType\AccountingPeriod
     */
    public function setArLocked($arLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($arLocked) && !is_bool($arLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($arLocked, true), gettype($arLocked)), __LINE__);
        }
        $this->arLocked = $arLocked;
        return $this;
    }
    /**
     * Get payrollLocked value
     * @return bool|null
     */
    public function getPayrollLocked()
    {
        return $this->payrollLocked;
    }
    /**
     * Set payrollLocked value
     * @param bool $payrollLocked
     * @return \StructType\AccountingPeriod
     */
    public function setPayrollLocked($payrollLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($payrollLocked) && !is_bool($payrollLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payrollLocked, true), gettype($payrollLocked)), __LINE__);
        }
        $this->payrollLocked = $payrollLocked;
        return $this;
    }
    /**
     * Get allLocked value
     * @return bool|null
     */
    public function getAllLocked()
    {
        return $this->allLocked;
    }
    /**
     * Set allLocked value
     * @param bool $allLocked
     * @return \StructType\AccountingPeriod
     */
    public function setAllLocked($allLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($allLocked) && !is_bool($allLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allLocked, true), gettype($allLocked)), __LINE__);
        }
        $this->allLocked = $allLocked;
        return $this;
    }
    /**
     * Get allowNonGLChanges value
     * @return bool|null
     */
    public function getAllowNonGLChanges()
    {
        return $this->allowNonGLChanges;
    }
    /**
     * Set allowNonGLChanges value
     * @param bool $allowNonGLChanges
     * @return \StructType\AccountingPeriod
     */
    public function setAllowNonGLChanges($allowNonGLChanges = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowNonGLChanges) && !is_bool($allowNonGLChanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowNonGLChanges, true), gettype($allowNonGLChanges)), __LINE__);
        }
        $this->allowNonGLChanges = $allowNonGLChanges;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\AccountingPeriod
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
}
