<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountingBookDetailList StructType
 * @subpackage Structs
 */
class AccountingBookDetailList extends AbstractStructBase
{
    /**
     * The accountingBookDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetail[]
     */
    public $accountingBookDetail;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for AccountingBookDetailList
     * @uses AccountingBookDetailList::setAccountingBookDetail()
     * @uses AccountingBookDetailList::setReplaceAll()
     * @param \StructType\AccountingBookDetail[] $accountingBookDetail
     * @param bool $replaceAll
     */
    public function __construct(array $accountingBookDetail = array(), $replaceAll = true)
    {
        $this
            ->setAccountingBookDetail($accountingBookDetail)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get accountingBookDetail value
     * @return \StructType\AccountingBookDetail[]|null
     */
    public function getAccountingBookDetail()
    {
        return $this->accountingBookDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountingBookDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountingBookDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountingBookDetailForArrayConstraintsFromSetAccountingBookDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingBookDetailListAccountingBookDetailItem) {
            // validation for constraint: itemType
            if (!$accountingBookDetailListAccountingBookDetailItem instanceof \StructType\AccountingBookDetail) {
                $invalidValues[] = is_object($accountingBookDetailListAccountingBookDetailItem) ? get_class($accountingBookDetailListAccountingBookDetailItem) : sprintf('%s(%s)', gettype($accountingBookDetailListAccountingBookDetailItem), var_export($accountingBookDetailListAccountingBookDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The accountingBookDetail property can only contain items of type \StructType\AccountingBookDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set accountingBookDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountingBookDetail[] $accountingBookDetail
     * @return \StructType\AccountingBookDetailList
     */
    public function setAccountingBookDetail(array $accountingBookDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($accountingBookDetailArrayErrorMessage = self::validateAccountingBookDetailForArrayConstraintsFromSetAccountingBookDetail($accountingBookDetail))) {
            throw new \InvalidArgumentException($accountingBookDetailArrayErrorMessage, __LINE__);
        }
        $this->accountingBookDetail = $accountingBookDetail;
        return $this;
    }
    /**
     * Add item to accountingBookDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountingBookDetail $item
     * @return \StructType\AccountingBookDetailList
     */
    public function addToAccountingBookDetail(\StructType\AccountingBookDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountingBookDetail) {
            throw new \InvalidArgumentException(sprintf('The accountingBookDetail property can only contain items of type \StructType\AccountingBookDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->accountingBookDetail[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\AccountingBookDetailList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
