<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountLocalizations StructType
 * @subpackage Structs
 */
class AccountLocalizations extends AbstractStructBase
{
    /**
     * The accountingContext
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $accountingContext;
    /**
     * The acctNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $acctNumber;
    /**
     * The acctName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $acctName;
    /**
     * The legalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $legalName;
    /**
     * The locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locale;
    /**
     * Constructor method for AccountLocalizations
     * @uses AccountLocalizations::setAccountingContext()
     * @uses AccountLocalizations::setAcctNumber()
     * @uses AccountLocalizations::setAcctName()
     * @uses AccountLocalizations::setLegalName()
     * @uses AccountLocalizations::setLocale()
     * @param \StructType\RecordRef $accountingContext
     * @param string $acctNumber
     * @param string $acctName
     * @param string $legalName
     * @param string $locale
     */
    public function __construct(\StructType\RecordRef $accountingContext = null, $acctNumber = null, $acctName = null, $legalName = null, $locale = null)
    {
        $this
            ->setAccountingContext($accountingContext)
            ->setAcctNumber($acctNumber)
            ->setAcctName($acctName)
            ->setLegalName($legalName)
            ->setLocale($locale);
    }
    /**
     * Get accountingContext value
     * @return \StructType\RecordRef|null
     */
    public function getAccountingContext()
    {
        return $this->accountingContext;
    }
    /**
     * Set accountingContext value
     * @param \StructType\RecordRef $accountingContext
     * @return \StructType\AccountLocalizations
     */
    public function setAccountingContext(\StructType\RecordRef $accountingContext = null)
    {
        $this->accountingContext = $accountingContext;
        return $this;
    }
    /**
     * Get acctNumber value
     * @return string|null
     */
    public function getAcctNumber()
    {
        return $this->acctNumber;
    }
    /**
     * Set acctNumber value
     * @param string $acctNumber
     * @return \StructType\AccountLocalizations
     */
    public function setAcctNumber($acctNumber = null)
    {
        // validation for constraint: string
        if (!is_null($acctNumber) && !is_string($acctNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acctNumber, true), gettype($acctNumber)), __LINE__);
        }
        $this->acctNumber = $acctNumber;
        return $this;
    }
    /**
     * Get acctName value
     * @return string|null
     */
    public function getAcctName()
    {
        return $this->acctName;
    }
    /**
     * Set acctName value
     * @param string $acctName
     * @return \StructType\AccountLocalizations
     */
    public function setAcctName($acctName = null)
    {
        // validation for constraint: string
        if (!is_null($acctName) && !is_string($acctName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acctName, true), gettype($acctName)), __LINE__);
        }
        $this->acctName = $acctName;
        return $this;
    }
    /**
     * Get legalName value
     * @return string|null
     */
    public function getLegalName()
    {
        return $this->legalName;
    }
    /**
     * Set legalName value
     * @param string $legalName
     * @return \StructType\AccountLocalizations
     */
    public function setLegalName($legalName = null)
    {
        // validation for constraint: string
        if (!is_null($legalName) && !is_string($legalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legalName, true), gettype($legalName)), __LINE__);
        }
        $this->legalName = $legalName;
        return $this;
    }
    /**
     * Get locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locale
     * @return \StructType\AccountLocalizations
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($locale) ? implode(', ', $locale) : var_export($locale, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->locale = $locale;
        return $this;
    }
}
