<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upsert ServiceType
 * @subpackage Services
 */
class Upsert extends AbstractSoapClientBase
{
    /**
     * Sets the Passport SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Passport $passport
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPassport(\StructType\Passport $passport, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'passport', $passport, $mustUnderstand, $actor);
    }
    /**
     * Sets the TokenPassport SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\TokenPassport $tokenPassport
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTokenPassport(\StructType\TokenPassport $tokenPassport, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'tokenPassport', $tokenPassport, $mustUnderstand, $actor);
    }
    /**
     * Sets the ApplicationInfo SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApplicationInfo $applicationInfo
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationInfo(\StructType\ApplicationInfo $applicationInfo, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'applicationInfo', $applicationInfo, $mustUnderstand, $actor);
    }
    /**
     * Sets the PartnerInfo SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\PartnerInfo $partnerInfo
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPartnerInfo(\StructType\PartnerInfo $partnerInfo, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'partnerInfo', $partnerInfo, $mustUnderstand, $actor);
    }
    /**
     * Sets the Preferences SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Preferences $preferences
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPreferences(\StructType\Preferences $preferences, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'preferences', $preferences, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named upsert
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpsertRequest $parameters
     * @return \StructType\UpsertResponse|bool
     */
    public function upsert(\StructType\UpsertRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->upsert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named upsertList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpsertListRequest $parameters
     * @return \StructType\UpsertListResponse|bool
     */
    public function upsertList(\StructType\UpsertListRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->upsertList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpsertListResponse|\StructType\UpsertResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
