<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Passport SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Passport $passport
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPassport(\StructType\Passport $passport, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'passport', $passport, $mustUnderstand, $actor);
    }
    /**
     * Sets the TokenPassport SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\TokenPassport $tokenPassport
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTokenPassport(\StructType\TokenPassport $tokenPassport, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'tokenPassport', $tokenPassport, $mustUnderstand, $actor);
    }
    /**
     * Sets the ApplicationInfo SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApplicationInfo $applicationInfo
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationInfo(\StructType\ApplicationInfo $applicationInfo, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'applicationInfo', $applicationInfo, $mustUnderstand, $actor);
    }
    /**
     * Sets the PartnerInfo SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\PartnerInfo $partnerInfo
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPartnerInfo(\StructType\PartnerInfo $partnerInfo, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'partnerInfo', $partnerInfo, $mustUnderstand, $actor);
    }
    /**
     * Sets the Preferences SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Preferences $preferences
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPreferences(\StructType\Preferences $preferences, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'preferences', $preferences, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named get
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRequest $parameters
     * @return \StructType\GetResponse|bool
     */
    public function get(\StructType\GetRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListRequest $parameters
     * @return \StructType\GetListResponse|bool
     */
    public function getList(\StructType\GetListRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAll
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllRequest $parameters
     * @return \StructType\GetAllResponse|bool
     */
    public function getAll(\StructType\GetAllRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSavedSearch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSavedSearchRequest $parameters
     * @return \StructType\GetSavedSearchResponse|bool
     */
    public function getSavedSearch(\StructType\GetSavedSearchRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSavedSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomizationId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomizationIdRequest $parameters
     * @return \StructType\GetCustomizationIdResponse|bool
     */
    public function getCustomizationId(\StructType\GetCustomizationIdRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCustomizationId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSelectValue
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSelectValueRequest $parameters
     * @return \StructType\GetSelectValueResponse|bool
     */
    public function getSelectValue(\StructType\GetSelectValueRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSelectValue($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getItemAvailability
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemAvailabilityRequest $parameters
     * @return \StructType\GetItemAvailabilityResponse|bool
     */
    public function getItemAvailability(\StructType\GetItemAvailabilityRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getItemAvailability($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBudgetExchangeRate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBudgetExchangeRateRequest $parameters
     * @return \StructType\GetBudgetExchangeRateResponse|bool
     */
    public function getBudgetExchangeRate(\StructType\GetBudgetExchangeRateRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBudgetExchangeRate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCurrencyRate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCurrencyRateRequest $parameters
     * @return \StructType\GetCurrencyRateResponse|bool
     */
    public function getCurrencyRate(\StructType\GetCurrencyRateRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCurrencyRate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDataCenterUrls
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDataCenterUrlsRequest $parameters
     * @return \StructType\GetDataCenterUrlsResponse|bool
     */
    public function getDataCenterUrls(\StructType\GetDataCenterUrlsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDataCenterUrls($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPostingTransactionSummary
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPostingTransactionSummaryRequest $parameters
     * @return \StructType\GetPostingTransactionSummaryResponse|bool
     */
    public function getPostingTransactionSummary(\StructType\GetPostingTransactionSummaryRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPostingTransactionSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServerTime
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo
     * - SOAPHeaders: required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServerTimeRequest $parameters
     * @return \StructType\GetServerTimeResponse|bool
     */
    public function getServerTime(\StructType\GetServerTimeRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getServerTime($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAsyncResult
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAsyncResultRequest $parameters
     * @return \StructType\GetAsyncResultResponse|bool
     */
    public function getAsyncResult(\StructType\GetAsyncResultRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAsyncResult($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeleted
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedRequest $parameters
     * @return \StructType\GetDeletedResponse|bool
     */
    public function getDeleted(\StructType\GetDeletedRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeleted($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountGovernanceInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo
     * - SOAPHeaders: required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountGovernanceInfoRequest $parameters
     * @return \StructType\GetAccountGovernanceInfoResponse|bool
     */
    public function getAccountGovernanceInfo(\StructType\GetAccountGovernanceInfoRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccountGovernanceInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIntegrationGovernanceInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo
     * - SOAPHeaders: required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIntegrationGovernanceInfoRequest $parameters
     * @return \StructType\GetIntegrationGovernanceInfoResponse|bool
     */
    public function getIntegrationGovernanceInfo(\StructType\GetIntegrationGovernanceInfoRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getIntegrationGovernanceInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountGovernanceInfoResponse|\StructType\GetAllResponse|\StructType\GetAsyncResultResponse|\StructType\GetBudgetExchangeRateResponse|\StructType\GetCurrencyRateResponse|\StructType\GetCustomizationIdResponse|\StructType\GetDataCenterUrlsResponse|\StructType\GetDeletedResponse|\StructType\GetIntegrationGovernanceInfoResponse|\StructType\GetItemAvailabilityResponse|\StructType\GetListResponse|\StructType\GetPostingTransactionSummaryResponse|\StructType\GetResponse|\StructType\GetSavedSearchResponse|\StructType\GetSelectValueResponse|\StructType\GetServerTimeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
