<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Sets the Passport SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Passport $passport
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPassport(\StructType\Passport $passport, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'passport', $passport, $mustUnderstand, $actor);
    }
    /**
     * Sets the ApplicationInfo SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApplicationInfo $applicationInfo
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationInfo(\StructType\ApplicationInfo $applicationInfo, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'applicationInfo', $applicationInfo, $mustUnderstand, $actor);
    }
    /**
     * Sets the PartnerInfo SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\PartnerInfo $partnerInfo
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPartnerInfo(\StructType\PartnerInfo $partnerInfo, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'partnerInfo', $partnerInfo, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named changePassword
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, applicationInfo, partnerInfo
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\ApplicationInfo, \StructType\PartnerInfo
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangePasswordRequest $parameters
     * @return \StructType\ChangePasswordResponse|bool
     */
    public function changePassword(\StructType\ChangePasswordRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->changePassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named changeEmail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, applicationInfo, partnerInfo
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\ApplicationInfo, \StructType\PartnerInfo
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangeEmailRequest $parameters
     * @return \StructType\ChangeEmailResponse|bool
     */
    public function changeEmail(\StructType\ChangeEmailRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->changeEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ChangeEmailResponse|\StructType\ChangePasswordResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
