<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TransactionPaymentEventType EnumType
 * @subpackage Enumerations
 */
class TransactionPaymentEventType extends AbstractStructEnumBase
{
    /**
     * Constant for value '_authentication'
     * @return string '_authentication'
     */
    const VALUE_AUTHENTICATION = '_authentication';
    /**
     * Constant for value '_authorization'
     * @return string '_authorization'
     */
    const VALUE_AUTHORIZATION = '_authorization';
    /**
     * Constant for value '_captureAuthorization'
     * @return string '_captureAuthorization'
     */
    const VALUE_CAPTURE_AUTHORIZATION = '_captureAuthorization';
    /**
     * Constant for value '_credit'
     * @return string '_credit'
     */
    const VALUE_CREDIT = '_credit';
    /**
     * Constant for value '_overrideHold'
     * @return string '_overrideHold'
     */
    const VALUE_OVERRIDE_HOLD = '_overrideHold';
    /**
     * Constant for value '_refreshAuthorization'
     * @return string '_refreshAuthorization'
     */
    const VALUE_REFRESH_AUTHORIZATION = '_refreshAuthorization';
    /**
     * Constant for value '_refund'
     * @return string '_refund'
     */
    const VALUE_REFUND = '_refund';
    /**
     * Constant for value '_sale'
     * @return string '_sale'
     */
    const VALUE_SALE = '_sale';
    /**
     * Constant for value '_voidAuthorization'
     * @return string '_voidAuthorization'
     */
    const VALUE_VOID_AUTHORIZATION = '_voidAuthorization';
    /**
     * Return allowed values
     * @uses self::VALUE_AUTHENTICATION
     * @uses self::VALUE_AUTHORIZATION
     * @uses self::VALUE_CAPTURE_AUTHORIZATION
     * @uses self::VALUE_CREDIT
     * @uses self::VALUE_OVERRIDE_HOLD
     * @uses self::VALUE_REFRESH_AUTHORIZATION
     * @uses self::VALUE_REFUND
     * @uses self::VALUE_SALE
     * @uses self::VALUE_VOID_AUTHORIZATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUTHENTICATION,
            self::VALUE_AUTHORIZATION,
            self::VALUE_CAPTURE_AUTHORIZATION,
            self::VALUE_CREDIT,
            self::VALUE_OVERRIDE_HOLD,
            self::VALUE_REFRESH_AUTHORIZATION,
            self::VALUE_REFUND,
            self::VALUE_SALE,
            self::VALUE_VOID_AUTHORIZATION,
        );
    }
}
