<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SalesOrderOrderStatus EnumType
 * @subpackage Enumerations
 */
class SalesOrderOrderStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value '_pendingApproval'
     * @return string '_pendingApproval'
     */
    const VALUE_PENDING_APPROVAL = '_pendingApproval';
    /**
     * Constant for value '_pendingFulfillment'
     * @return string '_pendingFulfillment'
     */
    const VALUE_PENDING_FULFILLMENT = '_pendingFulfillment';
    /**
     * Constant for value '_cancelled'
     * @return string '_cancelled'
     */
    const VALUE_CANCELLED = '_cancelled';
    /**
     * Constant for value '_partiallyFulfilled'
     * @return string '_partiallyFulfilled'
     */
    const VALUE_PARTIALLY_FULFILLED = '_partiallyFulfilled';
    /**
     * Constant for value '_pendingBillingPartFulfilled'
     * @return string '_pendingBillingPartFulfilled'
     */
    const VALUE_PENDING_BILLING_PART_FULFILLED = '_pendingBillingPartFulfilled';
    /**
     * Constant for value '_pendingBilling'
     * @return string '_pendingBilling'
     */
    const VALUE_PENDING_BILLING = '_pendingBilling';
    /**
     * Constant for value '_fullyBilled'
     * @return string '_fullyBilled'
     */
    const VALUE_FULLY_BILLED = '_fullyBilled';
    /**
     * Constant for value '_closed'
     * @return string '_closed'
     */
    const VALUE_CLOSED = '_closed';
    /**
     * Constant for value '_undefined'
     * @return string '_undefined'
     */
    const VALUE_UNDEFINED = '_undefined';
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING_APPROVAL
     * @uses self::VALUE_PENDING_FULFILLMENT
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_PARTIALLY_FULFILLED
     * @uses self::VALUE_PENDING_BILLING_PART_FULFILLED
     * @uses self::VALUE_PENDING_BILLING
     * @uses self::VALUE_FULLY_BILLED
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_UNDEFINED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING_APPROVAL,
            self::VALUE_PENDING_FULFILLMENT,
            self::VALUE_CANCELLED,
            self::VALUE_PARTIALLY_FULFILLED,
            self::VALUE_PENDING_BILLING_PART_FULFILLED,
            self::VALUE_PENDING_BILLING,
            self::VALUE_FULLY_BILLED,
            self::VALUE_CLOSED,
            self::VALUE_UNDEFINED,
        );
    }
}
