<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for RevenueStatus EnumType
 * @subpackage Enumerations
 */
class RevenueStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value '_pending'
     * @return string '_pending'
     */
    const VALUE_PENDING = '_pending';
    /**
     * Constant for value '_inProgress'
     * @return string '_inProgress'
     */
    const VALUE_IN_PROGRESS = '_inProgress';
    /**
     * Constant for value '_completed'
     * @return string '_completed'
     */
    const VALUE_COMPLETED = '_completed';
    /**
     * Constant for value '_onRevCommitment'
     * @return string '_onRevCommitment'
     */
    const VALUE_ON_REV_COMMITMENT = '_onRevCommitment';
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_ON_REV_COMMITMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING,
            self::VALUE_IN_PROGRESS,
            self::VALUE_COMPLETED,
            self::VALUE_ON_REV_COMMITMENT,
        );
    }
}
