<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PresentationItemType EnumType
 * @subpackage Enumerations
 */
class PresentationItemType extends AbstractStructEnumBase
{
    /**
     * Constant for value '_fileCabinetItem'
     * @return string '_fileCabinetItem'
     */
    const VALUE_FILE_CABINET_ITEM = '_fileCabinetItem';
    /**
     * Constant for value '_informationItem'
     * @return string '_informationItem'
     */
    const VALUE_INFORMATION_ITEM = '_informationItem';
    /**
     * Constant for value '_item'
     * @return string '_item'
     */
    const VALUE_ITEM = '_item';
    /**
     * Constant for value '_presentationCategory'
     * @return string '_presentationCategory'
     */
    const VALUE_PRESENTATION_CATEGORY = '_presentationCategory';
    /**
     * Return allowed values
     * @uses self::VALUE_FILE_CABINET_ITEM
     * @uses self::VALUE_INFORMATION_ITEM
     * @uses self::VALUE_ITEM
     * @uses self::VALUE_PRESENTATION_CATEGORY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FILE_CABINET_ITEM,
            self::VALUE_INFORMATION_ITEM,
            self::VALUE_ITEM,
            self::VALUE_PRESENTATION_CATEGORY,
        );
    }
}
