<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for OpportunityStatus EnumType
 * @subpackage Enumerations
 */
class OpportunityStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value '_closedLost'
     * @return string '_closedLost'
     */
    const VALUE_CLOSED_LOST = '_closedLost';
    /**
     * Constant for value '_closedWon'
     * @return string '_closedWon'
     */
    const VALUE_CLOSED_WON = '_closedWon';
    /**
     * Constant for value '_inProgress'
     * @return string '_inProgress'
     */
    const VALUE_IN_PROGRESS = '_inProgress';
    /**
     * Constant for value '_issuedEstimate'
     * @return string '_issuedEstimate'
     */
    const VALUE_ISSUED_ESTIMATE = '_issuedEstimate';
    /**
     * Return allowed values
     * @uses self::VALUE_CLOSED_LOST
     * @uses self::VALUE_CLOSED_WON
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_ISSUED_ESTIMATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLOSED_LOST,
            self::VALUE_CLOSED_WON,
            self::VALUE_IN_PROGRESS,
            self::VALUE_ISSUED_ESTIMATE,
        );
    }
}
