<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ItemSource EnumType
 * @subpackage Enumerations
 */
class ItemSource extends AbstractStructEnumBase
{
    /**
     * Constant for value '_stock'
     * @return string '_stock'
     */
    const VALUE_STOCK = '_stock';
    /**
     * Constant for value '_phantom'
     * @return string '_phantom'
     */
    const VALUE_PHANTOM = '_phantom';
    /**
     * Constant for value '_workOrder'
     * @return string '_workOrder'
     */
    const VALUE_WORK_ORDER = '_workOrder';
    /**
     * Constant for value '_purchaseOrder'
     * @return string '_purchaseOrder'
     */
    const VALUE_PURCHASE_ORDER = '_purchaseOrder';
    /**
     * Return allowed values
     * @uses self::VALUE_STOCK
     * @uses self::VALUE_PHANTOM
     * @uses self::VALUE_WORK_ORDER
     * @uses self::VALUE_PURCHASE_ORDER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STOCK,
            self::VALUE_PHANTOM,
            self::VALUE_WORK_ORDER,
            self::VALUE_PURCHASE_ORDER,
        );
    }
}
