<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ItemFulfillmentExportTypeUps EnumType
 * @subpackage Enumerations
 */
class ItemFulfillmentExportTypeUps extends AbstractStructEnumBase
{
    /**
     * Constant for value '_domesticExports'
     * @return string '_domesticExports'
     */
    const VALUE_DOMESTIC_EXPORTS = '_domesticExports';
    /**
     * Constant for value '_foreignExports'
     * @return string '_foreignExports'
     */
    const VALUE_FOREIGN_EXPORTS = '_foreignExports';
    /**
     * Constant for value '_foreignMilitarySales'
     * @return string '_foreignMilitarySales'
     */
    const VALUE_FOREIGN_MILITARY_SALES = '_foreignMilitarySales';
    /**
     * Return allowed values
     * @uses self::VALUE_DOMESTIC_EXPORTS
     * @uses self::VALUE_FOREIGN_EXPORTS
     * @uses self::VALUE_FOREIGN_MILITARY_SALES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DOMESTIC_EXPORTS,
            self::VALUE_FOREIGN_EXPORTS,
            self::VALUE_FOREIGN_MILITARY_SALES,
        );
    }
}
