<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ItemDemandSource EnumType
 * @subpackage Enumerations
 */
class ItemDemandSource extends AbstractStructEnumBase
{
    /**
     * Constant for value '_enteredAndPlannedOrders'
     * @return string '_enteredAndPlannedOrders'
     */
    const VALUE_ENTERED_AND_PLANNED_ORDERS = '_enteredAndPlannedOrders';
    /**
     * Constant for value '_forecastAndOrders'
     * @return string '_forecastAndOrders'
     */
    const VALUE_FORECAST_AND_ORDERS = '_forecastAndOrders';
    /**
     * Constant for value '_forecastConsumption'
     * @return string '_forecastConsumption'
     */
    const VALUE_FORECAST_CONSUMPTION = '_forecastConsumption';
    /**
     * Constant for value '_forecastFromDemandPlan'
     * @return string '_forecastFromDemandPlan'
     */
    const VALUE_FORECAST_FROM_DEMAND_PLAN = '_forecastFromDemandPlan';
    /**
     * Return allowed values
     * @uses self::VALUE_ENTERED_AND_PLANNED_ORDERS
     * @uses self::VALUE_FORECAST_AND_ORDERS
     * @uses self::VALUE_FORECAST_CONSUMPTION
     * @uses self::VALUE_FORECAST_FROM_DEMAND_PLAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENTERED_AND_PLANNED_ORDERS,
            self::VALUE_FORECAST_AND_ORDERS,
            self::VALUE_FORECAST_CONSUMPTION,
            self::VALUE_FORECAST_FROM_DEMAND_PLAN,
        );
    }
}
