<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://5139991.suitetalk.api.netsuite.com/wsdl/v2020_1_0/netsuite.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://5139991.suitetalk.api.netsuite.com/wsdl/v2020_1_0/netsuite.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
$change->setSoapHeaderPassport($passport);
$change->setSoapHeaderApplicationInfo($applicationInfo);
$change->setSoapHeaderPartnerInfo($partnerInfo);
/**
 * Sample call for changePassword operation/method
 */
if ($change->changePassword(new \StructType\ChangePasswordRequest()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeEmail operation/method
 */
if ($change->changeEmail(new \StructType\ChangeEmailRequest()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderPassport($passport);
$add->setSoapHeaderTokenPassport($tokenPassport);
$add->setSoapHeaderApplicationInfo($applicationInfo);
$add->setSoapHeaderPartnerInfo($partnerInfo);
$add->setSoapHeaderPreferences($preferences);
/**
 * Sample call for add operation/method
 */
if ($add->add(new \StructType\AddRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addList operation/method
 */
if ($add->addList(new \StructType\AddListRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderPassport($passport);
$delete->setSoapHeaderTokenPassport($tokenPassport);
$delete->setSoapHeaderApplicationInfo($applicationInfo);
$delete->setSoapHeaderPartnerInfo($partnerInfo);
$delete->setSoapHeaderPreferences($preferences);
/**
 * Sample call for delete operation/method
 */
if ($delete->delete(new \StructType\DeleteRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteList operation/method
 */
if ($delete->deleteList(new \StructType\DeleteListRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
$search->setSoapHeaderPassport($passport);
$search->setSoapHeaderTokenPassport($tokenPassport);
$search->setSoapHeaderApplicationInfo($applicationInfo);
$search->setSoapHeaderPartnerInfo($partnerInfo);
$search->setSoapHeaderSearchPreferences($searchPreferences);
/**
 * Sample call for search operation/method
 */
if ($search->search(new \StructType\SearchRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchMoreWithId operation/method
 */
if ($search->searchMoreWithId(new \StructType\SearchMoreWithIdRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderPassport($passport);
$update->setSoapHeaderTokenPassport($tokenPassport);
$update->setSoapHeaderApplicationInfo($applicationInfo);
$update->setSoapHeaderPartnerInfo($partnerInfo);
$update->setSoapHeaderPreferences($preferences);
/**
 * Sample call for update operation/method
 */
if ($update->update(new \StructType\UpdateRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateList operation/method
 */
if ($update->updateList(new \StructType\UpdateListRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateInviteeStatus operation/method
 */
if ($update->updateInviteeStatus(new \StructType\UpdateInviteeStatusRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateInviteeStatusList operation/method
 */
if ($update->updateInviteeStatusList(new \StructType\UpdateInviteeStatusListRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Upsert ServiceType
 */
$upsert = new \ServiceType\Upsert($options);
$upsert->setSoapHeaderPassport($passport);
$upsert->setSoapHeaderTokenPassport($tokenPassport);
$upsert->setSoapHeaderApplicationInfo($applicationInfo);
$upsert->setSoapHeaderPartnerInfo($partnerInfo);
$upsert->setSoapHeaderPreferences($preferences);
/**
 * Sample call for upsert operation/method
 */
if ($upsert->upsert(new \StructType\UpsertRequest()) !== false) {
    print_r($upsert->getResult());
} else {
    print_r($upsert->getLastError());
}
/**
 * Sample call for upsertList operation/method
 */
if ($upsert->upsertList(new \StructType\UpsertListRequest()) !== false) {
    print_r($upsert->getResult());
} else {
    print_r($upsert->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderPassport($passport);
$get->setSoapHeaderTokenPassport($tokenPassport);
$get->setSoapHeaderApplicationInfo($applicationInfo);
$get->setSoapHeaderPartnerInfo($partnerInfo);
$get->setSoapHeaderPreferences($preferences);
/**
 * Sample call for get operation/method
 */
if ($get->get(new \StructType\GetRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getList operation/method
 */
if ($get->getList(new \StructType\GetListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAll operation/method
 */
if ($get->getAll(new \StructType\GetAllRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSavedSearch operation/method
 */
if ($get->getSavedSearch(new \StructType\GetSavedSearchRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCustomizationId operation/method
 */
if ($get->getCustomizationId(new \StructType\GetCustomizationIdRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSelectValue operation/method
 */
if ($get->getSelectValue(new \StructType\GetSelectValueRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getItemAvailability operation/method
 */
if ($get->getItemAvailability(new \StructType\GetItemAvailabilityRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBudgetExchangeRate operation/method
 */
if ($get->getBudgetExchangeRate(new \StructType\GetBudgetExchangeRateRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCurrencyRate operation/method
 */
if ($get->getCurrencyRate(new \StructType\GetCurrencyRateRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDataCenterUrls operation/method
 */
if ($get->getDataCenterUrls(new \StructType\GetDataCenterUrlsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPostingTransactionSummary operation/method
 */
if ($get->getPostingTransactionSummary(new \StructType\GetPostingTransactionSummaryRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getServerTime operation/method
 */
if ($get->getServerTime(new \StructType\GetServerTimeRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAsyncResult operation/method
 */
if ($get->getAsyncResult(new \StructType\GetAsyncResultRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeleted operation/method
 */
if ($get->getDeleted(new \StructType\GetDeletedRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAccountGovernanceInfo operation/method
 */
if ($get->getAccountGovernanceInfo(new \StructType\GetAccountGovernanceInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getIntegrationGovernanceInfo operation/method
 */
if ($get->getIntegrationGovernanceInfo(new \StructType\GetIntegrationGovernanceInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Initialize ServiceType
 */
$initialize = new \ServiceType\Initialize($options);
$initialize->setSoapHeaderPassport($passport);
$initialize->setSoapHeaderTokenPassport($tokenPassport);
$initialize->setSoapHeaderApplicationInfo($applicationInfo);
$initialize->setSoapHeaderPartnerInfo($partnerInfo);
$initialize->setSoapHeaderPreferences($preferences);
/**
 * Sample call for initialize operation/method
 */
if ($initialize->initialize(new \StructType\InitializeRequest()) !== false) {
    print_r($initialize->getResult());
} else {
    print_r($initialize->getLastError());
}
/**
 * Sample call for initializeList operation/method
 */
if ($initialize->initializeList(new \StructType\InitializeListRequest()) !== false) {
    print_r($initialize->getResult());
} else {
    print_r($initialize->getLastError());
}
/**
 * Samples for Attach ServiceType
 */
$attach = new \ServiceType\Attach($options);
$attach->setSoapHeaderPassport($passport);
$attach->setSoapHeaderTokenPassport($tokenPassport);
$attach->setSoapHeaderApplicationInfo($applicationInfo);
$attach->setSoapHeaderPartnerInfo($partnerInfo);
$attach->setSoapHeaderPreferences($preferences);
/**
 * Sample call for attach operation/method
 */
if ($attach->attach(new \StructType\AttachRequest()) !== false) {
    print_r($attach->getResult());
} else {
    print_r($attach->getLastError());
}
/**
 * Samples for Detach ServiceType
 */
$detach = new \ServiceType\Detach($options);
$detach->setSoapHeaderPassport($passport);
$detach->setSoapHeaderTokenPassport($tokenPassport);
$detach->setSoapHeaderApplicationInfo($applicationInfo);
$detach->setSoapHeaderPartnerInfo($partnerInfo);
$detach->setSoapHeaderPreferences($preferences);
/**
 * Sample call for detach operation/method
 */
if ($detach->detach(new \StructType\DetachRequest()) !== false) {
    print_r($detach->getResult());
} else {
    print_r($detach->getLastError());
}
/**
 * Samples for Async ServiceType
 */
$async = new \ServiceType\Async($options);
$async->setSoapHeaderPassport($passport);
$async->setSoapHeaderTokenPassport($tokenPassport);
$async->setSoapHeaderApplicationInfo($applicationInfo);
$async->setSoapHeaderPartnerInfo($partnerInfo);
$async->setSoapHeaderPreferences($preferences);
$async->setSoapHeaderSearchPreferences($searchPreferences);
/**
 * Sample call for asyncAddList operation/method
 */
if ($async->asyncAddList(new \StructType\AsyncAddListRequest()) !== false) {
    print_r($async->getResult());
} else {
    print_r($async->getLastError());
}
/**
 * Sample call for asyncUpdateList operation/method
 */
if ($async->asyncUpdateList(new \StructType\AsyncUpdateListRequest()) !== false) {
    print_r($async->getResult());
} else {
    print_r($async->getLastError());
}
/**
 * Sample call for asyncUpsertList operation/method
 */
if ($async->asyncUpsertList(new \StructType\AsyncUpsertListRequest()) !== false) {
    print_r($async->getResult());
} else {
    print_r($async->getLastError());
}
/**
 * Sample call for asyncDeleteList operation/method
 */
if ($async->asyncDeleteList(new \StructType\AsyncDeleteListRequest()) !== false) {
    print_r($async->getResult());
} else {
    print_r($async->getLastError());
}
/**
 * Sample call for asyncGetList operation/method
 */
if ($async->asyncGetList(new \StructType\AsyncGetListRequest()) !== false) {
    print_r($async->getResult());
} else {
    print_r($async->getLastError());
}
/**
 * Sample call for asyncInitializeList operation/method
 */
if ($async->asyncInitializeList(new \StructType\AsyncInitializeListRequest()) !== false) {
    print_r($async->getResult());
} else {
    print_r($async->getLastError());
}
/**
 * Sample call for asyncSearch operation/method
 */
if ($async->asyncSearch(new \StructType\AsyncSearchRequest()) !== false) {
    print_r($async->getResult());
} else {
    print_r($async->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
$check->setSoapHeaderPassport($passport);
$check->setSoapHeaderTokenPassport($tokenPassport);
$check->setSoapHeaderApplicationInfo($applicationInfo);
$check->setSoapHeaderPartnerInfo($partnerInfo);
$check->setSoapHeaderPreferences($preferences);
/**
 * Sample call for checkAsyncStatus operation/method
 */
if ($check->checkAsyncStatus(new \StructType\CheckAsyncStatusRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
