<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsRoleList StructType
 * @subpackage Structs
 */
class WsRoleList extends AbstractStructBase
{
    /**
     * The wsRole
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WsRole[]
     */
    public $wsRole;
    /**
     * Constructor method for WsRoleList
     * @uses WsRoleList::setWsRole()
     * @param \StructType\WsRole[] $wsRole
     */
    public function __construct(array $wsRole = array())
    {
        $this
            ->setWsRole($wsRole);
    }
    /**
     * Get wsRole value
     * @return \StructType\WsRole[]|null
     */
    public function getWsRole()
    {
        return $this->wsRole;
    }
    /**
     * This method is responsible for validating the values passed to the setWsRole method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWsRole method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWsRoleForArrayConstraintsFromSetWsRole(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $wsRoleListWsRoleItem) {
            // validation for constraint: itemType
            if (!$wsRoleListWsRoleItem instanceof \StructType\WsRole) {
                $invalidValues[] = is_object($wsRoleListWsRoleItem) ? get_class($wsRoleListWsRoleItem) : sprintf('%s(%s)', gettype($wsRoleListWsRoleItem), var_export($wsRoleListWsRoleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The wsRole property can only contain items of type \StructType\WsRole, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set wsRole value
     * @throws \InvalidArgumentException
     * @param \StructType\WsRole[] $wsRole
     * @return \StructType\WsRoleList
     */
    public function setWsRole(array $wsRole = array())
    {
        // validation for constraint: array
        if ('' !== ($wsRoleArrayErrorMessage = self::validateWsRoleForArrayConstraintsFromSetWsRole($wsRole))) {
            throw new \InvalidArgumentException($wsRoleArrayErrorMessage, __LINE__);
        }
        $this->wsRole = $wsRole;
        return $this;
    }
    /**
     * Add item to wsRole value
     * @throws \InvalidArgumentException
     * @param \StructType\WsRole $item
     * @return \StructType\WsRoleList
     */
    public function addToWsRole(\StructType\WsRole $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsRole) {
            throw new \InvalidArgumentException(sprintf('The wsRole property can only contain items of type \StructType\WsRole, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->wsRole[] = $item;
        return $this;
    }
}
