<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WriteResponseList StructType
 * @subpackage Structs
 */
class WriteResponseList extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The writeResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\WriteResponse[]
     */
    public $writeResponse;
    /**
     * Constructor method for WriteResponseList
     * @uses WriteResponseList::setStatus()
     * @uses WriteResponseList::setWriteResponse()
     * @param \StructType\Status $status
     * @param \StructType\WriteResponse[] $writeResponse
     */
    public function __construct(\StructType\Status $status = null, array $writeResponse = array())
    {
        $this
            ->setStatus($status)
            ->setWriteResponse($writeResponse);
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\WriteResponseList
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get writeResponse value
     * @return \StructType\WriteResponse[]|null
     */
    public function getWriteResponse()
    {
        return $this->writeResponse;
    }
    /**
     * This method is responsible for validating the values passed to the setWriteResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWriteResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWriteResponseForArrayConstraintsFromSetWriteResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $writeResponseListWriteResponseItem) {
            // validation for constraint: itemType
            if (!$writeResponseListWriteResponseItem instanceof \StructType\WriteResponse) {
                $invalidValues[] = is_object($writeResponseListWriteResponseItem) ? get_class($writeResponseListWriteResponseItem) : sprintf('%s(%s)', gettype($writeResponseListWriteResponseItem), var_export($writeResponseListWriteResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The writeResponse property can only contain items of type \StructType\WriteResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set writeResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\WriteResponse[] $writeResponse
     * @return \StructType\WriteResponseList
     */
    public function setWriteResponse(array $writeResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($writeResponseArrayErrorMessage = self::validateWriteResponseForArrayConstraintsFromSetWriteResponse($writeResponse))) {
            throw new \InvalidArgumentException($writeResponseArrayErrorMessage, __LINE__);
        }
        $this->writeResponse = $writeResponse;
        return $this;
    }
    /**
     * Add item to writeResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\WriteResponse $item
     * @return \StructType\WriteResponseList
     */
    public function addToWriteResponse(\StructType\WriteResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WriteResponse) {
            throw new \InvalidArgumentException(sprintf('The writeResponse property can only contain items of type \StructType\WriteResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->writeResponse[] = $item;
        return $this;
    }
}
