<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkOrderItem StructType
 * @subpackage Structs
 */
class WorkOrderItem extends AbstractStructBase
{
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The operationSequenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operationSequenceNumber;
    /**
     * The componentYield
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $componentYield;
    /**
     * The bomQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $bomQuantity;
    /**
     * The quantityCommitted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityCommitted;
    /**
     * The quantityBackOrdered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityBackOrdered;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityAvailable;
    /**
     * The averageCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $averageCost;
    /**
     * The lastPurchasePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $lastPurchasePrice;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The orderPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $orderPriority;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The itemSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemSource;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The poVendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $poVendor;
    /**
     * The poRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $poRate;
    /**
     * The percentComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentComplete;
    /**
     * The contribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $contribution;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The commitInventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $commitInventory;
    /**
     * The plannedIssueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $plannedIssueDate;
    /**
     * The orderAllocationStrategy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $orderAllocationStrategy;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for WorkOrderItem
     * @uses WorkOrderItem::setLine()
     * @uses WorkOrderItem::setItem()
     * @uses WorkOrderItem::setOperationSequenceNumber()
     * @uses WorkOrderItem::setComponentYield()
     * @uses WorkOrderItem::setBomQuantity()
     * @uses WorkOrderItem::setQuantityCommitted()
     * @uses WorkOrderItem::setQuantityBackOrdered()
     * @uses WorkOrderItem::setQuantityAvailable()
     * @uses WorkOrderItem::setAverageCost()
     * @uses WorkOrderItem::setLastPurchasePrice()
     * @uses WorkOrderItem::setQuantityOnHand()
     * @uses WorkOrderItem::setQuantity()
     * @uses WorkOrderItem::setUnits()
     * @uses WorkOrderItem::setInventoryDetail()
     * @uses WorkOrderItem::setSerialNumbers()
     * @uses WorkOrderItem::setOrderPriority()
     * @uses WorkOrderItem::setOptions()
     * @uses WorkOrderItem::setItemSource()
     * @uses WorkOrderItem::setDepartment()
     * @uses WorkOrderItem::setClass()
     * @uses WorkOrderItem::setLocation()
     * @uses WorkOrderItem::setPoVendor()
     * @uses WorkOrderItem::setPoRate()
     * @uses WorkOrderItem::setPercentComplete()
     * @uses WorkOrderItem::setContribution()
     * @uses WorkOrderItem::setDescription()
     * @uses WorkOrderItem::setCommitInventory()
     * @uses WorkOrderItem::setPlannedIssueDate()
     * @uses WorkOrderItem::setOrderAllocationStrategy()
     * @uses WorkOrderItem::setCustomFieldList()
     * @param int $line
     * @param \StructType\RecordRef $item
     * @param int $operationSequenceNumber
     * @param float $componentYield
     * @param float $bomQuantity
     * @param float $quantityCommitted
     * @param float $quantityBackOrdered
     * @param float $quantityAvailable
     * @param float $averageCost
     * @param float $lastPurchasePrice
     * @param float $quantityOnHand
     * @param float $quantity
     * @param \StructType\RecordRef $units
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $serialNumbers
     * @param float $orderPriority
     * @param \StructType\CustomFieldList $options
     * @param string $itemSource
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $poVendor
     * @param float $poRate
     * @param float $percentComplete
     * @param float $contribution
     * @param string $description
     * @param string $commitInventory
     * @param string $plannedIssueDate
     * @param \StructType\RecordRef $orderAllocationStrategy
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct($line = null, \StructType\RecordRef $item = null, $operationSequenceNumber = null, $componentYield = null, $bomQuantity = null, $quantityCommitted = null, $quantityBackOrdered = null, $quantityAvailable = null, $averageCost = null, $lastPurchasePrice = null, $quantityOnHand = null, $quantity = null, \StructType\RecordRef $units = null, \StructType\InventoryDetail $inventoryDetail = null, $serialNumbers = null, $orderPriority = null, \StructType\CustomFieldList $options = null, $itemSource = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $poVendor = null, $poRate = null, $percentComplete = null, $contribution = null, $description = null, $commitInventory = null, $plannedIssueDate = null, \StructType\RecordRef $orderAllocationStrategy = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setLine($line)
            ->setItem($item)
            ->setOperationSequenceNumber($operationSequenceNumber)
            ->setComponentYield($componentYield)
            ->setBomQuantity($bomQuantity)
            ->setQuantityCommitted($quantityCommitted)
            ->setQuantityBackOrdered($quantityBackOrdered)
            ->setQuantityAvailable($quantityAvailable)
            ->setAverageCost($averageCost)
            ->setLastPurchasePrice($lastPurchasePrice)
            ->setQuantityOnHand($quantityOnHand)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setInventoryDetail($inventoryDetail)
            ->setSerialNumbers($serialNumbers)
            ->setOrderPriority($orderPriority)
            ->setOptions($options)
            ->setItemSource($itemSource)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setPoVendor($poVendor)
            ->setPoRate($poRate)
            ->setPercentComplete($percentComplete)
            ->setContribution($contribution)
            ->setDescription($description)
            ->setCommitInventory($commitInventory)
            ->setPlannedIssueDate($plannedIssueDate)
            ->setOrderAllocationStrategy($orderAllocationStrategy)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\WorkOrderItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\WorkOrderItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get operationSequenceNumber value
     * @return int|null
     */
    public function getOperationSequenceNumber()
    {
        return $this->operationSequenceNumber;
    }
    /**
     * Set operationSequenceNumber value
     * @param int $operationSequenceNumber
     * @return \StructType\WorkOrderItem
     */
    public function setOperationSequenceNumber($operationSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($operationSequenceNumber) && !(is_int($operationSequenceNumber) || ctype_digit($operationSequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationSequenceNumber, true), gettype($operationSequenceNumber)), __LINE__);
        }
        $this->operationSequenceNumber = $operationSequenceNumber;
        return $this;
    }
    /**
     * Get componentYield value
     * @return float|null
     */
    public function getComponentYield()
    {
        return $this->componentYield;
    }
    /**
     * Set componentYield value
     * @param float $componentYield
     * @return \StructType\WorkOrderItem
     */
    public function setComponentYield($componentYield = null)
    {
        // validation for constraint: float
        if (!is_null($componentYield) && !(is_float($componentYield) || is_numeric($componentYield))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($componentYield, true), gettype($componentYield)), __LINE__);
        }
        $this->componentYield = $componentYield;
        return $this;
    }
    /**
     * Get bomQuantity value
     * @return float|null
     */
    public function getBomQuantity()
    {
        return $this->bomQuantity;
    }
    /**
     * Set bomQuantity value
     * @param float $bomQuantity
     * @return \StructType\WorkOrderItem
     */
    public function setBomQuantity($bomQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($bomQuantity) && !(is_float($bomQuantity) || is_numeric($bomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bomQuantity, true), gettype($bomQuantity)), __LINE__);
        }
        $this->bomQuantity = $bomQuantity;
        return $this;
    }
    /**
     * Get quantityCommitted value
     * @return float|null
     */
    public function getQuantityCommitted()
    {
        return $this->quantityCommitted;
    }
    /**
     * Set quantityCommitted value
     * @param float $quantityCommitted
     * @return \StructType\WorkOrderItem
     */
    public function setQuantityCommitted($quantityCommitted = null)
    {
        // validation for constraint: float
        if (!is_null($quantityCommitted) && !(is_float($quantityCommitted) || is_numeric($quantityCommitted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityCommitted, true), gettype($quantityCommitted)), __LINE__);
        }
        $this->quantityCommitted = $quantityCommitted;
        return $this;
    }
    /**
     * Get quantityBackOrdered value
     * @return float|null
     */
    public function getQuantityBackOrdered()
    {
        return $this->quantityBackOrdered;
    }
    /**
     * Set quantityBackOrdered value
     * @param float $quantityBackOrdered
     * @return \StructType\WorkOrderItem
     */
    public function setQuantityBackOrdered($quantityBackOrdered = null)
    {
        // validation for constraint: float
        if (!is_null($quantityBackOrdered) && !(is_float($quantityBackOrdered) || is_numeric($quantityBackOrdered))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityBackOrdered, true), gettype($quantityBackOrdered)), __LINE__);
        }
        $this->quantityBackOrdered = $quantityBackOrdered;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * Set quantityAvailable value
     * @param float $quantityAvailable
     * @return \StructType\WorkOrderItem
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAvailable) && !(is_float($quantityAvailable) || is_numeric($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get averageCost value
     * @return float|null
     */
    public function getAverageCost()
    {
        return $this->averageCost;
    }
    /**
     * Set averageCost value
     * @param float $averageCost
     * @return \StructType\WorkOrderItem
     */
    public function setAverageCost($averageCost = null)
    {
        // validation for constraint: float
        if (!is_null($averageCost) && !(is_float($averageCost) || is_numeric($averageCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averageCost, true), gettype($averageCost)), __LINE__);
        }
        $this->averageCost = $averageCost;
        return $this;
    }
    /**
     * Get lastPurchasePrice value
     * @return float|null
     */
    public function getLastPurchasePrice()
    {
        return $this->lastPurchasePrice;
    }
    /**
     * Set lastPurchasePrice value
     * @param float $lastPurchasePrice
     * @return \StructType\WorkOrderItem
     */
    public function setLastPurchasePrice($lastPurchasePrice = null)
    {
        // validation for constraint: float
        if (!is_null($lastPurchasePrice) && !(is_float($lastPurchasePrice) || is_numeric($lastPurchasePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lastPurchasePrice, true), gettype($lastPurchasePrice)), __LINE__);
        }
        $this->lastPurchasePrice = $lastPurchasePrice;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\WorkOrderItem
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\WorkOrderItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\WorkOrderItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\WorkOrderItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\WorkOrderItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get orderPriority value
     * @return float|null
     */
    public function getOrderPriority()
    {
        return $this->orderPriority;
    }
    /**
     * Set orderPriority value
     * @param float $orderPriority
     * @return \StructType\WorkOrderItem
     */
    public function setOrderPriority($orderPriority = null)
    {
        // validation for constraint: float
        if (!is_null($orderPriority) && !(is_float($orderPriority) || is_numeric($orderPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderPriority, true), gettype($orderPriority)), __LINE__);
        }
        $this->orderPriority = $orderPriority;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\WorkOrderItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get itemSource value
     * @return string|null
     */
    public function getItemSource()
    {
        return $this->itemSource;
    }
    /**
     * Set itemSource value
     * @uses \EnumType\ItemSource::valueIsValid()
     * @uses \EnumType\ItemSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemSource
     * @return \StructType\WorkOrderItem
     */
    public function setItemSource($itemSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemSource::valueIsValid($itemSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemSource', is_array($itemSource) ? implode(', ', $itemSource) : var_export($itemSource, true), implode(', ', \EnumType\ItemSource::getValidValues())), __LINE__);
        }
        $this->itemSource = $itemSource;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\WorkOrderItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\WorkOrderItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\WorkOrderItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get poVendor value
     * @return \StructType\RecordRef|null
     */
    public function getPoVendor()
    {
        return $this->poVendor;
    }
    /**
     * Set poVendor value
     * @param \StructType\RecordRef $poVendor
     * @return \StructType\WorkOrderItem
     */
    public function setPoVendor(\StructType\RecordRef $poVendor = null)
    {
        $this->poVendor = $poVendor;
        return $this;
    }
    /**
     * Get poRate value
     * @return float|null
     */
    public function getPoRate()
    {
        return $this->poRate;
    }
    /**
     * Set poRate value
     * @param float $poRate
     * @return \StructType\WorkOrderItem
     */
    public function setPoRate($poRate = null)
    {
        // validation for constraint: float
        if (!is_null($poRate) && !(is_float($poRate) || is_numeric($poRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($poRate, true), gettype($poRate)), __LINE__);
        }
        $this->poRate = $poRate;
        return $this;
    }
    /**
     * Get percentComplete value
     * @return float|null
     */
    public function getPercentComplete()
    {
        return $this->percentComplete;
    }
    /**
     * Set percentComplete value
     * @param float $percentComplete
     * @return \StructType\WorkOrderItem
     */
    public function setPercentComplete($percentComplete = null)
    {
        // validation for constraint: float
        if (!is_null($percentComplete) && !(is_float($percentComplete) || is_numeric($percentComplete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentComplete, true), gettype($percentComplete)), __LINE__);
        }
        $this->percentComplete = $percentComplete;
        return $this;
    }
    /**
     * Get contribution value
     * @return float|null
     */
    public function getContribution()
    {
        return $this->contribution;
    }
    /**
     * Set contribution value
     * @param float $contribution
     * @return \StructType\WorkOrderItem
     */
    public function setContribution($contribution = null)
    {
        // validation for constraint: float
        if (!is_null($contribution) && !(is_float($contribution) || is_numeric($contribution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($contribution, true), gettype($contribution)), __LINE__);
        }
        $this->contribution = $contribution;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\WorkOrderItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get commitInventory value
     * @return string|null
     */
    public function getCommitInventory()
    {
        return $this->commitInventory;
    }
    /**
     * Set commitInventory value
     * @uses \EnumType\WorkOrderItemItemCommitInventory::valueIsValid()
     * @uses \EnumType\WorkOrderItemItemCommitInventory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $commitInventory
     * @return \StructType\WorkOrderItem
     */
    public function setCommitInventory($commitInventory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WorkOrderItemItemCommitInventory::valueIsValid($commitInventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WorkOrderItemItemCommitInventory', is_array($commitInventory) ? implode(', ', $commitInventory) : var_export($commitInventory, true), implode(', ', \EnumType\WorkOrderItemItemCommitInventory::getValidValues())), __LINE__);
        }
        $this->commitInventory = $commitInventory;
        return $this;
    }
    /**
     * Get plannedIssueDate value
     * @return string|null
     */
    public function getPlannedIssueDate()
    {
        return $this->plannedIssueDate;
    }
    /**
     * Set plannedIssueDate value
     * @param string $plannedIssueDate
     * @return \StructType\WorkOrderItem
     */
    public function setPlannedIssueDate($plannedIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($plannedIssueDate) && !is_string($plannedIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannedIssueDate, true), gettype($plannedIssueDate)), __LINE__);
        }
        $this->plannedIssueDate = $plannedIssueDate;
        return $this;
    }
    /**
     * Get orderAllocationStrategy value
     * @return \StructType\RecordRef|null
     */
    public function getOrderAllocationStrategy()
    {
        return $this->orderAllocationStrategy;
    }
    /**
     * Set orderAllocationStrategy value
     * @param \StructType\RecordRef $orderAllocationStrategy
     * @return \StructType\WorkOrderItem
     */
    public function setOrderAllocationStrategy(\StructType\RecordRef $orderAllocationStrategy = null)
    {
        $this->orderAllocationStrategy = $orderAllocationStrategy;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\WorkOrderItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
