<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorSearch StructType
 * @subpackage Structs
 */
class VendorSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorSearchBasic
     */
    public $basic;
    /**
     * The accountJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountSearchBasic
     */
    public $accountJoin;
    /**
     * The campaignResponseJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CampaignSearchBasic
     */
    public $campaignResponseJoin;
    /**
     * The contactJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactSearchBasic
     */
    public $contactJoin;
    /**
     * The contactPrimaryJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactSearchBasic
     */
    public $contactPrimaryJoin;
    /**
     * The expAccountJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountSearchBasic
     */
    public $expAccountJoin;
    /**
     * The fileJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FileSearchBasic
     */
    public $fileJoin;
    /**
     * The manufacturingLocationsJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationSearchBasic
     */
    public $manufacturingLocationsJoin;
    /**
     * The messagesJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageSearchBasic
     */
    public $messagesJoin;
    /**
     * The mseSubsidiaryJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MseSubsidiarySearchBasic
     */
    public $mseSubsidiaryJoin;
    /**
     * The messagesFromJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageSearchBasic
     */
    public $messagesFromJoin;
    /**
     * The messagesToJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageSearchBasic
     */
    public $messagesToJoin;
    /**
     * The taxRegistrationJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EntityTaxRegistrationSearchBasic
     */
    public $taxRegistrationJoin;
    /**
     * The timeApproverJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $timeApproverJoin;
    /**
     * The transactionJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $transactionJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $userJoin;
    /**
     * The userNotesJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NoteSearchBasic
     */
    public $userNotesJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for VendorSearch
     * @uses VendorSearch::setBasic()
     * @uses VendorSearch::setAccountJoin()
     * @uses VendorSearch::setCampaignResponseJoin()
     * @uses VendorSearch::setContactJoin()
     * @uses VendorSearch::setContactPrimaryJoin()
     * @uses VendorSearch::setExpAccountJoin()
     * @uses VendorSearch::setFileJoin()
     * @uses VendorSearch::setManufacturingLocationsJoin()
     * @uses VendorSearch::setMessagesJoin()
     * @uses VendorSearch::setMseSubsidiaryJoin()
     * @uses VendorSearch::setMessagesFromJoin()
     * @uses VendorSearch::setMessagesToJoin()
     * @uses VendorSearch::setTaxRegistrationJoin()
     * @uses VendorSearch::setTimeApproverJoin()
     * @uses VendorSearch::setTransactionJoin()
     * @uses VendorSearch::setUserJoin()
     * @uses VendorSearch::setUserNotesJoin()
     * @uses VendorSearch::setCustomSearchJoin()
     * @param \StructType\VendorSearchBasic $basic
     * @param \StructType\AccountSearchBasic $accountJoin
     * @param \StructType\CampaignSearchBasic $campaignResponseJoin
     * @param \StructType\ContactSearchBasic $contactJoin
     * @param \StructType\ContactSearchBasic $contactPrimaryJoin
     * @param \StructType\AccountSearchBasic $expAccountJoin
     * @param \StructType\FileSearchBasic $fileJoin
     * @param \StructType\LocationSearchBasic $manufacturingLocationsJoin
     * @param \StructType\MessageSearchBasic $messagesJoin
     * @param \StructType\MseSubsidiarySearchBasic $mseSubsidiaryJoin
     * @param \StructType\MessageSearchBasic $messagesFromJoin
     * @param \StructType\MessageSearchBasic $messagesToJoin
     * @param \StructType\EntityTaxRegistrationSearchBasic $taxRegistrationJoin
     * @param \StructType\EmployeeSearchBasic $timeApproverJoin
     * @param \StructType\TransactionSearchBasic $transactionJoin
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\VendorSearchBasic $basic = null, \StructType\AccountSearchBasic $accountJoin = null, \StructType\CampaignSearchBasic $campaignResponseJoin = null, \StructType\ContactSearchBasic $contactJoin = null, \StructType\ContactSearchBasic $contactPrimaryJoin = null, \StructType\AccountSearchBasic $expAccountJoin = null, \StructType\FileSearchBasic $fileJoin = null, \StructType\LocationSearchBasic $manufacturingLocationsJoin = null, \StructType\MessageSearchBasic $messagesJoin = null, \StructType\MseSubsidiarySearchBasic $mseSubsidiaryJoin = null, \StructType\MessageSearchBasic $messagesFromJoin = null, \StructType\MessageSearchBasic $messagesToJoin = null, \StructType\EntityTaxRegistrationSearchBasic $taxRegistrationJoin = null, \StructType\EmployeeSearchBasic $timeApproverJoin = null, \StructType\TransactionSearchBasic $transactionJoin = null, \StructType\EmployeeSearchBasic $userJoin = null, \StructType\NoteSearchBasic $userNotesJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setAccountJoin($accountJoin)
            ->setCampaignResponseJoin($campaignResponseJoin)
            ->setContactJoin($contactJoin)
            ->setContactPrimaryJoin($contactPrimaryJoin)
            ->setExpAccountJoin($expAccountJoin)
            ->setFileJoin($fileJoin)
            ->setManufacturingLocationsJoin($manufacturingLocationsJoin)
            ->setMessagesJoin($messagesJoin)
            ->setMseSubsidiaryJoin($mseSubsidiaryJoin)
            ->setMessagesFromJoin($messagesFromJoin)
            ->setMessagesToJoin($messagesToJoin)
            ->setTaxRegistrationJoin($taxRegistrationJoin)
            ->setTimeApproverJoin($timeApproverJoin)
            ->setTransactionJoin($transactionJoin)
            ->setUserJoin($userJoin)
            ->setUserNotesJoin($userNotesJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\VendorSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\VendorSearchBasic $basic
     * @return \StructType\VendorSearch
     */
    public function setBasic(\StructType\VendorSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get accountJoin value
     * @return \StructType\AccountSearchBasic|null
     */
    public function getAccountJoin()
    {
        return $this->accountJoin;
    }
    /**
     * Set accountJoin value
     * @param \StructType\AccountSearchBasic $accountJoin
     * @return \StructType\VendorSearch
     */
    public function setAccountJoin(\StructType\AccountSearchBasic $accountJoin = null)
    {
        $this->accountJoin = $accountJoin;
        return $this;
    }
    /**
     * Get campaignResponseJoin value
     * @return \StructType\CampaignSearchBasic|null
     */
    public function getCampaignResponseJoin()
    {
        return $this->campaignResponseJoin;
    }
    /**
     * Set campaignResponseJoin value
     * @param \StructType\CampaignSearchBasic $campaignResponseJoin
     * @return \StructType\VendorSearch
     */
    public function setCampaignResponseJoin(\StructType\CampaignSearchBasic $campaignResponseJoin = null)
    {
        $this->campaignResponseJoin = $campaignResponseJoin;
        return $this;
    }
    /**
     * Get contactJoin value
     * @return \StructType\ContactSearchBasic|null
     */
    public function getContactJoin()
    {
        return $this->contactJoin;
    }
    /**
     * Set contactJoin value
     * @param \StructType\ContactSearchBasic $contactJoin
     * @return \StructType\VendorSearch
     */
    public function setContactJoin(\StructType\ContactSearchBasic $contactJoin = null)
    {
        $this->contactJoin = $contactJoin;
        return $this;
    }
    /**
     * Get contactPrimaryJoin value
     * @return \StructType\ContactSearchBasic|null
     */
    public function getContactPrimaryJoin()
    {
        return $this->contactPrimaryJoin;
    }
    /**
     * Set contactPrimaryJoin value
     * @param \StructType\ContactSearchBasic $contactPrimaryJoin
     * @return \StructType\VendorSearch
     */
    public function setContactPrimaryJoin(\StructType\ContactSearchBasic $contactPrimaryJoin = null)
    {
        $this->contactPrimaryJoin = $contactPrimaryJoin;
        return $this;
    }
    /**
     * Get expAccountJoin value
     * @return \StructType\AccountSearchBasic|null
     */
    public function getExpAccountJoin()
    {
        return $this->expAccountJoin;
    }
    /**
     * Set expAccountJoin value
     * @param \StructType\AccountSearchBasic $expAccountJoin
     * @return \StructType\VendorSearch
     */
    public function setExpAccountJoin(\StructType\AccountSearchBasic $expAccountJoin = null)
    {
        $this->expAccountJoin = $expAccountJoin;
        return $this;
    }
    /**
     * Get fileJoin value
     * @return \StructType\FileSearchBasic|null
     */
    public function getFileJoin()
    {
        return $this->fileJoin;
    }
    /**
     * Set fileJoin value
     * @param \StructType\FileSearchBasic $fileJoin
     * @return \StructType\VendorSearch
     */
    public function setFileJoin(\StructType\FileSearchBasic $fileJoin = null)
    {
        $this->fileJoin = $fileJoin;
        return $this;
    }
    /**
     * Get manufacturingLocationsJoin value
     * @return \StructType\LocationSearchBasic|null
     */
    public function getManufacturingLocationsJoin()
    {
        return $this->manufacturingLocationsJoin;
    }
    /**
     * Set manufacturingLocationsJoin value
     * @param \StructType\LocationSearchBasic $manufacturingLocationsJoin
     * @return \StructType\VendorSearch
     */
    public function setManufacturingLocationsJoin(\StructType\LocationSearchBasic $manufacturingLocationsJoin = null)
    {
        $this->manufacturingLocationsJoin = $manufacturingLocationsJoin;
        return $this;
    }
    /**
     * Get messagesJoin value
     * @return \StructType\MessageSearchBasic|null
     */
    public function getMessagesJoin()
    {
        return $this->messagesJoin;
    }
    /**
     * Set messagesJoin value
     * @param \StructType\MessageSearchBasic $messagesJoin
     * @return \StructType\VendorSearch
     */
    public function setMessagesJoin(\StructType\MessageSearchBasic $messagesJoin = null)
    {
        $this->messagesJoin = $messagesJoin;
        return $this;
    }
    /**
     * Get mseSubsidiaryJoin value
     * @return \StructType\MseSubsidiarySearchBasic|null
     */
    public function getMseSubsidiaryJoin()
    {
        return $this->mseSubsidiaryJoin;
    }
    /**
     * Set mseSubsidiaryJoin value
     * @param \StructType\MseSubsidiarySearchBasic $mseSubsidiaryJoin
     * @return \StructType\VendorSearch
     */
    public function setMseSubsidiaryJoin(\StructType\MseSubsidiarySearchBasic $mseSubsidiaryJoin = null)
    {
        $this->mseSubsidiaryJoin = $mseSubsidiaryJoin;
        return $this;
    }
    /**
     * Get messagesFromJoin value
     * @return \StructType\MessageSearchBasic|null
     */
    public function getMessagesFromJoin()
    {
        return $this->messagesFromJoin;
    }
    /**
     * Set messagesFromJoin value
     * @param \StructType\MessageSearchBasic $messagesFromJoin
     * @return \StructType\VendorSearch
     */
    public function setMessagesFromJoin(\StructType\MessageSearchBasic $messagesFromJoin = null)
    {
        $this->messagesFromJoin = $messagesFromJoin;
        return $this;
    }
    /**
     * Get messagesToJoin value
     * @return \StructType\MessageSearchBasic|null
     */
    public function getMessagesToJoin()
    {
        return $this->messagesToJoin;
    }
    /**
     * Set messagesToJoin value
     * @param \StructType\MessageSearchBasic $messagesToJoin
     * @return \StructType\VendorSearch
     */
    public function setMessagesToJoin(\StructType\MessageSearchBasic $messagesToJoin = null)
    {
        $this->messagesToJoin = $messagesToJoin;
        return $this;
    }
    /**
     * Get taxRegistrationJoin value
     * @return \StructType\EntityTaxRegistrationSearchBasic|null
     */
    public function getTaxRegistrationJoin()
    {
        return $this->taxRegistrationJoin;
    }
    /**
     * Set taxRegistrationJoin value
     * @param \StructType\EntityTaxRegistrationSearchBasic $taxRegistrationJoin
     * @return \StructType\VendorSearch
     */
    public function setTaxRegistrationJoin(\StructType\EntityTaxRegistrationSearchBasic $taxRegistrationJoin = null)
    {
        $this->taxRegistrationJoin = $taxRegistrationJoin;
        return $this;
    }
    /**
     * Get timeApproverJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getTimeApproverJoin()
    {
        return $this->timeApproverJoin;
    }
    /**
     * Set timeApproverJoin value
     * @param \StructType\EmployeeSearchBasic $timeApproverJoin
     * @return \StructType\VendorSearch
     */
    public function setTimeApproverJoin(\StructType\EmployeeSearchBasic $timeApproverJoin = null)
    {
        $this->timeApproverJoin = $timeApproverJoin;
        return $this;
    }
    /**
     * Get transactionJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getTransactionJoin()
    {
        return $this->transactionJoin;
    }
    /**
     * Set transactionJoin value
     * @param \StructType\TransactionSearchBasic $transactionJoin
     * @return \StructType\VendorSearch
     */
    public function setTransactionJoin(\StructType\TransactionSearchBasic $transactionJoin = null)
    {
        $this->transactionJoin = $transactionJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @return \StructType\VendorSearch
     */
    public function setUserJoin(\StructType\EmployeeSearchBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get userNotesJoin value
     * @return \StructType\NoteSearchBasic|null
     */
    public function getUserNotesJoin()
    {
        return $this->userNotesJoin;
    }
    /**
     * Set userNotesJoin value
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @return \StructType\VendorSearch
     */
    public function setUserNotesJoin(\StructType\NoteSearchBasic $userNotesJoin = null)
    {
        $this->userNotesJoin = $userNotesJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$vendorSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($vendorSearchCustomSearchJoinItem) ? get_class($vendorSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($vendorSearchCustomSearchJoinItem), var_export($vendorSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\VendorSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\VendorSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
