<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorRolesList StructType
 * @subpackage Structs
 */
class VendorRolesList extends AbstractStructBase
{
    /**
     * The roles
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VendorRoles[]
     */
    public $roles;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for VendorRolesList
     * @uses VendorRolesList::setRoles()
     * @uses VendorRolesList::setReplaceAll()
     * @param \StructType\VendorRoles[] $roles
     * @param bool $replaceAll
     */
    public function __construct(array $roles = array(), $replaceAll = true)
    {
        $this
            ->setRoles($roles)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get roles value
     * @return \StructType\VendorRoles[]|null
     */
    public function getRoles()
    {
        return $this->roles;
    }
    /**
     * This method is responsible for validating the values passed to the setRoles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoles method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRolesForArrayConstraintsFromSetRoles(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorRolesListRolesItem) {
            // validation for constraint: itemType
            if (!$vendorRolesListRolesItem instanceof \StructType\VendorRoles) {
                $invalidValues[] = is_object($vendorRolesListRolesItem) ? get_class($vendorRolesListRolesItem) : sprintf('%s(%s)', gettype($vendorRolesListRolesItem), var_export($vendorRolesListRolesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The roles property can only contain items of type \StructType\VendorRoles, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set roles value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorRoles[] $roles
     * @return \StructType\VendorRolesList
     */
    public function setRoles(array $roles = array())
    {
        // validation for constraint: array
        if ('' !== ($rolesArrayErrorMessage = self::validateRolesForArrayConstraintsFromSetRoles($roles))) {
            throw new \InvalidArgumentException($rolesArrayErrorMessage, __LINE__);
        }
        $this->roles = $roles;
        return $this;
    }
    /**
     * Add item to roles value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorRoles $item
     * @return \StructType\VendorRolesList
     */
    public function addToRoles(\StructType\VendorRoles $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorRoles) {
            throw new \InvalidArgumentException(sprintf('The roles property can only contain items of type \StructType\VendorRoles, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->roles[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\VendorRolesList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
