<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorPricingSchedule StructType
 * @subpackage Structs
 */
class VendorPricingSchedule extends AbstractStructBase
{
    /**
     * The scheduleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $scheduleName;
    /**
     * The scheduleDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $scheduleDiscount;
    /**
     * Constructor method for VendorPricingSchedule
     * @uses VendorPricingSchedule::setScheduleName()
     * @uses VendorPricingSchedule::setScheduleDiscount()
     * @param string $scheduleName
     * @param float $scheduleDiscount
     */
    public function __construct($scheduleName = null, $scheduleDiscount = null)
    {
        $this
            ->setScheduleName($scheduleName)
            ->setScheduleDiscount($scheduleDiscount);
    }
    /**
     * Get scheduleName value
     * @return string|null
     */
    public function getScheduleName()
    {
        return $this->scheduleName;
    }
    /**
     * Set scheduleName value
     * @param string $scheduleName
     * @return \StructType\VendorPricingSchedule
     */
    public function setScheduleName($scheduleName = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleName) && !is_string($scheduleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduleName, true), gettype($scheduleName)), __LINE__);
        }
        $this->scheduleName = $scheduleName;
        return $this;
    }
    /**
     * Get scheduleDiscount value
     * @return float|null
     */
    public function getScheduleDiscount()
    {
        return $this->scheduleDiscount;
    }
    /**
     * Set scheduleDiscount value
     * @param float $scheduleDiscount
     * @return \StructType\VendorPricingSchedule
     */
    public function setScheduleDiscount($scheduleDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($scheduleDiscount) && !(is_float($scheduleDiscount) || is_numeric($scheduleDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scheduleDiscount, true), gettype($scheduleDiscount)), __LINE__);
        }
        $this->scheduleDiscount = $scheduleDiscount;
        return $this;
    }
}
